/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.jaspira.propertybrowser.editor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.openbp.common.string.StringUtil;
import org.openbp.common.string.parser.StringParser;
import org.openbp.common.util.iterator.EmptyIterator;
import org.openbp.jaspira.propertybrowser.editor.PropertyEditor;

public class EditorParameterParser {
    private PropertyEditor editor;
    private Map map;

    public EditorParameterParser(PropertyEditor editor) {
        this.editor = editor;
        this.map = new HashMap();
        this.parse(editor.getParams());
    }

    public Iterator get(String identifier) {
        List values = (List)this.map.get(identifier);
        if (values != null) {
            return values.iterator();
        }
        return EmptyIterator.getInstance();
    }

    public String getString(String identifier) {
        List values = (List)this.map.get(identifier);
        if (values != null && values.size() > 0) {
            return values.get(0).toString();
        }
        return null;
    }

    public static String determineDisplayValue(String parameterValue) {
        int index = parameterValue.indexOf(124);
        String s = index < 0 ? parameterValue : parameterValue.substring(0, index);
        return StringUtil.trimNull((String)s);
    }

    public static String determineInternalValue(String parameterValue) {
        int index = parameterValue.indexOf(124);
        String s = index < 0 ? parameterValue : parameterValue.substring(index + 1);
        return StringUtil.trimNull((String)s);
    }

    public int numberOfEntries(String identifier) {
        List values = (List)this.map.get(identifier);
        if (values != null) {
            return values.size();
        }
        return -1;
    }

    protected void add(String identifier, String value) {
        ArrayList<String> values = (ArrayList<String>)this.map.get(identifier);
        if (values == null) {
            values = new ArrayList<String>();
            this.map.put(identifier, values);
        }
        values.add(value);
    }

    protected void parse(String parameters) {
        if (parameters == null) {
            return;
        }
        StringParser sp = new StringParser(parameters);
        sp.skipSpace();
        while (!sp.isEnd()) {
            String identifier = sp.getIdentifier();
            if (identifier == null) {
                System.err.println("Property '" + this.editor.getPropertyName() + "': Missing property editor parameter identifier");
                return;
            }
            sp.skipSpace();
            String value = null;
            if (sp.getChar() == '=') {
                sp.nextChar();
                value = sp.getString('\u0000');
                if (value == null) {
                    System.err.println("Property '" + this.editor.getPropertyName() + "': Invalid string constant");
                }
                sp.skipSpace();
            }
            this.add(identifier, value);
        }
    }
}

