/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.jaspira.propertybrowser.editor.standard;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import org.openbp.common.ExceptionUtil;
import org.openbp.common.string.StringUtil;
import org.openbp.jaspira.propertybrowser.editor.AbstractPropertyEditor;
import org.openbp.jaspira.propertybrowser.editor.EditorParameterParser;
import org.openbp.swing.components.treetable.JTreeTable;
import org.openbp.swing.plaf.sky.SimpleBorder;

public class MultiLineStringEditor
extends AbstractPropertyEditor
implements DocumentListener {
    protected JTextArea textArea;
    private boolean settingValue;
    private int lines = 3;

    @Override
    protected void parseParams(EditorParameterParser parser) {
        String linesStr = parser.getString("lines");
        if (linesStr != null) {
            try {
                this.lines = Integer.parseInt(linesStr);
            }
            catch (NumberFormatException e) {
                ExceptionUtil.printTrace((Throwable)e);
            }
        }
    }

    @Override
    public void createComponent() {
        this.textArea = new JTextArea();
        this.textArea.setLineWrap(true);
        this.textArea.setWrapStyleWord(true);
        this.textArea.setTabSize(4);
        this.textArea.setBorder(null);
        this.textArea.setEditable(!this.readonly);
        if (this.readonly) {
            this.textArea.setBackground(((JTreeTable)this.getPropertyBrowser()).getBackground());
        }
        this.textArea.addKeyListener(this);
        this.textArea.getDocument().addDocumentListener(this);
        this.textArea.addFocusListener(this);
        if (this.propertyBrowser != null) {
            this.propertyBrowser.configureSubComponent(this.textArea);
        }
        JScrollPane sp = new JScrollPane(this.textArea);
        sp.setBorder((Border)SimpleBorder.getStandardBorder());
        sp.addFocusListener(new FocusDelegator());
        Dimension size = this.determineSize(this.textArea);
        sp.setPreferredSize(size);
        this.component = sp;
    }

    @Override
    public Object getComponentValue() {
        if (this.textArea == null) {
            return null;
        }
        String text = this.textArea.getText();
        text = StringUtil.trimNull((String)text);
        return text;
    }

    @Override
    public void setComponentValue() {
        this.initializeComponent();
        this.settingValue = true;
        this.textArea.setText(this.getSafeString(this.value));
        this.settingValue = false;
        this.resetScrollPos();
    }

    @Override
    public void highlight(boolean on) {
        if (this.component != null && this.component.getParent() != null) {
            boolean show;
            boolean bl = show = on && (this.component.hasFocus() || this.textArea.hasFocus());
            if (show) {
                int len = this.textArea.getText().length();
                this.textArea.setCaretPosition(len);
                this.textArea.setSelectionStart(0);
                this.textArea.setSelectionEnd(len);
            } else {
                this.textArea.setCaretPosition(0);
                this.textArea.setSelectionStart(0);
                this.textArea.setSelectionEnd(0);
            }
            this.textArea.getCaret().setVisible(show);
            this.textArea.getCaret().setSelectionVisible(show);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MultiLineStringEditor.this.textArea.repaint();
                }
            });
        }
    }

    private void resetScrollPos() {
        this.textArea.setCaretPosition(0);
        this.component.scrollRectToVisible(new Rectangle(0, 0, 1, 1));
    }

    private Dimension determineSize(JTextArea textArea) {
        int lineHeight = textArea.getFont().getSize() + 5;
        return new Dimension(textArea.getPreferredSize().width, this.lines * lineHeight);
    }

    private boolean isCompletelySelected(JTextArea textArea) {
        int textLength;
        int selLength = textArea.getSelectionEnd() - textArea.getSelectionStart();
        return selLength == (textLength = textArea.getText().length());
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        if (!this.settingValue) {
            this.propertyChanged();
        }
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        if (!this.settingValue) {
            this.propertyChanged();
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        if (!this.settingValue) {
            this.propertyChanged();
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.resetScrollPos();
        super.focusLost(e);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        int keyCode = e.getKeyCode();
        boolean shiftPressed = e.isShiftDown();
        switch (keyCode) {
            case 32: {
                if (!shiftPressed) break;
                e.consume();
                return;
            }
            case 9: 
            case 10: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                int pos = this.textArea.getCaretPosition();
                int selSize = this.textArea.getSelectionEnd() - this.textArea.getSelectionStart();
                switch (keyCode) {
                    case 37: {
                        if (pos == 0 && !shiftPressed && selSize == 0) {
                            this.forwardKeyEvent(e);
                            return;
                        }
                        return;
                    }
                    case 39: {
                        if (pos == this.textArea.getText().length() && !shiftPressed && selSize == 0) {
                            this.forwardKeyEvent(e);
                            return;
                        }
                        return;
                    }
                    case 36: {
                        if (pos == 0 && !shiftPressed && selSize == 0) {
                            this.forwardKeyEvent(e);
                            return;
                        }
                        int newPos = 0;
                        if (!this.isCompletelySelected(this.textArea)) {
                            try {
                                int currentLine = this.textArea.getLineOfOffset(pos);
                                int linePos = this.textArea.getLineStartOffset(currentLine);
                                if (linePos != pos) {
                                    newPos = linePos;
                                }
                            }
                            catch (BadLocationException ex) {
                                // empty catch block
                            }
                        }
                        if (shiftPressed) {
                            this.textArea.setCaretPosition(newPos);
                            this.textArea.setSelectionStart(newPos);
                            this.textArea.setSelectionEnd(pos);
                        } else {
                            this.textArea.setCaretPosition(newPos);
                        }
                        e.consume();
                        return;
                    }
                    case 35: {
                        int len = this.textArea.getText().length();
                        if (pos == len && !shiftPressed && selSize == 0) {
                            this.forwardKeyEvent(e);
                            return;
                        }
                        int newPos = len;
                        if (!this.isCompletelySelected(this.textArea)) {
                            try {
                                int currentLine = this.textArea.getLineOfOffset(pos);
                                int linePos = this.textArea.getLineEndOffset(currentLine);
                                if (linePos != pos) {
                                    newPos = linePos;
                                }
                            }
                            catch (BadLocationException ex) {
                                // empty catch block
                            }
                        }
                        if (shiftPressed) {
                            this.textArea.setCaretPosition(newPos);
                            this.textArea.setSelectionStart(pos);
                            this.textArea.setSelectionEnd(newPos);
                        } else {
                            this.textArea.setCaretPosition(newPos);
                        }
                        e.consume();
                        return;
                    }
                    case 38: {
                        if (this.isCompletelySelected(this.textArea)) {
                            this.forwardKeyEvent(e);
                            return;
                        }
                        return;
                    }
                    case 40: {
                        if (this.isCompletelySelected(this.textArea)) {
                            this.forwardKeyEvent(e);
                            return;
                        }
                        return;
                    }
                    case 9: {
                        if (e.isControlDown()) {
                            this.textArea.insert("\t", pos);
                            e.consume();
                        } else {
                            this.forwardKeyEvent(e);
                        }
                        return;
                    }
                    case 10: {
                        if (e.isControlDown()) {
                            this.textArea.insert("\n", pos);
                            e.consume();
                        } else {
                            this.forwardKeyEvent(e);
                        }
                        return;
                    }
                }
            }
        }
        super.keyPressed(e);
    }

    class FocusDelegator
    extends FocusAdapter {
        FocusDelegator() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            if (e.getSource() instanceof JScrollPane && MultiLineStringEditor.this.textArea != null) {
                MultiLineStringEditor.this.textArea.requestFocus();
            }
        }
    }
}

