/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.jaspira.propertybrowser.editor.standard;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.openbp.common.CommonUtil;
import org.openbp.common.generic.description.DescriptionObject;
import org.openbp.common.generic.description.DescriptionObjectImpl;
import org.openbp.common.string.StringUtil;
import org.openbp.common.util.iterator.EmptyIterator;
import org.openbp.jaspira.propertybrowser.editor.AbstractPropertyEditor;
import org.openbp.jaspira.propertybrowser.editor.EditorParameterParser;
import org.openbp.jaspira.propertybrowser.editor.standard.SelectionEditorListener;
import org.openbp.swing.components.popupfield.JSelectionField;
import org.openbp.swing.components.popupfield.PopupEvent;
import org.openbp.swing.components.popupfield.PopupListener;

public class SelectionEditor
extends AbstractPropertyEditor
implements ActionListener,
PopupListener,
DocumentListener {
    private boolean settingValue;
    private boolean editable;
    private JTextField textField;
    private List selectionValueList;

    @Override
    protected void parseParams(EditorParameterParser parser) {
        String editableStr = parser.getString("editable");
        if (editableStr != null && editableStr.equalsIgnoreCase("true")) {
            this.editable = true;
        }
        Iterator iter = parser.get("selection");
        while (iter.hasNext()) {
            String param = (String)iter.next();
            String selectionName = EditorParameterParser.determineInternalValue(param);
            String selectionValue = EditorParameterParser.determineDisplayValue(param);
            this.addSelectionValue(selectionName, selectionValue);
        }
    }

    @Override
    public void createComponent() {
        JSelectionField c = new JSelectionField();
        c.setEditable(this.editable && !this.readonly);
        this.textField = c.getTextField();
        if (this.selectionValueList != null && !this.readonly) {
            int n = this.selectionValueList.size();
            for (int i = 0; i < n; ++i) {
                DescriptionObject d = (DescriptionObject)this.selectionValueList.get(i);
                String name = d.getName();
                String text = d.getDescription();
                if (text != null) {
                    c.addItem(text, (Object)name);
                    continue;
                }
                c.addItem((Object)name);
            }
        }
        c.addFocusListener((FocusListener)this);
        if (!this.readonly) {
            c.addActionListener((ActionListener)this);
            c.addKeyListener((KeyListener)this);
            c.addPopupListener((PopupListener)this);
        }
        this.textField.addKeyListener(this);
        this.textField.getDocument().addDocumentListener(this);
        this.textField.addFocusListener(this);
        if (this.propertyBrowser != null) {
            this.propertyBrowser.configureSubComponent(this.textField);
        }
        this.component = c;
    }

    @Override
    public void setComponentValue() {
        this.initializeComponent();
        String v = this.getSafeString(this.value);
        if (this.component instanceof JLabel) {
            String display = this.determineDisplayValueFor(v);
            if (display == null) {
                display = "";
            }
            ((JLabel)this.component).setText(display);
        } else {
            this.settingValue = true;
            JSelectionField c = (JSelectionField)this.component;
            c.setSelectedItem((Object)v);
            this.settingValue = false;
        }
    }

    @Override
    public Object getComponentValue() {
        if (this.component == null) {
            return null;
        }
        String text = null;
        if (this.editable) {
            text = this.textField.getText();
            text = StringUtil.trimNull((String)text);
            text = this.determineInternalValueFor(text);
        } else {
            text = (String)((JSelectionField)this.component).getSelectedItem();
        }
        return text;
    }

    @Override
    public void highlight(boolean on) {
        if (this.editable) {
            boolean show;
            boolean bl = show = on && this.textField.hasFocus();
            if (show) {
                this.textField.setSelectionStart(0);
                int length = this.textField.getText().length();
                this.textField.setSelectionEnd(length);
            } else {
                this.textField.setSelectionStart(0);
                this.textField.setSelectionEnd(0);
            }
            this.textField.getCaret().setVisible(show);
            this.textField.getCaret().setSelectionVisible(show);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SelectionEditor.this.textField.repaint();
                }
            });
        } else {
            JSelectionField selectionField = (JSelectionField)this.component;
            if (on && this.textField.hasFocus()) {
                selectionField.setHighlight();
            } else {
                selectionField.resetHighlight();
            }
        }
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public Iterator getSelectionValues() {
        if (this.selectionValueList == null) {
            return EmptyIterator.getInstance();
        }
        return this.selectionValueList.iterator();
    }

    public int getNumberOfSelectionValues() {
        return this.selectionValueList != null ? this.selectionValueList.size() : 0;
    }

    public DescriptionObject getSelectionValueAt(int index) {
        return (DescriptionObject)this.selectionValueList.get(index);
    }

    public void addSelectionValue(String selectionName, String selectionValue) {
        this.addSelectionValue((DescriptionObject)new DescriptionObjectImpl(selectionName, selectionValue));
    }

    public void addSelectionValue(String selectionName) {
        this.addSelectionValue((DescriptionObject)new DescriptionObjectImpl(selectionName));
    }

    public void addSelectionValue(DescriptionObject selectionValue) {
        if (this.selectionValueList == null) {
            this.selectionValueList = new ArrayList();
        }
        this.selectionValueList.add(selectionValue);
    }

    public void clearSelectionValues() {
        this.selectionValueList = null;
    }

    public List getSelectionValueList() {
        return this.selectionValueList;
    }

    public void setSelectionValueList(List selectionValueList) {
        this.selectionValueList = selectionValueList;
    }

    private String determineDisplayValueFor(String s) {
        if (this.selectionValueList != null) {
            int n = this.selectionValueList.size();
            for (int i = 0; i < n; ++i) {
                DescriptionObject d = (DescriptionObject)this.selectionValueList.get(i);
                String name = d.getName();
                if (!CommonUtil.equalsNull((Object)name, (Object)s)) continue;
                return d.getDescription();
            }
        }
        return s;
    }

    private String determineInternalValueFor(String s) {
        if (this.selectionValueList != null) {
            int n = this.selectionValueList.size();
            for (int i = 0; i < n; ++i) {
                DescriptionObject d = (DescriptionObject)this.selectionValueList.get(i);
                String desc = d.getDescription();
                if (!CommonUtil.equalsNull((Object)desc, (Object)s)) continue;
                return d.getName();
            }
        }
        return s;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (!this.settingValue) {
            this.propertyChanged();
            this.saveProperty();
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        if (!this.settingValue) {
            this.propertyChanged();
        }
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        if (!this.settingValue) {
            this.propertyChanged();
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        if (!this.settingValue) {
            this.propertyChanged();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void keyPressed(KeyEvent e) {
        int keyCode = e.getKeyCode();
        JSelectionField selectionField = (JSelectionField)this.component;
        switch (keyCode) {
            case 27: {
                if (!selectionField.isPopupVisible()) break;
                selectionField.setPopupVisible(false);
                e.consume();
                return;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                JTextComponent tf = null;
                boolean shiftPressed = e.isShiftDown();
                Object sourceObject = e.getSource();
                if (selectionField.isPopupVisible()) {
                    return;
                }
                if (sourceObject != null && sourceObject.equals(this.textField)) {
                    tf = (JTextField)sourceObject;
                }
                int pos = tf != null ? tf.getCaretPosition() : 0;
                int selSize = tf != null ? tf.getSelectionEnd() - tf.getSelectionStart() : 0;
                switch (keyCode) {
                    case 37: {
                        if (tf == null || pos == 0 && !shiftPressed && selSize == 0) {
                            this.forwardKeyEvent(e);
                            return;
                        }
                        return;
                    }
                    case 39: {
                        if (tf == null || pos == tf.getText().length() && !shiftPressed && selSize == 0) {
                            this.forwardKeyEvent(e);
                            return;
                        }
                        return;
                    }
                    case 36: {
                        if (tf == null || pos == 0 && !shiftPressed && selSize == 0) {
                            this.forwardKeyEvent(e);
                            return;
                        }
                        if (shiftPressed) {
                            tf.setCaretPosition(0);
                            tf.setSelectionStart(0);
                            tf.setSelectionEnd(pos);
                        } else {
                            tf.setCaretPosition(0);
                        }
                        e.consume();
                        return;
                    }
                    case 35: {
                        if (tf == null || pos == tf.getText().length() && !shiftPressed && selSize == 0) {
                            this.forwardKeyEvent(e);
                            return;
                        }
                        int len = tf.getText().length();
                        if (shiftPressed) {
                            tf.setSelectionStart(pos);
                            tf.setSelectionEnd(len);
                        } else {
                            tf.setCaretPosition(len);
                        }
                        e.consume();
                        return;
                    }
                    case 38: 
                    case 40: {
                        if (!e.isControlDown() && !e.isAltDown() && !e.isAltGraphDown()) break;
                        return;
                    }
                }
                break;
            }
        }
        super.keyPressed(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void popupStateChanged(PopupEvent e) {
        if (this.listener != null) {
            this.settingValue = true;
            try {
                ((SelectionEditorListener)this.listener).popup(this, e.getCause());
            }
            finally {
                this.settingValue = false;
            }
        }
    }
}

