/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.jaspira.propertybrowser.editor.standard;

import java.awt.Color;
import java.awt.event.KeyEvent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openbp.common.string.StringUtil;
import org.openbp.jaspira.propertybrowser.editor.AbstractPropertyEditor;
import org.openbp.swing.components.treetable.JTreeTable;

public class StringEditor
extends AbstractPropertyEditor
implements DocumentListener {
    protected JTextField textField;
    private boolean settingValue;

    @Override
    public void createComponent() {
        if (this.readonly) {
            this.textField = new JTextField();
            this.textField.setEditable(false);
            this.textField.addKeyListener(this);
            this.textField.addFocusListener(this);
            this.textField.setBackground(((JTreeTable)this.getPropertyBrowser()).getBackground());
            this.textField.setSelectionColor(Color.LIGHT_GRAY);
            this.component = this.textField;
        } else {
            this.textField = new JTextField();
            this.textField.addKeyListener(this);
            this.textField.addFocusListener(this);
            this.textField.getDocument().addDocumentListener(this);
            this.component = this.textField;
        }
    }

    @Override
    public void setComponentValue() {
        this.initializeComponent();
        this.settingValue = true;
        if (this.textField != null) {
            this.textField.setText(this.getSafeString(this.value));
        } else {
            ((JLabel)this.component).setText(this.getSafeString(this.value));
        }
        this.settingValue = false;
    }

    @Override
    public Object getComponentValue() {
        if (this.textField != null) {
            String text = this.textField.getText();
            return StringUtil.trimNull((String)text);
        }
        return null;
    }

    @Override
    public void highlight(boolean on) {
        if (this.textField != null && this.textField.getParent() != null && this.textField.isVisible()) {
            boolean show;
            boolean bl = show = on && this.textField.hasFocus();
            if (show) {
                this.textField.setSelectionStart(0);
                int length = this.textField.getText().length();
                this.textField.setSelectionEnd(length);
            } else {
                this.textField.setCaretPosition(0);
                this.textField.setSelectionStart(0);
                this.textField.setSelectionEnd(0);
            }
            this.textField.getCaret().setVisible(show);
            this.textField.getCaret().setSelectionVisible(show);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    StringEditor.this.textField.repaint();
                }
            });
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        if (!this.settingValue) {
            this.propertyChanged();
        }
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        if (!this.settingValue) {
            this.propertyChanged();
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        if (!this.settingValue) {
            this.propertyChanged();
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        int keyCode = e.getKeyCode();
        switch (keyCode) {
            case 35: 
            case 36: 
            case 37: 
            case 39: {
                int pos = this.textField.getCaretPosition();
                boolean shiftPressed = e.isShiftDown();
                int selSize = this.textField.getSelectionEnd() - this.textField.getSelectionStart();
                switch (keyCode) {
                    case 37: {
                        if (pos == 0 && !shiftPressed && selSize == 0) {
                            this.forwardKeyEvent(e);
                            return;
                        }
                        return;
                    }
                    case 39: {
                        if (pos == this.textField.getText().length() && !shiftPressed && selSize == 0) {
                            this.forwardKeyEvent(e);
                            return;
                        }
                        return;
                    }
                    case 36: {
                        if (pos == 0 && !shiftPressed && selSize == 0) {
                            this.forwardKeyEvent(e);
                            return;
                        }
                        if (shiftPressed) {
                            this.textField.setCaretPosition(0);
                            this.textField.setSelectionStart(0);
                            this.textField.setSelectionEnd(pos);
                        } else {
                            this.textField.setCaretPosition(0);
                        }
                        e.consume();
                        return;
                    }
                    case 35: {
                        int len = this.textField.getText().length();
                        if (pos == len && !shiftPressed && selSize == 0) {
                            this.forwardKeyEvent(e);
                            return;
                        }
                        if (shiftPressed) {
                            this.textField.setSelectionStart(pos);
                            this.textField.setSelectionEnd(len);
                        } else {
                            this.textField.setCaretPosition(len);
                        }
                        e.consume();
                        return;
                    }
                }
            }
        }
        super.keyPressed(e);
    }
}

