/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.jaspira.propertybrowser.nodes;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreeNode;
import org.openbp.common.ExceptionUtil;
import org.openbp.common.ReflectUtil;
import org.openbp.common.generic.description.DescriptionObject;
import org.openbp.common.generic.propertybrowser.CollectionDescriptor;
import org.openbp.common.generic.propertybrowser.PropertyDescriptor;
import org.openbp.common.property.PropertyAccessUtil;
import org.openbp.common.property.PropertyException;
import org.openbp.common.string.StringUtil;
import org.openbp.common.util.NamedObjectCollectionUtil;
import org.openbp.common.util.ToStringHelper;
import org.openbp.jaspira.propertybrowser.NodeStructureMgr;
import org.openbp.jaspira.propertybrowser.PropertyBrowserModel;
import org.openbp.jaspira.propertybrowser.nodes.AbstractNode;
import org.openbp.jaspira.propertybrowser.nodes.ObjectNode;
import org.openbp.swing.components.treetable.JTreeTable;

public class CollectionNode
extends AbstractNode {
    private PropertyDescriptor propertyDescriptor;
    private List list;

    public CollectionNode(PropertyDescriptor propertyDescriptor) {
        this.propertyDescriptor = propertyDescriptor;
    }

    public String toString() {
        return ToStringHelper.toString((Object)this, (String)"propertyDescriptor.name");
    }

    @Override
    public void copyFrom(Object source, int copyMode) throws CloneNotSupportedException {
        if (source == this) {
            return;
        }
        if (this.children != null) {
            this.children.clear();
        }
        this.list = null;
        super.copyFrom(source, copyMode);
        CollectionNode src = (CollectionNode)source;
        this.propertyDescriptor = src.propertyDescriptor;
    }

    @Override
    public void reload() {
        super.reload();
        this.populateChildren();
        if (this.propertyBrowser != null) {
            this.propertyBrowser.saveCurrentPosition();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PropertyBrowserModel model;
                    if (CollectionNode.this.propertyBrowser != null && (model = (PropertyBrowserModel)((Object)CollectionNode.this.propertyBrowser.getModel())) != null) {
                        model.fireNodeChanged((TreeNode)((Object)CollectionNode.this));
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (CollectionNode.this.propertyBrowser != null) {
                                    CollectionNode.this.propertyBrowser.restoreCurrentPosition();
                                }
                            }
                        });
                    }
                }
            });
        }
    }

    @Override
    public boolean representsProperty(String propertyName) {
        return this.propertyDescriptor != null && this.propertyDescriptor.getName().equals(propertyName);
    }

    public PropertyDescriptor getPropertyDescriptor() {
        return this.propertyDescriptor;
    }

    public CollectionDescriptor getCollectionDescriptor() {
        return this.propertyDescriptor != null ? this.propertyDescriptor.getCollectionDescriptor() : null;
    }

    public Object getColumnValue(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.propertyDescriptor;
            }
            case 1: {
                if (this.children == null || this.list == null || this.children.size() != this.list.size()) {
                    this.populateChildren();
                }
                if (this.children != null && this.children.size() != 0) {
                    return "[" + this.children.size() + "]";
                }
                return "[ ]";
            }
            case 2: {
                return this.propertyDescriptor != null ? JTreeTable.createDescriptionCellValue((String)this.propertyDescriptor.getDescription()) : null;
            }
        }
        return null;
    }

    public String getNodeText() {
        return this.propertyDescriptor != null ? this.propertyDescriptor.getDisplayName() : null;
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        if (this.children == null || this.list == null || this.children.size() != this.list.size()) {
            this.populateChildren();
        }
        return super.getChildAt(childIndex);
    }

    @Override
    public int getChildCount() {
        int size = this.list != null ? this.list.size() : 0;
        return size;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public boolean shouldExpand() {
        return this.propertyDescriptor.isExpanded();
    }

    @Override
    public void setObject(Object object) {
        this.object = object;
        try {
            this.list = object != null ? (List)PropertyAccessUtil.getProperty((Object)object, (String)this.propertyDescriptor.getName()) : null;
        }
        catch (PropertyException e) {
            ExceptionUtil.printTrace((Throwable)e);
        }
    }

    public AbstractNode addNewNodeAfter(AbstractNode posNode, Object instance) {
        int index;
        if (instance == null) {
            instance = this.createNewMember();
            if (instance == null) {
                return null;
            }
        } else if (instance instanceof DescriptionObject) {
            DescriptionObject d = (DescriptionObject)instance;
            String name = NamedObjectCollectionUtil.createUniqueId((Collection)this.list, (String)d.getName());
            d.setName(name);
        }
        index = (index = this.getChildIndex(posNode)) < 0 ? this.getChildCount() : ++index;
        if (this.list == null) {
            this.list = new ArrayList();
        }
        this.list.add(index, instance);
        ObjectNode node = NodeStructureMgr.getInstance().createEditorStructureFor(instance.getClass());
        node.setObject(instance);
        node.setPropertyBrowser(this.propertyBrowser);
        this.add(index, node);
        this.saveList();
        ((PropertyBrowserModel)((Object)this.propertyBrowser.getModel())).fireNodeInserted((TreeNode)((Object)node));
        return node;
    }

    public AbstractNode removeNode(AbstractNode node) {
        int n;
        int index = this.getChildIndex(node);
        if (index < 0) {
            return null;
        }
        if (this.list != null) {
            this.list.remove(node.getObject());
            this.saveList();
        }
        if (this.children != null) {
            this.children.remove(node);
            ((PropertyBrowserModel)((Object)this.propertyBrowser.getModel())).fireNodeRemoved((TreeNode)((Object)this));
        }
        if (index >= (n = this.getChildCount())) {
            index = n > 0 ? n - 1 : -1;
        }
        if (index >= 0) {
            return (AbstractNode)((Object)this.getChildAt(index));
        }
        return this;
    }

    public void removeAllNodes() {
        if (this.list != null) {
            this.list = null;
            this.saveList();
        }
        if (this.children != null) {
            this.children.clear();
            ((PropertyBrowserModel)((Object)this.propertyBrowser.getModel())).fireNodeRemoved((TreeNode)((Object)this));
        }
    }

    public void moveNodeUp(AbstractNode node) {
        int index = this.getChildIndex(node);
        if (index < 1) {
            return;
        }
        this.list.remove(node.getObject());
        this.children.remove(node);
        this.list.add(--index, node.getObject());
        this.add(index, node);
        this.afterMove(node);
    }

    public void moveNodeDown(AbstractNode node) {
        int index = this.getChildIndex(node);
        if (index < 0 || index >= this.getChildCount() - 1) {
            return;
        }
        this.list.remove(node.getObject());
        this.children.remove(node);
        this.list.add(++index, node.getObject());
        this.add(index, node);
        this.afterMove(node);
    }

    private void afterMove(AbstractNode node) {
        this.saveList();
        ((PropertyBrowserModel)((Object)this.propertyBrowser.getModel())).structureChanged((AbstractNode)((Object)node.getParent()));
        this.propertyBrowser.selectNode((TreeNode)((Object)node));
    }

    public boolean allowedToDrag() {
        return false;
    }

    public boolean allowsNodeAddition() {
        return this.getCollectionDescriptor().isAddEnabled();
    }

    public boolean allowsNodeRemoval() {
        return this.getCollectionDescriptor().isDeleteEnabled();
    }

    public boolean allowsNodeReordering() {
        return this.getCollectionDescriptor().isReorderEnabled();
    }

    protected void populateChildren() {
        if (this.children != null) {
            this.children.clear();
        }
        if (this.list != null) {
            for (int i = 0; i < this.list.size(); ++i) {
                Object listObject = this.list.get(i);
                ObjectNode node = NodeStructureMgr.getInstance().createEditorStructureFor(listObject.getClass());
                node.setObject(listObject);
                node.setPropertyBrowser(this.propertyBrowser);
                this.add(node);
            }
        }
    }

    public int getChildIndex(AbstractNode node) {
        if (node != null && node != this) {
            int n = this.getChildCount();
            for (int i = 0; i < n; ++i) {
                if (this.getChildAt(i) != node) continue;
                return i;
            }
        }
        return -1;
    }

    protected void saveList() {
        try {
            if (this.list != null && this.list.size() == 0) {
                this.list = null;
            }
            PropertyAccessUtil.setProperty((Object)this.object, (String)this.propertyDescriptor.getName(), (Object)this.list);
            this.propertyBrowser.fireObjectModified();
        }
        catch (PropertyException e) {
            ExceptionUtil.printTrace((Throwable)e);
        }
    }

    protected Object createNewMember() {
        Object element;
        Object o;
        block13: {
            o = null;
            try {
                String methodName = "create" + this.propertyDescriptor.getName() + "Element";
                Method method = this.object.getClass().getMethod(methodName, null);
                if (method == null) break block13;
                try {
                    o = method.invoke(this.object, (Object[])null);
                }
                catch (InvocationTargetException e) {
                    ExceptionUtil.printTrace((Throwable)e);
                    return null;
                }
                catch (IllegalAccessException e) {
                    ExceptionUtil.printTrace((Throwable)e);
                    return null;
                }
                return o;
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        CollectionDescriptor cd = this.getCollectionDescriptor();
        Class<?> elementClass = cd.getSafeTypeClass();
        if (elementClass == null && this.list != null && this.list.size() > 0 && (element = this.list.get(0)) != null) {
            elementClass = element.getClass();
        }
        if (elementClass != null) {
            try {
                o = ReflectUtil.instantiate((Class)elementClass, null, (String)"collection element");
            }
            catch (Exception e) {
                ExceptionUtil.printTrace((Throwable)e);
                return null;
            }
        }
        if (o != null) {
            try {
                String text = StringUtil.capitalize((String)this.propertyDescriptor.getName());
                if (text.endsWith("List")) {
                    text = text.substring(0, text.length() - 4);
                }
                text = "New" + text;
                PropertyAccessUtil.setProperty((Object)o, (String)"name", (Object)text);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return o;
    }
}

