/*
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 */
package org.openbp.cockpit.modeler.figures.generic;

import CH.ifa.draw.framework.Figure;

/**
 * A shadow dropper is a figure capable of drawing its own shadow.
 * The shadow itself is represented by a (simple) seperate Figure.
 *
 * @author Stephan Moritz
 */
public interface ShadowDropper
{
	/**
	 * Returns the shadow figure of this object.
	 *
	 * @return The shadow figure or null if this object does not have a shadow
	 */
	public Figure getShadow();
}
