/*
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 */
package org.openbp.cockpit.modeler.tools;

import java.awt.event.MouseEvent;

/**
 * This Tool does nothing by itself but selecting a single figure.
 *
 * @author Stephan Pauxberger
 */
public class SimpleSelectTool extends ModelerTool
{
	public SimpleSelectTool(ModelerToolSupport toolSupport)
	{
		super(toolSupport);
	}

	public void mouseDown(MouseEvent e, int x, int y)
	{
		if (e.isShiftDown())
		{
			getView().toggleSelection(getAffectedFigure());
		}
		else if (!getView().isFigureSelected(getAffectedFigure()))
		{
			getView().singleSelect(getAffectedFigure());
		}
	}
}
