/*
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 */
package org.openbp.cockpit.modeler.util;

import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;

/**
 * Empty figure enumerator.
 * This class is a singleton.
 *
 * @author Heiko Erhardt
 */
public final class EmptyFigureEnumerator
	implements FigureEnumeration
{
	/** Singleton instance */
	private static EmptyFigureEnumerator singletonInstance;

	/**
	 * Gets the singleton instance of this class.
	 */
	public static synchronized EmptyFigureEnumerator getInstance()
	{
		if (singletonInstance == null)
			singletonInstance = new EmptyFigureEnumerator();
		return singletonInstance;
	}

	/**
	 * Private constructor.
	 */
	private EmptyFigureEnumerator()
	{
	}

	public boolean hasMoreElements()
	{
		return false;
	}

	public Object nextElement()
	{
		return null;
	}

	public Figure nextFigure()
	{
		return null;
	}
}
