/*
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 */
package org.openbp.cockpit.plugins.finder;

import java.util.Arrays;
import java.util.Comparator;

import org.openbp.cockpit.plugins.finder.treemodel.GenericNode;
import org.openbp.core.model.item.ItemTypes;

/**
 * Comparator for the tree.
 *
 * @author Baumgartner Michael
 */
public class RefComparator
	implements Comparator
{
	/**
	 * @see java.util.Comparator#compare(java.lang.Object, java.lang.Object)
	 */
	public int compare(Object o1, Object o2)
	{
		if (o1 == o2)
			return 0;

		GenericNode n1 = (GenericNode) o1;
		GenericNode n2 = (GenericNode) o2;

		// Get the priority of the nodes, 1 stands for model node,
		// 2 for an simple node, 3 for a leaf node
		int prio1 = ((Integer) n1.getProperty(RefStrategy.PRIORITY_KEY)).intValue();
		int prio2 = ((Integer) n1.getProperty(RefStrategy.PRIORITY_KEY)).intValue();
		if (prio1 == prio2 && prio1 == 1)
		{
			return n1.toString().compareTo(n2.toString());
		}
		else if (prio1 == prio2 && prio1 == 2)
		{
			String type1 = (String) n1.getProperty(RefStrategy.ITEMTYPE_KEY);
			String type2 = (String) n2.getProperty(RefStrategy.ITEMTYPE_KEY);
			if (type1.equals(type2))
				return n1.toString().compareTo(n2.toString());

			// Sort by the item type
			int index1 = Arrays.binarySearch(ItemTypes.getValues(), type1);
			int index2 = Arrays.binarySearch(ItemTypes.getValues(), type2);
			return index2 - index1;
		}
		else if (prio1 == prio2 && prio1 == 3)
			return n1.toString().compareTo(n2.toString());
		else
			return prio1 - prio2;
	}
}
