/*
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 */
package org.openbp.guiclient.objectvalidators;

import org.openbp.common.generic.description.DescriptionObject;
import org.openbp.common.generic.description.DisplayObject;
import org.openbp.common.string.NameUtil;
import org.openbp.guiclient.plugins.displayobject.DisplayObjectPlugin;
import org.openbp.jaspira.option.OptionMgr;
import org.openbp.jaspira.propertybrowser.editor.PropertyEditor;

/**
 * Object validator for the {@link DescriptionObject} class.
 * Generates a display name from the object name if not already present.
 *
 * @author Heiko Erhardt
 */
public class DisplayObjectValidator extends DescriptionObjectValidator
{
	/**
	 * Property validator method.
	 * Automatically generates a display name from the object name.
	 */
	public boolean validateProperty(String propertyName, Object propertyValue, Object editedObject, PropertyEditor propertyEditor, boolean complete)
	{
		if (!super.validateProperty(propertyName, propertyValue, editedObject, propertyEditor, complete))
		{
			return false;
		}

		if (complete)
		{
			if (propertyName.equals("Name"))
			{
				boolean autoGenerateDisplayName = OptionMgr.getInstance().getBooleanOption(DisplayObjectPlugin.AUTODISPLAYNAME_OPTION, false);
				if (autoGenerateDisplayName)
				{
					DisplayObject dob = (DisplayObject) editedObject;

					if (dob.getDisplayName() == null)
					{
						String name = (String) propertyValue;

						// Generate the display name
						String displayName = NameUtil.makeDisplayName(name);

						// Update the object
						dob.setDisplayName(displayName);
						propertyEditor.getOwner().reloadProperty("DisplayName");
					}
				}
			}
		}

		return true;
	}
}
