/*
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 */
package org.openbp.jaspira;

/**
 * This class contains constants important for the Jaspira framework,
 * e\.g\. log names.
 *
 * @author Heiko Erhardt
 */
public class JaspiraConstants
{
	//////////////////////////////////////////////////
	// @@ Resource names
	//////////////////////////////////////////////////

	/** Name of the resource component for general Jaspira resources */
	public static final String RESOURCE_JASPIRA = "jaspira";

	//////////////////////////////////////////////////
	// @@ Log names
	//////////////////////////////////////////////////

	/** Default log for the server */
	public static final String LOG_JASPIRA = "jaspira";
}
