/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.generator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.openbp.cockpit.generator.Generator;
import org.openbp.cockpit.generator.GeneratorContext;
import org.openbp.cockpit.generator.GeneratorSettings;
import org.openbp.cockpit.generator.wizard.GeneratorWizard;
import org.openbp.common.CollectionUtil;
import org.openbp.common.ReflectUtil;
import org.openbp.common.util.NamedObjectCollectionUtil;
import org.openbp.core.model.Model;
import org.openbp.core.model.item.Item;
import org.openbp.swing.components.wizard.WizardEvent;

public abstract class GeneratorCustomizer {
    private Generator generator;

    public Object createSettings(GeneratorContext context) {
        Class cls = this.getSettingsClass();
        boolean create = false;
        GeneratorSettings settings = context.getGeneratorSettings();
        if (settings != null) {
            if (!settings.getClass().equals(cls)) {
                create = true;
            }
        } else if (cls != null) {
            create = true;
        }
        if (create) {
            if (cls != null) {
                settings = (GeneratorSettings)ReflectUtil.instantiate((Class)cls, GeneratorSettings.class, (String)"generator settings");
                settings.setGeneratorName(this.generator.getName());
            }
            context.setGeneratorSettings(settings);
            context.setProperty("settings", settings);
        }
        if (settings != null) {
            settings.setModel(context.getItem().getModel());
        }
        return settings;
    }

    public void loadSettings(GeneratorContext context) {
    }

    public void saveSettings(GeneratorContext context) {
    }

    public Class getSettingsClass() {
        return null;
    }

    public Class[] getDependentSettingsClasses() {
        return null;
    }

    public String getTemplateName(GeneratorContext context) {
        return this.generator.getTemplateName();
    }

    public boolean hasResultPage(GeneratorContext context) {
        return true;
    }

    public void checkRequirements(GeneratorContext context) {
    }

    public void beforePageSequenceUpdate(GeneratorContext context, GeneratorWizard wizard) {
    }

    public void afterPageSequenceUpdate(GeneratorContext context, GeneratorWizard wizard) {
    }

    public void preProcess(GeneratorContext context) throws Exception {
        this.generator.runTemplateEngine(context);
    }

    public void performProcess(GeneratorContext context) throws Exception {
    }

    public void postProcess(GeneratorContext context) throws Exception {
    }

    public void processWizardEvent(GeneratorContext context, WizardEvent event) {
    }

    public Generator getGenerator() {
        return this.generator;
    }

    public void setGenerator(Generator generator) {
        this.generator = generator;
    }

    public String evaluateFormat(GeneratorContext context, String format) {
        if (format == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        StringTokenizer st = new StringTokenizer(format, "$", true);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.equals("$")) {
                if (!st.hasMoreTokens()) continue;
                String name = st.nextToken();
                Object value = context.getProperty(name);
                if (value == null) {
                    return null;
                }
                if (value != null) {
                    sb.append(value.toString());
                }
                if (!st.hasMoreTokens()) continue;
                st.nextToken();
                continue;
            }
            sb.append(token);
        }
        String ret = sb.toString().trim();
        if (ret.length() == 0) {
            ret = null;
        }
        return ret;
    }

    public String determineUniqueSuffix(Item item, String name) {
        Model model = item.getModel();
        String itemType = item.getItemType();
        Iterator itemIterator = model.getItems(itemType);
        ArrayList items = new ArrayList();
        CollectionUtil.addAll(items, (Iterator)itemIterator);
        String result = NamedObjectCollectionUtil.createUniqueId(items, (String)name);
        if (result.equals(name)) {
            return null;
        }
        return result.substring(name.length());
    }
}

