/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.generator;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.openbp.cockpit.generator.Generator;
import org.openbp.cockpit.generator.GeneratorMgr;
import org.openbp.cockpit.generator.wizard.GeneratorWizard;
import org.openbp.cockpit.generator.wizard.WizardSelectionPage;
import org.openbp.core.model.item.Item;
import org.openbp.core.model.item.activity.JavaActivityItemImpl;
import org.openbp.core.model.item.process.ActivityNode;
import org.openbp.guiclient.model.item.ItemIconMgr;
import org.openbp.guiclient.util.ClientFlavors;
import org.openbp.jaspira.action.JaspiraAction;
import org.openbp.jaspira.event.InteractionEvent;
import org.openbp.jaspira.event.JaspiraEventHandlerCode;
import org.openbp.jaspira.plugin.AbstractPlugin;
import org.openbp.jaspira.plugin.ApplicationUtil;
import org.openbp.jaspira.plugin.InteractionModule;
import org.openbp.jaspira.plugin.Plugin;

public class GeneratorPlugin
extends AbstractPlugin {
    private boolean first = true;

    @Override
    public String getResourceCollectionContainerName() {
        return "plugin.generator";
    }

    public static class GeneratorAction
    extends JaspiraAction {
        private final GeneratorWizard wizard;
        private final String title;

        public GeneratorAction(Plugin owner, String name, GeneratorWizard wizard) {
            super(owner, name);
            this.wizard = wizard;
            this.title = owner.getPluginResourceCollection().getOptionalString("generator.wizard.title");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            JFrame activeFrame = ApplicationUtil.getActiveWindow();
            JDialog dialog = new JDialog((Frame)activeFrame, true);
            dialog.setSize(new Dimension(600, 700));
            dialog.setLocationRelativeTo(activeFrame);
            dialog.setTitle(this.title);
            dialog.getContentPane().add((Component)((Object)this.wizard));
            dialog.setVisible(true);
        }
    }

    public class InteractionEvents
    extends InteractionModule {
        @Override
        public int getPriority() {
            return 3;
        }

        @Override
        public JaspiraEventHandlerCode popup(InteractionEvent ie) {
            Item item = null;
            if (ie.isDataFlavorSupported(ClientFlavors.MODEL)) {
                item = (Item)ie.getSafeTransferData(ClientFlavors.MODEL);
            } else if (ie.isDataFlavorSupported(ClientFlavors.ITEM)) {
                item = (Item)ie.getSafeTransferData(ClientFlavors.ITEM);
            } else if (ie.isDataFlavorSupported(ClientFlavors.ACTIVITY_NODE)) {
                ActivityNode activityNode = (ActivityNode)ie.getSafeTransferData(ClientFlavors.ACTIVITY_NODE);
                item = new JavaActivityItemImpl();
                item.setModel(activityNode.getOwningModel());
                int syncFlags = 122;
                activityNode.copyToItem(item, syncFlags);
            } else {
                return EVENT_IGNORED;
            }
            if (item != null) {
                List list;
                if (GeneratorPlugin.this.first) {
                    GeneratorPlugin.this.first = false;
                }
                if ((list = GeneratorMgr.getInstance().getGenerators(item.getItemType(), false)) != null) {
                    GeneratorWizard wizard = new GeneratorWizard(GeneratorPlugin.this.getPluginResourceCollection(), item);
                    ImageIcon icon = (ImageIcon)ItemIconMgr.getInstance().getIcon(item.getItemType(), 48);
                    wizard.setDefaultWizardImage(icon);
                    WizardSelectionPage selectionPage = new WizardSelectionPage(wizard);
                    int n = list.size();
                    for (int i = 0; i < n; ++i) {
                        Generator generator = (Generator)list.get(i);
                        selectionPage.addGenerator(generator);
                    }
                    selectionPage.expandTree();
                    wizard.addAndLinkPage("selection", (Component)((Object)selectionPage));
                    wizard.displayFirst();
                    GeneratorAction action = new GeneratorAction(GeneratorPlugin.this, "generator.action", wizard);
                    ie.add(action);
                }
            }
            return EVENT_HANDLED;
        }
    }
}

