/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.generator.generic;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import org.openbp.cockpit.generator.generic.ProcessEntry;
import org.openbp.cockpit.generator.generic.ProcessEntrySettings;
import org.openbp.cockpit.generator.wizard.GeneratorWizard;
import org.openbp.cockpit.generator.wizard.WizardCustomPage;
import org.openbp.core.model.Model;
import org.openbp.core.model.item.Item;
import org.openbp.core.model.item.process.InitialNode;
import org.openbp.core.model.item.process.ProcessItem;
import org.openbp.guiclient.model.item.itemtree.ItemTree;
import org.openbp.guiclient.model.item.itemtree.ItemTreeEvent;
import org.openbp.guiclient.model.item.itemtree.ItemTreeListener;
import org.openbp.guiclient.model.item.itemtree.ItemTreeState;
import org.openbp.swing.components.wizard.WizardEvent;
import org.openbp.swing.plaf.sky.ShadowBorder;

public class ProcessEntriesPage
extends WizardCustomPage
implements ItemTreeListener {
    private ItemTree itemTree = new ItemTree();

    public ProcessEntriesPage(GeneratorWizard wizard) {
        super(wizard);
        this.itemTree.addItemTreeListener(this);
        this.itemTree.setSelectionMode(4);
        this.itemTree.setShowGroups(false);
        this.itemTree.setSupportedItemTypes(new String[]{"Model", "Process"});
        this.itemTree.setSupportedObjectClasses(new Class[]{Model.class, ProcessItem.class, InitialNode.class});
        this.itemTree.setSelectableObjectClasses(new Class[]{InitialNode.class});
        ItemTreeState state = new ItemTreeState();
        Item item = wizard.getContext().getItem();
        Model currentModel = item.getOwningModel();
        if (item instanceof ProcessItem) {
            state.addExpandedQualifier(item.getQualifier());
        } else {
            state.addExpandedQualifier(currentModel.getQualifier());
        }
        ProcessEntrySettings settings = (ProcessEntrySettings)((Object)this.getGeneratorSettings());
        List entries = settings.getEntryList();
        if (entries != null) {
            int n = entries.size();
            for (int i = 0; i < n; ++i) {
                ProcessEntry entry = (ProcessEntry)((Object)entries.get(i));
                InitialNode initialNode = entry.getInitialNode();
                if (initialNode == null) continue;
                state.addSelectedQualifier(initialNode.getQualifier());
            }
        } else {
            state.addSelectedQualifier(currentModel.getQualifier());
        }
        this.itemTree.rebuildTree();
        this.itemTree.expand(1);
        this.itemTree.restoreState(state);
        JScrollPane sp = new JScrollPane(this.itemTree);
        sp.setBorder((Border)new ShadowBorder());
        this.getContentPanel().add(sp);
    }

    public ItemTree getItemTree() {
        return this.itemTree;
    }

    public void handleWizardEvent(WizardEvent event) {
        if (event.eventType == 4 || event.eventType == 3 || event.eventType == 2) {
            InitialNode node;
            List initialNodes = this.itemTree.getSelectedObjects();
            ProcessEntrySettings settings = (ProcessEntrySettings)((Object)this.getGeneratorSettings());
            ArrayList<ProcessEntry> entryList = settings.getEntryList();
            if (entryList != null) {
                if (initialNodes == null) {
                    entryList = null;
                } else {
                    Iterator it = entryList.iterator();
                    while (it.hasNext()) {
                        ProcessEntry entry = (ProcessEntry)((Object)it.next());
                        node = entry.getInitialNode();
                        if (initialNodes.contains(node)) continue;
                        it.remove();
                    }
                    if (entryList.size() == 0) {
                        entryList = null;
                    }
                }
            } else if (initialNodes != null) {
                entryList = new ArrayList<ProcessEntry>();
            }
            if (initialNodes != null && entryList != null) {
                int n = initialNodes.size();
                for (int i = 0; i < n; ++i) {
                    node = (InitialNode)initialNodes.get(i);
                    if (ProcessEntriesPage.containsInitialNode(entryList, node)) continue;
                    ProcessEntry entry = new ProcessEntry();
                    entry.setModel(settings.getModel());
                    entry.setInitialNode(node);
                    entry.setName(node.getName());
                    entry.setDisplayName(node.getDisplayName());
                    entryList.add(entry);
                }
            }
            settings.setEntryList(entryList);
        }
    }

    public static boolean containsInitialNode(List entryList, InitialNode node) {
        int n = entryList.size();
        for (int i = 0; i < n; ++i) {
            ProcessEntry entry = (ProcessEntry)((Object)entryList.get(i));
            if (entry.getInitialNode() != node) continue;
            return true;
        }
        return false;
    }

    @Override
    public void handleItemTreeEvent(ItemTreeEvent e) {
        if (e.eventType == 1) {
            List selection = this.itemTree.getSelectedObjects();
            if (selection != null) {
                this.canMoveForward = true;
                if (!this.getContext().isNewItem()) {
                    this.canFinish = true;
                }
            } else {
                this.canMoveForward = false;
            }
            this.updateNavigator();
            this.getContext().setNeedGeneration(true);
        }
    }
}

