/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.generator.type;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.openbp.cockpit.generator.GeneratorContext;
import org.openbp.cockpit.generator.GeneratorCustomizer;
import org.openbp.cockpit.generator.GeneratorSettings;
import org.openbp.cockpit.generator.wizard.GeneratorWizard;
import org.openbp.common.ExceptionUtil;
import org.openbp.common.io.xml.XMLDriverException;
import org.openbp.common.rc.ResourceCollection;
import org.openbp.core.model.item.type.ComplexTypeItem;
import org.openbp.core.model.item.type.DataMember;
import org.openbp.core.model.item.type.DataTypeItem;
import org.openbp.guiclient.util.ClassNameBuilderUtil;
import org.openbp.jaspira.action.ActionMgr;
import org.openbp.jaspira.gui.wizard.JaspiraWizardObjectPage;
import org.openbp.jaspira.propertybrowser.PropertyBrowser;
import org.openbp.jaspira.propertybrowser.PropertyBrowserImpl;
import org.openbp.swing.components.wizard.Wizard;
import org.openbp.swing.components.wizard.WizardEvent;
import org.openbp.swing.plaf.sky.SkyTheme;

public class TypeCustomizer
extends GeneratorCustomizer {
    private ComplexTypeItem type;
    private int currentMemberIndex;
    public static final String MEMBER_PAGE = "member";
    public static final String DEFAULT_MEMBER_TYPE = "String";
    private static final Dimension BUTTON_DIM = new Dimension(260, 26);
    private final String[] typeVisibleProperties = new String[]{"Name", "DisplayName", "Description", "FunctionalGroup", "BaseTypeName", "ClassName"};

    @Override
    public Class getSettingsClass() {
        return GeneratorSettings.class;
    }

    @Override
    public void afterPageSequenceUpdate(GeneratorContext context, GeneratorWizard wizard) {
        MemberPage memberPage = new MemberPage(wizard);
        wizard.addAndLinkPage(MEMBER_PAGE, (Component)((Object)memberPage));
        wizard.getManager().setNext(MEMBER_PAGE, MEMBER_PAGE);
        JaspiraWizardObjectPage objectPage = (JaspiraWizardObjectPage)((Object)wizard.getPage("property"));
        PropertyBrowser oe = objectPage.getPropertyBrowser();
        oe.setVisibleMembers(this.typeVisibleProperties);
        JPanel buttonPanel = TypeCustomizer.createButtonPanel();
        buttonPanel.add("Center", this.createAddButton(context, objectPage));
        objectPage.getContentPanel().add((Component)buttonPanel, "South");
    }

    @Override
    public String getTemplateName(GeneratorContext context) {
        this.determinetype(context);
        if (this.type.getClassName() != null) {
            return super.getTemplateName(context);
        }
        return null;
    }

    @Override
    public boolean hasResultPage(GeneratorContext context) {
        return this.getTemplateName(context) != null;
    }

    @Override
    public void processWizardEvent(GeneratorContext context, WizardEvent event) {
        this.determinetype(context);
        String pageName = event.wizard.getManager().getCurrent();
        if (pageName.equals("property") && event.eventType == 0) {
            if (context.isEmptyItem() && !context.isClassnameSet()) {
                if (this.type.getClassName() == null) {
                    this.type.setClassName(ClassNameBuilderUtil.constructTypeClassName((DataTypeItem)this.type));
                    JaspiraWizardObjectPage page = (JaspiraWizardObjectPage)((Object)event.wizard.getPage(pageName));
                    page.handleWizardEvent(event);
                }
                context.setClassnameSet(true);
            }
            this.currentMemberIndex = 0;
            List memberList = this.type.getMemberList();
            JaspiraWizardObjectPage objectPage = (JaspiraWizardObjectPage)((Object)event.wizard.getPage(pageName));
            objectPage.canMoveForward = memberList != null && this.currentMemberIndex < memberList.size() - 1;
        }
        super.processWizardEvent(context, event);
    }

    public static void clearPropertyBrowser(JaspiraWizardObjectPage page) {
        PropertyBrowser oe = page.getPropertyBrowser();
        try {
            oe.setObjectModified(false);
            oe.setObject(null, false);
            oe.setOriginalObject(null);
        }
        catch (XMLDriverException e) {
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
    }

    protected JButton createAddButton(GeneratorContext context, final JaspiraWizardObjectPage page) {
        ResourceCollection res = page.getWizard().getResource();
        JButton btn = TypeCustomizer.createButton(res, "wizard.type.addmemberbutton");
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PropertyBrowserImpl oe = (PropertyBrowserImpl)page.getPropertyBrowser();
                if (!oe.saveObject()) {
                    return;
                }
                DataMember member = TypeCustomizer.this.type.createMember();
                TypeCustomizer.this.type.addMember(member);
                member.setTypeName(TypeCustomizer.DEFAULT_MEMBER_TYPE);
                try {
                    DataTypeItem dataType = (DataTypeItem)member.getParentDataType().resolveItemRef(TypeCustomizer.DEFAULT_MEMBER_TYPE, "Type");
                    dataType.performDefaultDataMemberConfiguration(member);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                List memberList = TypeCustomizer.this.type.getMemberList();
                TypeCustomizer.this.currentMemberIndex = memberList.size() - 1;
                page.getWizard().displayPage(TypeCustomizer.MEMBER_PAGE);
                page.canMoveForward = TypeCustomizer.this.currentMemberIndex < memberList.size() - 1;
                page.updateNavigator();
            }
        });
        return btn;
    }

    protected JButton createRemoveButton(GeneratorContext context, final JaspiraWizardObjectPage page) {
        ResourceCollection res = page.getWizard().getResource();
        JButton btn = TypeCustomizer.createButton(res, "wizard.type.removememberbutton");
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int n;
                TypeCustomizer.clearPropertyBrowser(page);
                TypeCustomizer.this.type.removeMember((DataMember)TypeCustomizer.this.type.getMemberList().get(TypeCustomizer.this.currentMemberIndex));
                List memberList = TypeCustomizer.this.type.getMemberList();
                int n2 = n = memberList != null ? memberList.size() : 0;
                if (TypeCustomizer.this.currentMemberIndex == n && TypeCustomizer.this.currentMemberIndex > 0) {
                    --TypeCustomizer.this.currentMemberIndex;
                }
                if (TypeCustomizer.this.currentMemberIndex < n) {
                    page.getWizard().displayPage(null);
                } else {
                    page.getWizard().displayFirst();
                }
            }
        });
        return btn;
    }

    public static JButton createButton(ResourceCollection res, String resourceId) {
        String text = res.getRequiredString(resourceId);
        JButton btn = new JButton(ActionMgr.getStringWithoutMnemonicDelimiter(text));
        btn.setMnemonic(ActionMgr.getMnemonicChar(text));
        btn.setPreferredSize(BUTTON_DIM);
        btn.setMaximumSize(BUTTON_DIM);
        return btn;
    }

    public static JPanel createButtonPanel() {
        JPanel btnPanel = new JPanel();
        btnPanel.setBackground(SkyTheme.COLOR_BACKGROUND_LIGHT);
        btnPanel.setLayout(new BorderLayout());
        btnPanel.setBorder(new EmptyBorder(5, 4, 5, 5));
        return btnPanel;
    }

    private void determinetype(GeneratorContext context) {
        this.type = (ComplexTypeItem)context.getItem();
    }

    private class MemberPage
    extends JaspiraWizardObjectPage {
        private final String[] memberVisibleProperties;

        public MemberPage(GeneratorWizard wizard) {
            super((Wizard)wizard);
            this.memberVisibleProperties = new String[]{"Name", "DisplayName", "Description", "TypeName", "Length", "Precision", "Required", "PrimaryKey"};
            PropertyBrowser oe = this.getPropertyBrowser();
            oe.setVisibleMembers(this.memberVisibleProperties);
            this.canFinish = true;
            JPanel buttonPanel = new JPanel();
            buttonPanel.setBackground(SkyTheme.COLOR_BACKGROUND_LIGHT);
            buttonPanel.setLayout(new BorderLayout());
            buttonPanel.setBorder(new EmptyBorder(5, 4, 5, 5));
            GeneratorContext context = wizard.getContext();
            buttonPanel.add("Center", TypeCustomizer.this.createAddButton(context, this));
            buttonPanel.add("East", TypeCustomizer.this.createRemoveButton(context, this));
            this.getContentPanel().add((Component)buttonPanel, "South");
        }

        @Override
        public void handleWizardEvent(WizardEvent event) {
            if (event.eventType == 0) {
                List memberList = TypeCustomizer.this.type.getMemberList();
                DataMember member = null;
                if (memberList != null && TypeCustomizer.this.currentMemberIndex < memberList.size()) {
                    member = (DataMember)memberList.get(TypeCustomizer.this.currentMemberIndex);
                }
                PropertyBrowser oe = this.getPropertyBrowser();
                try {
                    oe.setObject(member, true);
                }
                catch (XMLDriverException e) {
                }
                catch (CloneNotSupportedException e) {
                    // empty catch block
                }
                oe.setObjectModified(true);
                oe.setOriginalObject(member);
                this.canMoveForward = memberList != null && TypeCustomizer.this.currentMemberIndex < memberList.size() - 1;
                this.updateNavigator();
            } else if (event.eventType == 2 || event.eventType == 3 || event.eventType == 4) {
                PropertyBrowser oe = this.getPropertyBrowser();
                if (!oe.saveObject()) {
                    event.cancel = true;
                    return;
                }
                TypeCustomizer.clearPropertyBrowser(this);
                if (event.eventType == 3) {
                    ++TypeCustomizer.this.currentMemberIndex;
                    event.wizard.displayPage(null);
                    event.cancel = true;
                } else if (event.eventType == 4 && TypeCustomizer.this.currentMemberIndex != 0) {
                    --TypeCustomizer.this.currentMemberIndex;
                    event.wizard.displayPage(null);
                    event.cancel = true;
                    return;
                }
            } else if (event.eventType == 1) {
                TypeCustomizer.clearPropertyBrowser(this);
            }
        }

        @Override
        public boolean executeSave(PropertyBrowser pb) {
            DataMember member = (DataMember)TypeCustomizer.this.type.getMemberList().get(TypeCustomizer.this.currentMemberIndex);
            DataMember modifiedMember = (DataMember)pb.getModifiedObject();
            try {
                member.copyFrom((Object)modifiedMember, 1);
            }
            catch (CloneNotSupportedException e) {
                ExceptionUtil.printTrace((Throwable)e);
            }
            return true;
        }
    }
}

