/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.generator.wizard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openbp.cockpit.generator.Generator;
import org.openbp.cockpit.generator.GeneratorContext;
import org.openbp.cockpit.generator.GeneratorSettings;
import org.openbp.cockpit.generator.wizard.GeneratorWizard;
import org.openbp.common.MsgFormat;
import org.openbp.common.rc.ResourceCollection;
import org.openbp.common.template.TemplateEngineResult;
import org.openbp.common.template.writer.CancelException;
import org.openbp.common.template.writer.MergeModeRequester;
import org.openbp.common.template.writer.TemplateWriter;
import org.openbp.core.model.Association;
import org.openbp.jaspira.action.ActionMgr;
import org.openbp.jaspira.event.JaspiraEventMgr;
import org.openbp.jaspira.gui.wizard.JaspiraWizardResultPage;
import org.openbp.swing.SwingUtil;
import org.openbp.swing.components.JMsgBox;
import org.openbp.swing.components.popupfield.JPopupField;
import org.openbp.swing.components.popupfield.JSelectionField;
import org.openbp.swing.components.wizard.Wizard;
import org.openbp.swing.components.wizard.WizardEvent;
import org.openbp.swing.layout.VerticalFlowLayout;

public class WizardResultPage
extends JaspiraWizardResultPage {
    public static final int MODE_START = 0;
    public static final int MODE_RUN = 1;
    public static final int MODE_SUCCESS = 2;
    public static final int MODE_ERROR = 3;
    private JPanel startPanel;
    private JPanel settingsPanel;
    private JButton runButton;
    private JCheckBox openCheckBox;
    private ResourceCollection resourceCollection;
    private boolean generatorPerformed;

    public WizardResultPage(GeneratorWizard wizard) {
        super((Wizard)wizard);
        this.resourceCollection = wizard.getResource();
        this.addStartPanel();
        Generator generator = this.getContext().getSelectedGenerator();
        if (generator.isShowOpenResultCheckBox()) {
            this.addOpenPanel();
        }
    }

    private void addStartPanel() {
        this.startPanel = new JPanel(new BorderLayout());
        JPanel buttonPanel = new JPanel(new FlowLayout(1, 0, 0));
        buttonPanel.setBorder(new EmptyBorder(12, 0, 0, 0));
        String text = this.resourceCollection.getRequiredString("wizard.result.runbutton");
        this.runButton = new JButton(ActionMgr.getStringWithoutMnemonicDelimiter(text));
        this.runButton.setMnemonic(ActionMgr.getMnemonicChar(text));
        this.runButton.setPreferredSize(new Dimension(120, 26));
        buttonPanel.add((Component)this.runButton, "Center");
        this.runButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WizardResultPage.this.start();
            }
        });
        this.settingsPanel = new JPanel((LayoutManager)new VerticalFlowLayout());
        JPanel modePanel = this.createModePanel();
        JPanel outputDirPanel = this.createOutputDirPanel();
        this.settingsPanel.add(modePanel);
        this.settingsPanel.add(outputDirPanel);
        this.startPanel.add((Component)buttonPanel, "Center");
        this.getProgressPanel().add((Component)this.startPanel, "Center");
    }

    public JPanel createOutputDirPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(new EmptyBorder(0, 0, 0, 0));
        JLabel outputDirLabel = new JLabel(this.resourceCollection.getRequiredString("wizard.result.outputdirlabel"));
        outputDirLabel.setBorder(new EmptyBorder(0, 0, 0, 5));
        panel.add((Component)outputDirLabel, "West");
        final JPopupField outputDirField = new JPopupField(){

            public boolean isPopupVisible() {
                return false;
            }

            public void setPopupVisible(boolean popupVisible) {
                if (popupVisible) {
                    int retVal;
                    JFileChooser fileChooser = new JFileChooser();
                    fileChooser.setFileSelectionMode(1);
                    File f = new File(this.getText());
                    if (f.exists()) {
                        fileChooser.setCurrentDirectory(f);
                    }
                    if ((retVal = fileChooser.showOpenDialog(null)) == 0) {
                        this.setText(fileChooser.getSelectedFile().getPath());
                    }
                }
            }
        };
        outputDirField.getTextField().getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                WizardResultPage.this.getContext().setOutputRootDir(outputDirField.getText());
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                WizardResultPage.this.getContext().setOutputRootDir(outputDirField.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                WizardResultPage.this.getContext().setOutputRootDir(outputDirField.getText());
            }
        });
        panel.add((Component)outputDirField, "Center");
        outputDirField.setText(this.getContext().getOutputRootDir());
        return panel;
    }

    public JPanel createModePanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(new EmptyBorder(0, 0, 0, 0));
        JLabel outputDirLabel = new JLabel(this.resourceCollection.getRequiredString("wizard.result.overwritelabel"));
        outputDirLabel.setBorder(new EmptyBorder(0, 0, 0, 5));
        panel.add((Component)outputDirLabel, "West");
        final JSelectionField sf = new JSelectionField();
        sf.addItem((Object)this.resourceCollection.getRequiredString("wizard.result.overwrite.ask"));
        sf.addItem((Object)this.resourceCollection.getRequiredString("wizard.result.overwrite.merge"));
        sf.addItem((Object)this.resourceCollection.getRequiredString("wizard.result.overwrite.overwrite"));
        sf.setEditable(false);
        sf.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                String sOverwriteMode = null;
                switch (sf.getSelectedIndex()) {
                    case 1: {
                        sOverwriteMode = "merge";
                        break;
                    }
                    case 2: {
                        sOverwriteMode = "overwrite";
                    }
                }
                WizardResultPage.this.getContext().setOverwriteMode(sOverwriteMode);
            }
        });
        String sOverwriteMode = this.getContext().getOverwriteMode();
        int iOverwriteMode = 0;
        if ("merge".equals(sOverwriteMode)) {
            iOverwriteMode = 1;
        } else if ("overwrite".equals(sOverwriteMode)) {
            iOverwriteMode = 2;
        }
        sf.setSelectedIndex(iOverwriteMode);
        panel.add((Component)sf, "Center");
        return panel;
    }

    private void addOpenPanel() {
        JPanel checkBoxPanel = new JPanel(new BorderLayout());
        String text = this.resourceCollection.getRequiredString("wizard.result.opendocument");
        this.openCheckBox = new JCheckBox(ActionMgr.getStringWithoutMnemonicDelimiter(text));
        this.openCheckBox.setMnemonic(ActionMgr.getMnemonicChar(text));
        checkBoxPanel.add(this.openCheckBox);
        this.getTextPanel().add((Component)checkBoxPanel, "South");
    }

    private void showStartPanel(int mode) {
        String descriptionResourceName;
        String titleResourceName;
        switch (mode) {
            case 1: {
                titleResourceName = "wizard.result.title.generating";
                descriptionResourceName = "wizard.result.description.generating";
                break;
            }
            case 2: {
                titleResourceName = "wizard.result.title.finished";
                descriptionResourceName = "wizard.result.description.finished";
                break;
            }
            case 3: {
                titleResourceName = "wizard.result.title.errors";
                descriptionResourceName = "wizard.result.description.errors";
                break;
            }
            default: {
                titleResourceName = "wizard.result.title.generator";
                descriptionResourceName = "wizard.result.description.generator";
            }
        }
        this.setTitle(this.resourceCollection.getRequiredString(titleResourceName));
        this.setDescription(this.resourceCollection.getRequiredString(descriptionResourceName));
        JPanel cp = this.getContentPanel();
        if (mode == 0) {
            this.getConsole().flush();
        }
        this.canCancel = mode != 1;
        this.getProgressBar().setVisible(mode == 1);
        this.startPanel.setVisible(mode != 1);
        this.updatePage(false);
        cp.validate();
    }

    @Override
    public Component getFocusComponent() {
        if (this.runButton.isEnabled()) {
            return this.runButton;
        }
        return super.getFocusComponent();
    }

    @Override
    protected void preProcess() throws Exception {
        this.showStartPanel(1);
        this.getProgressBar().setIndeterminate(true);
        this.getConsole().mapAll(true);
        GeneratorContext context = this.getContext();
        context.setProperty("mergeModeRequester", new GeneratorMergeModeRequester());
        Generator generator = context.getSelectedGenerator();
        generator.preProcess(context);
    }

    @Override
    protected void process() throws Exception {
        GeneratorContext context = this.getContext();
        Generator generator = context.getSelectedGenerator();
        generator.performProcess(context);
    }

    @Override
    protected void postProcess(boolean success) throws Exception {
        if (success) {
            GeneratorContext context = this.getContext();
            Generator generator = context.getSelectedGenerator();
            generator.postProcess(context);
            this.getConsole().unmapAll();
            this.getConsole().writeText(this.resourceCollection.getRequiredString("wizard.result.progress.finished"));
            this.getProgressBar().setIndeterminate(false);
            this.getProgressBar().setValue(100);
            TemplateEngineResult resultList = context.getTemplateEngineResult();
            if (resultList != null) {
                this.showStartPanel(2);
            } else {
                this.showStartPanel(3);
            }
            this.generatorPerformed = true;
            if (this.openCheckBox != null) {
                this.openCheckBox.requestFocus();
            }
        } else {
            this.getConsole().unmapAll();
            this.getProgressBar().setIndeterminate(false);
            this.getProgressBar().setValue(100);
            this.showStartPanel(3);
        }
    }

    @Override
    protected void processException(Throwable t) {
        if (t instanceof CancelException) {
            return;
        }
        t.printStackTrace();
        System.err.println();
        System.err.println(t.toString());
        super.processException(t);
    }

    @Override
    public void handleWizardEvent(WizardEvent event) {
        if (event.eventType == 0) {
            Generator generator = this.getContext().getSelectedGenerator();
            if (generator.getTemplateName() != null) {
                if (this.settingsPanel.getParent() == null) {
                    this.startPanel.add((Component)this.settingsPanel, "North");
                }
            } else if (this.settingsPanel.getParent() != null) {
                this.startPanel.remove(this.settingsPanel);
            }
            this.showStartPanel(0);
        } else if (event.eventType == 6) {
            String msg;
            int ret;
            if (!this.generatorPerformed && this.getContext().isNeedGeneration() && (ret = JMsgBox.show(null, (String)(msg = this.resourceCollection.getRequiredString("wizard.result.warnexit")), (int)12)) != 4) {
                event.cancel = true;
                return;
            }
            TemplateEngineResult resultList = this.getContext().getTemplateEngineResult();
            if (resultList != null && this.openCheckBox != null && this.openCheckBox.isSelected()) {
                String fileToOpen = resultList.getFirstFileName();
                if (fileToOpen == null) {
                    return;
                }
                String mimeType = resultList.getMimeType(fileToOpen);
                Association as = new Association();
                as.setAssociationTypes(new String[]{mimeType, "text/plain"});
                as.setAssociationPriority(1);
                as.setAssociatedObject((Object)new File(fileToOpen).getAbsolutePath());
                JaspiraEventMgr.fireGlobalEvent("plugin.association.open", as);
            }
        }
    }

    public GeneratorContext getContext() {
        return ((GeneratorWizard)this.getWizard()).getContext();
    }

    public Generator getGenerator() {
        return ((GeneratorWizard)this.getWizard()).getContext().getSelectedGenerator();
    }

    public GeneratorSettings getGeneratorSettings() {
        return ((GeneratorWizard)this.getWizard()).getContext().getGeneratorSettings();
    }

    private class GeneratorMergeModeRequester
    implements MergeModeRequester {
        public int determineMergeMode(TemplateWriter writer) {
            String title = WizardResultPage.this.resourceCollection.getRequiredString("wizard.result.mergedialog.title");
            String text = WizardResultPage.this.resourceCollection.getRequiredString("wizard.result.mergedialog.text");
            text = MsgFormat.format((String)text, (Object)writer.getFileName());
            JMsgBox msgBox = new JMsgBox((Component)((Object)WizardResultPage.this), title, text, 14);
            msgBox.setResource(WizardResultPage.this.resourceCollection);
            msgBox.setResourcePrefix("wizard.result.mergedialog.");
            msgBox.initDialog();
            SwingUtil.show((JDialog)msgBox);
            int choice = msgBox.getUserChoice();
            int mode = -1;
            if (choice == 4) {
                mode = 1;
            } else if (choice == 8) {
                mode = 0;
            }
            return mode;
        }
    }
}

