/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.itemeditor;

import org.openbp.cockpit.itemeditor.StandardItemEditor;
import org.openbp.core.model.Model;
import org.openbp.core.model.ModelException;
import org.openbp.core.model.ModelQualifier;
import org.openbp.core.model.item.Item;
import org.openbp.core.model.item.activity.ActivityItem;
import org.openbp.core.model.item.process.ProcessItem;
import org.openbp.core.model.item.type.ComplexTypeItem;
import org.openbp.guiclient.event.OpenEvent;
import org.openbp.guiclient.event.OpenEventInfo;
import org.openbp.guiclient.model.ModelConnector;
import org.openbp.guiclient.model.item.ItemEditor;
import org.openbp.guiclient.model.item.ItemEditorRegistry;
import org.openbp.jaspira.event.JaspiraEventHandlerCode;
import org.openbp.jaspira.event.RequestEvent;
import org.openbp.jaspira.gui.plugin.JaspiraPage;
import org.openbp.jaspira.plugin.AbstractPlugin;
import org.openbp.jaspira.plugin.EventModule;
import org.openbp.swing.components.JMsgBox;

public class ItemOpenDispatcherPlugin
extends AbstractPlugin {
    @Override
    public String getResourceCollectionContainerName() {
        return "plugin.cockpit";
    }

    public class Events
    extends EventModule {
        protected JaspiraPage modelerPage;

        @Override
        public String getName() {
            return "global.edit";
        }

        @Override
        public int getPriority() {
            return 2;
        }

        public JaspiraEventHandlerCode open_componenteditor(OpenEvent oe) {
            Object o = oe.getObject();
            if (o instanceof ModelQualifier) {
                ModelQualifier qualifier = (ModelQualifier)o;
                try {
                    o = ModelConnector.getInstance().getItemByQualifier(qualifier, true);
                }
                catch (ModelException sie) {
                    String msg = "The component '" + qualifier + "' does not exist.";
                    JMsgBox.show(null, (String)msg, (int)262144);
                    return EVENT_CONSUMED;
                }
                oe.setObject(o);
            }
            if (o instanceof ActivityItem || o instanceof ProcessItem || o instanceof ComplexTypeItem) {
                Item item = (Item)o;
                ItemEditor editor = ItemEditorRegistry.getInstance().lookupItemEditor(item.getItemType());
                if (editor != null) {
                    StandardItemEditor.ensureProcessType(item);
                    editor.openItem(item, 3);
                }
                return EVENT_CONSUMED;
            }
            if (o instanceof Model || o instanceof Item) {
                ItemOpenDispatcherPlugin.this.fireEvent("plugin.itembrowser.open", oe);
                return EVENT_CONSUMED;
            }
            return EVENT_IGNORED;
        }

        public JaspiraEventHandlerCode plugin_association_supports(RequestEvent event) {
            String mimeType = (String)event.getObject();
            if ("application/x-openbp-activity".equals(mimeType) || "application/x-openbp-process".equals(mimeType) || "application/x-openbp-complex-type".equals(mimeType)) {
                event.addResult(new OpenEventInfo("open.componenteditor", mimeType, ItemOpenDispatcherPlugin.this.getPluginResourceCollection().getRequiredString("title.association.editor")));
                return EVENT_HANDLED;
            }
            return EVENT_IGNORED;
        }
    }
}

