/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.itemeditor;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import org.openbp.cockpit.generator.Generator;
import org.openbp.cockpit.generator.GeneratorContext;
import org.openbp.cockpit.generator.GeneratorMgr;
import org.openbp.cockpit.generator.GeneratorSettings;
import org.openbp.cockpit.generator.wizard.GeneratorWizard;
import org.openbp.cockpit.generator.wizard.WizardSelectionPage;
import org.openbp.common.ExceptionUtil;
import org.openbp.common.generic.msgcontainer.MsgContainer;
import org.openbp.common.generic.msgcontainer.StandardMsgContainer;
import org.openbp.common.generic.propertybrowser.PropertyDescriptor;
import org.openbp.common.io.xml.XMLDriver;
import org.openbp.common.io.xml.XMLDriverException;
import org.openbp.common.rc.ResourceCollectionMgr;
import org.openbp.core.model.Model;
import org.openbp.core.model.ModelQualifier;
import org.openbp.core.model.item.Item;
import org.openbp.core.model.item.activity.PlaceholderItem;
import org.openbp.core.model.item.process.ProcessItem;
import org.openbp.guiclient.model.ModelConnector;
import org.openbp.guiclient.model.item.ItemEditor;
import org.openbp.guiclient.model.item.ItemIconMgr;
import org.openbp.jaspira.gui.interaction.DragDropPane;
import org.openbp.jaspira.gui.interaction.DropableDialog;
import org.openbp.jaspira.gui.plugin.PluginFocusMgr;
import org.openbp.jaspira.gui.plugin.VisiblePlugin;
import org.openbp.jaspira.gui.wizard.JaspiraWizardObjectPage;
import org.openbp.jaspira.plugin.ApplicationUtil;
import org.openbp.jaspira.propertybrowser.NodeStructureMgr;
import org.openbp.jaspira.propertybrowser.PropertyBrowser;
import org.openbp.jaspira.propertybrowser.nodes.ObjectNode;
import org.openbp.jaspira.propertybrowser.nodes.PropertyNode;
import org.openbp.swing.components.JMsgBox;
import org.openbp.swing.components.wizard.Wizard;
import org.openbp.swing.components.wizard.WizardEvent;

public class StandardItemEditor
extends GeneratorWizard
implements ItemEditor {
    public static final String PROPERTY_PAGE = "property";
    private PropertyPage propertyPage;
    private DropableDialog dialog;
    private DragDropPane dndPane;

    public StandardItemEditor() {
        super(null);
        this.setWizardResource(ResourceCollectionMgr.getDefaultInstance().getResource("cockpit", this.getClass()));
        if (this.propertyPage == null) {
            this.propertyPage = new PropertyPage(this);
        }
        JFrame activeFrame = ApplicationUtil.getActiveWindow();
        this.dialog = new DropableDialog((Frame)activeFrame, true);
        DragDropPane.installDragDropPane(this.dialog);
        this.dndPane = this.dialog.getDragDropPane();
        this.dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                StandardItemEditor.this.fireWizardEvent(1);
            }
        });
        this.dialog.getContentPane().add((Component)((Object)this));
    }

    protected void addPropertyPage() {
        this.addAndLinkPage(PROPERTY_PAGE, (Component)((Object)this.propertyPage));
    }

    protected Dimension getInitialSize() {
        return new Dimension(800, 600);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setupPages() {
        ApplicationUtil.waitCursorOn();
        try {
            List list;
            this.clearPages();
            Item item = this.context.getItem();
            if (this.context.getSelectedGenerator() == null && (list = GeneratorMgr.getInstance().getGenerators(item.getItemType(), true)) != null) {
                Generator gen;
                int n = list.size();
                if (n > 1) {
                    WizardSelectionPage selectionPage = new WizardSelectionPage(this);
                    for (int i = 0; i < n; ++i) {
                        Generator generator = (Generator)list.get(i);
                        selectionPage.addGenerator(generator);
                    }
                    selectionPage.expandTree();
                    this.addAndLinkPage("selection", (Component)((Object)selectionPage));
                } else if (n == 1 && (gen = (Generator)list.get(0)) != null) {
                    this.context.setSelectedGenerator(gen);
                    GeneratorSettings settings = new GeneratorSettings();
                    settings.setGeneratorName(gen.getName());
                    this.context.setGeneratorSettings(settings);
                    this.context.setProperty("settings", settings);
                }
            }
            this.addPropertyPage();
        }
        finally {
            ApplicationUtil.waitCursorOff();
        }
    }

    protected void setupPosition() {
        this.displayFirst();
    }

    @Override
    public Item openItem(Item item, int editedItemStatus) {
        boolean isNewItem = editedItemStatus == 1 || editedItemStatus == 2;
        ImageIcon icon = (ImageIcon)ItemIconMgr.getInstance().getIcon(item, 48);
        this.setDefaultWizardImage(icon);
        this.setPageResourcePrefix(item.getItemType().toLowerCase());
        String title = this.getPageResourceString(null, "title");
        this.dialog.setTitle(title);
        this.context = new GeneratorContext();
        if (!isNewItem) {
            this.context.setOriginalItem(item);
            try {
                item = (Item)item.clone();
            }
            catch (CloneNotSupportedException e) {
                ExceptionUtil.printTrace((Throwable)e);
            }
            item.maintainReferences(10);
        }
        this.context.setItem(item);
        this.context.setNewItem(isNewItem);
        if (editedItemStatus == 1) {
            this.context.setEmptyItem(true);
        }
        if (!this.parseGeneratorInfo(item) && item instanceof ProcessItem) {
            this.determineGeneratorFromProcessType((ProcessItem)item);
        }
        if (item instanceof PlaceholderItem) {
            this.dialog.setSize(new Dimension(600, 450));
        } else {
            this.dialog.setSize(this.getInitialSize());
        }
        this.dialog.setLocationRelativeTo(ApplicationUtil.getActiveWindow());
        this.setupPages();
        this.updateGeneratorPageSequence();
        this.setupPosition();
        VisiblePlugin focusedPlugin = PluginFocusMgr.getInstance().getFocusedPlugin();
        this.dialog.setVisible(true);
        if (focusedPlugin != null) {
            focusedPlugin.focusPlugin();
        }
        Item ret = this.context.getItem();
        this.context = null;
        return ret;
    }

    protected boolean parseGeneratorInfo(Item item) {
        GeneratorMgr.getInstance();
        String generatorInfo = item.getGeneratorInfo();
        if (generatorInfo != null) {
            GeneratorSettings settings;
            generatorInfo = "<?xml version=\"1.0\" encoding=\"" + XMLDriver.getInstance().getEncoding() + "\"?>" + generatorInfo;
            ByteArrayInputStream is = new ByteArrayInputStream(generatorInfo.getBytes());
            try {
                settings = (GeneratorSettings)XMLDriver.getInstance().deserializeStream(GeneratorSettings.class, (InputStream)is);
                StandardMsgContainer msgs = new StandardMsgContainer();
                settings.setModel(item.getModel());
                settings.afterDeserialization((MsgContainer)msgs);
                if (!msgs.isEmpty()) {
                    JMsgBox.show(null, (String)msgs.toString(), (int)0x40040001);
                }
            }
            catch (XMLDriverException e) {
                ExceptionUtil.printTrace((Throwable)e);
                return false;
            }
            String name = settings.getGeneratorName();
            Generator gen = GeneratorMgr.getInstance().getGenerator(name);
            if (gen != null) {
                this.context.setSelectedGenerator(gen);
                this.context.setGeneratorSettings(settings);
                this.context.setProperty("settings", settings);
            }
            return true;
        }
        return false;
    }

    private void determineGeneratorFromProcessType(ProcessItem item) {
        String processType = item.getProcessType();
        if (processType != null) {
            String generatorName = "Process" + processType;
            Generator gen = GeneratorMgr.getInstance().getGenerator(generatorName);
            if (gen != null) {
                this.context.setSelectedGenerator(gen);
                GeneratorSettings settings = new GeneratorSettings();
                settings.setGeneratorName(generatorName);
                this.context.setGeneratorSettings(settings);
                this.context.setProperty("settings", settings);
            }
        }
    }

    public static void ensureProcessType(Item item) {
        ProcessItem process;
        if (item instanceof ProcessItem && (process = (ProcessItem)item).getProcessType() == null) {
            process.setProcessType("UserInterface");
        }
    }

    public DropableDialog getDialog() {
        return this.dialog;
    }

    public DragDropPane getDndPane() {
        return this.dndPane;
    }

    private class PropertyPage
    extends JaspiraWizardObjectPage {
        public PropertyPage(StandardItemEditor wizard) {
            super((Wizard)wizard);
            this.canFinish = true;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void handleWizardEvent(WizardEvent event) {
            if (event.eventType == 0) {
                this.initializePropertyBrowser();
                return;
            }
            if (event.eventType != 2 && event.eventType != 3 && event.eventType != 4) {
                if (event.eventType != 1) return;
                this.clearPropertyBrowser();
                return;
            }
            boolean failed = false;
            PropertyBrowser oe = this.getPropertyBrowser();
            if (!oe.saveObject()) {
                failed = true;
                if (event.eventType != 4) {
                    event.cancel = true;
                    return;
                }
                this.clearPropertyBrowser();
            } else {
                this.clearPropertyBrowser();
            }
            Item item = StandardItemEditor.this.context.getItem();
            if (!StandardItemEditor.this.context.isNewItem()) return;
            if (StandardItemEditor.this.context.isItemSaved()) return;
            if (failed) return;
            try {
                ModelQualifier itemQualifier = item.getQualifier();
                if (item instanceof Model) {
                    if (ModelConnector.getInstance().getOptionalModelByQualifier(itemQualifier) == null) return;
                    String msg = "The model '" + itemQualifier + "' already exists.\nPlease choose another name.";
                    JMsgBox.show(null, (String)msg, (int)131072);
                    event.cancel = true;
                    return;
                }
                if (ModelConnector.getInstance().getItemByQualifier(itemQualifier, false) == null) return;
                String msg = "The component '" + itemQualifier + "' already exists.\nPlease choose another name.";
                JMsgBox.show(null, (String)msg, (int)131072);
                event.cancel = true;
                return;
            }
            catch (Exception e) {
                return;
            }
        }

        @Override
        public boolean executeSave(PropertyBrowser pb) {
            Item modifiedItem = (Item)pb.getModifiedObject();
            try {
                StandardItemEditor.this.context.getItem().copyFrom((Object)modifiedItem, 1);
            }
            catch (CloneNotSupportedException e) {
                ExceptionUtil.printTrace((Throwable)e);
            }
            return true;
        }

        private void initializePropertyBrowser() {
            GeneratorContext context = StandardItemEditor.this.getContext();
            Item item = context.getItem();
            PropertyBrowser oe = this.getPropertyBrowser();
            oe.setObjectModified(false);
            oe.setOriginalObject(context.getOriginalItem());
            try {
                if (context.isNewItem() && !context.isItemSaved()) {
                    ObjectNode rootNode = NodeStructureMgr.getInstance().createEditorStructureFor(item.getClass());
                    this.changeReadOnlyModeOfPropertyDescriptor(rootNode, "Name", false);
                    boolean newFlag = !context.isItemSaved();
                    oe.setObject((Object)item, newFlag, rootNode);
                } else {
                    oe.setObject(item, false);
                }
            }
            catch (XMLDriverException e) {
                ExceptionUtil.printTrace((Throwable)e);
            }
            catch (CloneNotSupportedException e) {
                ExceptionUtil.printTrace((Throwable)e);
            }
        }

        private void changeReadOnlyModeOfPropertyDescriptor(ObjectNode rootNode, String propertyName, boolean readOnly) {
            PropertyNode propertyNode = (PropertyNode)rootNode.findNodeForProperty(propertyName);
            if (propertyNode != null) {
                PropertyDescriptor pd = propertyNode.getPropertyDescriptor();
                try {
                    pd = (PropertyDescriptor)pd.clone();
                    pd.setReadOnly(readOnly);
                    propertyNode.setPropertyDescriptor(pd);
                }
                catch (CloneNotSupportedException e) {
                    ExceptionUtil.printTrace((Throwable)e);
                }
            }
        }

        private void clearPropertyBrowser() {
            PropertyBrowser oe = this.getPropertyBrowser();
            try {
                oe.setObjectModified(false);
                oe.setObject(null, false);
                oe.setOriginalObject(null);
            }
            catch (XMLDriverException e) {
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
        }
    }
}

