/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.modeler;

import CH.ifa.draw.framework.Figure;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.openbp.cockpit.modeler.Modeler;
import org.openbp.cockpit.modeler.drawing.ProcessDrawing;
import org.openbp.cockpit.modeler.drawing.WorkspaceDrawingView;
import org.openbp.cockpit.modeler.figures.process.FlowConnection;
import org.openbp.cockpit.modeler.figures.process.InitialNodeFigure;
import org.openbp.cockpit.modeler.figures.process.NodeFigure;
import org.openbp.cockpit.modeler.figures.process.ParamConnection;
import org.openbp.cockpit.modeler.figures.process.SocketFigure;
import org.openbp.cockpit.modeler.util.FigureUtil;
import org.openbp.common.util.NamedObjectCollectionUtil;
import org.openbp.core.model.item.process.DataLink;
import org.openbp.core.model.item.process.DataLinkImpl;
import org.openbp.core.model.item.process.Node;
import org.openbp.core.model.item.process.NodeParam;
import org.openbp.core.model.item.process.NodeSocket;
import org.openbp.core.model.item.process.Param;
import org.openbp.core.model.item.process.PlaceholderNode;
import org.openbp.core.model.item.process.ProcessItem;
import org.openbp.core.model.item.process.ProcessVariable;
import org.openbp.core.model.item.process.VisualNode;
import org.openbp.core.model.item.type.DataTypeItem;
import org.openbp.jaspira.option.OptionMgr;

public class AutoConnector {
    public static final int DLA_OFF = 0;
    public static final int DLA_IDENTICAL_NAMES = 1;
    public static final int DLA_IDENTICAL_TYPES = 2;
    public static final int DLA_COMPATIBLE_TYPES = 3;
    public static final int DLA_CASTABLE_TYPES = 4;
    public static final int DLA_CONVERTIBLE_TYPES = 5;
    private Modeler modeler;
    private WorkspaceDrawingView workspaceView;
    private NodeFigure newNodeFigure;
    private Figure selectedFigure;
    private SocketFigure sourceSocketFigure;
    private SocketFigure targetSocketFigure;
    private NodeSocket sourceSocket;
    private NodeSocket targetSocket;
    private List sourceParams;
    private List targetParams;
    private boolean connectedDataLink;
    private static int dataLinkAutoConnectorMode;

    public AutoConnector(Modeler modeler, Figure newFigure) {
        this.modeler = modeler;
        this.workspaceView = modeler.getDrawingView();
        this.determineSocketFiguresFromSelection(newFigure);
    }

    public AutoConnector(Modeler modeler, SocketFigure sourceSocketFigure, SocketFigure targetSocketFigure) {
        this.modeler = modeler;
        this.workspaceView = modeler.getDrawingView();
        this.sourceSocketFigure = sourceSocketFigure;
        this.targetSocketFigure = targetSocketFigure;
    }

    public static int getDataLinkAutoConnectorMode() {
        return dataLinkAutoConnectorMode;
    }

    public static void determineDataLinkAutoConnectorMode() {
        dataLinkAutoConnectorMode = OptionMgr.getInstance().getIntegerOption("editor.autoconnector.datalink", 5);
    }

    public static String checkAutoConversion(Param sourceParam, String sourceMemberPath, Param targetParam, String targetMemberPath) {
        if (dataLinkAutoConnectorMode < 5) {
            return null;
        }
        return DataLinkImpl.checkAutoConversion((Param)sourceParam, (String)sourceMemberPath, (Param)targetParam, (String)targetMemberPath);
    }

    public void autoConnectAll() {
        boolean doAutoConnect = OptionMgr.getInstance().getBooleanOption("editor.autoconnector.controllink", true);
        if (!doAutoConnect) {
            this.selectedFigure = null;
        }
        this.adjustNodeGeometry();
        if (!this.autoConnectControlLink()) {
            return;
        }
        this.autoConnectDataLinks();
    }

    public boolean autoConnectControlLink() {
        FlowConnection connection;
        if (this.checkSockets() && this.sourceSocketFigure.canConnect() && this.targetSocketFigure.canConnect() && (connection = new FlowConnection(this.modeler.getDrawing())).canConnectFigures(this.sourceSocketFigure, this.targetSocketFigure, 0) && this.sourceSocketFigure.getNodeSocket().getNode() != this.targetSocketFigure.getNodeSocket().getNode()) {
            this.modeler.startUndo("Auto-connect sockets");
            connection.connectStart(this.sourceSocketFigure.connectorAt(0, 0));
            connection.connectEnd(this.targetSocketFigure.connectorAt(0, 0));
            this.modeler.getDrawing().add(connection);
            connection.layoutAndAdjustConnection();
            this.modeler.endUndo();
            this.autoAdjustPlaceholderName();
            return true;
        }
        return false;
    }

    private void autoAdjustPlaceholderName() {
        Node sourceNode = this.sourceSocketFigure.getNodeSocket().getNode();
        Node targetNode = this.targetSocketFigure.getNodeSocket().getNode();
        if (sourceNode instanceof VisualNode && targetNode instanceof PlaceholderNode) {
            String socketName = this.sourceSocketFigure.getNodeSocket().getName();
            String socketDisplayName = this.sourceSocketFigure.getNodeSocket().getDisplayName();
            this.modeler.startUndo("Auto-adjust placeholder name");
            targetNode.setName(NamedObjectCollectionUtil.createUniqueId((Collection)sourceNode.getProcess().getNodeList(), (String)socketName));
            targetNode.setDisplayName(socketDisplayName);
            this.newNodeFigure.updateFigure();
            this.modeler.endUndo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean autoConnectDataLinks() {
        if (!this.checkSockets()) {
            return false;
        }
        if (dataLinkAutoConnectorMode == 0) {
            return false;
        }
        this.sourceParams = this.sourceSocket.getParamList();
        this.sourceParams = this.excludeLinkedParams(this.sourceParams);
        if (this.sourceParams == null) {
            return false;
        }
        this.targetParams = this.targetSocket.getParamList();
        this.targetParams = this.excludeLinkedParams(this.targetParams);
        if (this.targetParams == null) {
            return false;
        }
        try {
            this.tryConnectParams(1);
            if (dataLinkAutoConnectorMode == 1) {
                boolean bl = false;
                return bl;
            }
            this.tryConnectParams(2);
            if (dataLinkAutoConnectorMode == 2) {
                boolean bl = false;
                return bl;
            }
            this.tryConnectParams(3);
            if (dataLinkAutoConnectorMode == 3) {
                boolean bl = false;
                return bl;
            }
            this.tryConnectParams(4);
            if (dataLinkAutoConnectorMode == 4) {
                boolean bl = false;
                return bl;
            }
            this.tryConnectParams(5);
            if (dataLinkAutoConnectorMode == 5) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            if (this.connectedDataLink) {
                this.modeler.endUndo();
            } else {
                this.modeler.cancelUndo();
            }
        }
        return this.connectedDataLink;
    }

    private void tryConnectParams(int mode) {
        for (int i = this.sourceParams.size() - 1; i >= 0; --i) {
            NodeParam targetParam;
            NodeParam sourceParam = (NodeParam)this.sourceParams.get(i);
            if (!sourceParam.isVisible() || sourceParam.getAutoConnectorMode() == 0 || AutoConnector.isConnected(sourceParam, this.targetSocket) || (targetParam = this.findTargetParam(sourceParam, mode)) == null || AutoConnector.isConnected(this.sourceSocket, targetParam)) continue;
            this.connect(sourceParam, targetParam);
        }
    }

    private NodeParam findTargetParam(NodeParam sourceParam, int mode) {
        block7: for (int i = this.targetParams.size() - 1; i >= 0; --i) {
            NodeParam targetParam = (NodeParam)this.targetParams.get(i);
            if (!targetParam.isVisible() || targetParam.getAutoConnectorMode() == 0 || targetParam.getExpression() != null) continue;
            DataTypeItem sourceType = sourceParam.getDataType();
            DataTypeItem targetType = targetParam.getDataType();
            switch (mode) {
                case 1: {
                    if (!sourceParam.getName().equals(targetParam.getName()) || sourceType != targetType && !targetType.isBaseTypeOf(sourceType)) continue block7;
                    return targetParam;
                }
                case 2: {
                    if (sourceType != targetType) continue block7;
                    return targetParam;
                }
                case 3: {
                    if (!targetType.isBaseTypeOf(sourceType)) continue block7;
                    return targetParam;
                }
                case 4: {
                    if (!sourceType.isBaseTypeOf(targetType)) continue block7;
                    return targetParam;
                }
                case 5: {
                    String newSourceMemberPath = DataLinkImpl.checkAutoConversion((Param)sourceParam, null, (Param)targetParam, null);
                    if (newSourceMemberPath == null) continue block7;
                    return targetParam;
                }
            }
        }
        return null;
    }

    private void connect(NodeParam sourceParam, NodeParam targetParam) {
        if (!this.modeler.isUndoRecording()) {
            this.modeler.startUndo("Auto-connect parameters");
        }
        ProcessItem process = sourceParam.getProcess();
        DataLink dataLink = process.createDataLink();
        dataLink.link((Param)sourceParam, (Param)targetParam);
        String sourceMemberPath = DataLinkImpl.checkAutoConversion((Param)sourceParam, null, (Param)targetParam, null);
        dataLink.setSourceMemberPath(sourceMemberPath);
        process.addDataLink(dataLink);
        ProcessDrawing drawing = this.modeler.getDrawing();
        ParamConnection connection = drawing.createParamConnection(dataLink);
        drawing.add(connection);
        connection.layoutAndAdjustConnection();
        this.connectedDataLink = true;
    }

    private List<NodeParam> excludeLinkedParams(List<NodeParam> params) {
        ArrayList<NodeParam> ret = null;
        if (params != null) {
            for (NodeParam param : params) {
                ProcessVariable pVar;
                if (param.getDataLinks().hasNext() || (pVar = this.modeler.getProcess().getProcessVariableByName(param.getName())) != null && pVar.isAutoAssign()) continue;
                if (ret == null) {
                    ret = new ArrayList<NodeParam>();
                }
                ret.add(param);
            }
        }
        return ret;
    }

    public void adjustNodeGeometry() {
        boolean isVertical;
        if (this.newNodeFigure == null) {
            return;
        }
        boolean makeVertical = true;
        if (this.selectedFigure != null) {
            makeVertical = FigureUtil.isVerticalRelationship(this.newNodeFigure, this.selectedFigure);
        }
        if (!(isVertical = this.newNodeFigure.isVerticallyOriented()) && makeVertical) {
            this.newNodeFigure.changeOrientation(1);
        } else if (isVertical && !makeVertical) {
            this.newNodeFigure.changeOrientation(2);
        }
        if (this.selectedFigure != null) {
            boolean flip;
            if (makeVertical) {
                flip = this.newNodeFigure.center().y - this.selectedFigure.center().y < 0;
            } else {
                boolean bl = flip = this.newNodeFigure.center().x - this.selectedFigure.center().x < 0;
            }
            if (flip) {
                this.newNodeFigure.flipOrientation();
            }
        }
    }

    private void determineSocketFiguresFromSelection(Figure newFigure) {
        SocketFigure newSocketFigure = null;
        if (newFigure instanceof NodeFigure) {
            this.newNodeFigure = (NodeFigure)newFigure;
        } else if (newFigure instanceof SocketFigure) {
            newSocketFigure = (SocketFigure)newFigure;
        }
        if (this.workspaceView.selectionCount() != 1) {
            return;
        }
        this.selectedFigure = (Figure)this.workspaceView.selection().get(0);
        if (this.newNodeFigure != null) {
            if (this.selectedFigure instanceof NodeFigure) {
                NodeFigure selectedNodeFigure = (NodeFigure)this.selectedFigure;
                if (this.newNodeFigure instanceof InitialNodeFigure) {
                    this.sourceSocketFigure = selectedNodeFigure.getConnectableSocket(true);
                    this.targetSocketFigure = this.newNodeFigure.getConnectableSocket(false);
                } else {
                    this.sourceSocketFigure = this.newNodeFigure.getConnectableSocket(true);
                    this.targetSocketFigure = selectedNodeFigure.getConnectableSocket(false);
                }
            } else if (this.selectedFigure instanceof SocketFigure) {
                SocketFigure selectedSocketFigure = (SocketFigure)this.selectedFigure;
                if (selectedSocketFigure.isEntrySocket()) {
                    this.targetSocketFigure = selectedSocketFigure;
                    this.sourceSocketFigure = this.newNodeFigure.getConnectableSocket(false);
                } else {
                    NodeSocket socket = selectedSocketFigure.getNodeSocket();
                    if (!socket.hasControlLinks() || socket.getNode().isMultiExitLinkNode()) {
                        this.sourceSocketFigure = selectedSocketFigure;
                        this.targetSocketFigure = this.newNodeFigure.getConnectableSocket(true);
                    }
                }
            }
        } else if (newSocketFigure != null) {
            if (this.selectedFigure instanceof NodeFigure) {
                NodeFigure selectedNodeFigure = (NodeFigure)this.selectedFigure;
                if (newSocketFigure.isEntrySocket()) {
                    this.sourceSocketFigure = selectedNodeFigure.getConnectableSocket(false);
                    this.targetSocketFigure = newSocketFigure;
                } else {
                    this.sourceSocketFigure = newSocketFigure;
                    this.targetSocketFigure = selectedNodeFigure.getConnectableSocket(true);
                }
            } else if (this.selectedFigure instanceof SocketFigure) {
                SocketFigure selectedSocketFigure = (SocketFigure)this.selectedFigure;
                if (selectedSocketFigure.isEntrySocket()) {
                    this.sourceSocketFigure = selectedSocketFigure;
                    this.targetSocketFigure = newSocketFigure;
                } else {
                    this.sourceSocketFigure = newSocketFigure;
                    this.targetSocketFigure = selectedSocketFigure;
                }
            }
        }
    }

    private boolean checkSockets() {
        if (this.sourceSocketFigure == null || this.targetSocketFigure == null) {
            return false;
        }
        this.sourceSocket = this.sourceSocketFigure.getNodeSocket();
        this.targetSocket = this.targetSocketFigure.getNodeSocket();
        if (this.sourceSocket.isEntrySocket()) {
            SocketFigure tmp = this.sourceSocketFigure;
            this.sourceSocketFigure = this.targetSocketFigure;
            this.targetSocketFigure = tmp;
            this.sourceSocket = this.sourceSocketFigure.getNodeSocket();
            this.targetSocket = this.targetSocketFigure.getNodeSocket();
        }
        return true;
    }

    private static boolean isConnected(NodeParam sourceParam, NodeSocket targetSocket) {
        Iterator it = sourceParam.getDataLinks();
        while (it.hasNext()) {
            DataLink dataLink = (DataLink)it.next();
            if (!(dataLink.getTargetParam() instanceof NodeParam) || ((NodeParam)dataLink.getTargetParam()).getSocket() != targetSocket) continue;
            return true;
        }
        return false;
    }

    private static boolean isConnected(NodeSocket sourceSocket, NodeParam targetParam) {
        Iterator it = sourceSocket.getNode().getProcess().getDataLinks();
        while (it.hasNext()) {
            DataLink dataLink = (DataLink)it.next();
            if (!(dataLink.getSourceParam() instanceof NodeParam) || ((NodeParam)dataLink.getSourceParam()).getSocket() != sourceSocket || dataLink.getTargetParam() != targetParam) continue;
            return true;
        }
        return false;
    }

    static {
        AutoConnector.determineDataLinkAutoConnectorMode();
    }
}

