/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.modeler;

import CH.ifa.draw.framework.Figure;
import java.awt.Color;
import java.awt.datatransfer.Transferable;
import java.util.Iterator;
import java.util.Vector;
import org.openbp.cockpit.modeler.AutoConnector;
import org.openbp.cockpit.modeler.Modeler;
import org.openbp.cockpit.modeler.ViewModeMgr;
import org.openbp.cockpit.modeler.drawing.WorkspaceDrawingView;
import org.openbp.cockpit.modeler.drawing.shadowlayout.ShadowLayouter;
import org.openbp.cockpit.modeler.figures.process.NodeFigure;
import org.openbp.cockpit.modeler.figures.process.ParamConnection;
import org.openbp.cockpit.modeler.figures.process.ParamFigure;
import org.openbp.cockpit.modeler.figures.process.ProcessElementContainer;
import org.openbp.cockpit.modeler.figures.process.SocketFigure;
import org.openbp.cockpit.modeler.figures.tag.AbstractTagFigure;
import org.openbp.cockpit.modeler.paramvaluewizard.ParamValueWizard;
import org.openbp.cockpit.plugins.miniview.MiniViewEvent;
import org.openbp.common.ExceptionUtil;
import org.openbp.core.model.ModelQualifier;
import org.openbp.core.model.item.process.MultiSocketNode;
import org.openbp.core.model.item.process.ProcessItem;
import org.openbp.core.model.item.process.ProcessObject;
import org.openbp.core.model.item.process.ProcessVariable;
import org.openbp.guiclient.event.OpenEvent;
import org.openbp.guiclient.event.QualifierEvent;
import org.openbp.jaspira.action.ActionMgr;
import org.openbp.jaspira.action.JaspiraAction;
import org.openbp.jaspira.action.JaspiraActionEvent;
import org.openbp.jaspira.event.AskEvent;
import org.openbp.jaspira.event.JaspiraEvent;
import org.openbp.jaspira.event.JaspiraEventHandlerCode;
import org.openbp.jaspira.event.VetoableEvent;
import org.openbp.jaspira.gui.interaction.InteractionClient;
import org.openbp.jaspira.option.Option;
import org.openbp.jaspira.option.OptionMgr;
import org.openbp.jaspira.plugin.ExternalEventModule;
import org.openbp.jaspira.plugin.Plugin;
import org.openbp.jaspira.plugin.PluginMgr;
import org.openbp.jaspira.plugins.propertybrowser.PropertyBrowserSaveEvent;
import org.openbp.jaspira.plugins.statusbar.StatusBarTextEvent;
import org.openbp.swing.components.JMsgBox;

public class ModelerEventModule
extends ExternalEventModule {
    private Modeler modeler;

    public ModelerEventModule(Plugin modeler) {
        super(modeler);
        this.modeler = (Modeler)modeler;
    }

    @Override
    public String getName() {
        return "modeler.view";
    }

    public JaspiraEventHandlerCode global_frame_activated(JaspiraEvent je) {
        if (this.modeler.getToolSupport() != null) {
            this.modeler.getToolSupport().updateToolState();
        }
        return EVENT_CONSUMED;
    }

    public JaspiraEventHandlerCode global_clipboard_updatestatus(JaspiraEvent je) {
        if (je.getSourcePlugin() == this.modeler) {
            boolean flipableSelected = false;
            WorkspaceDrawingView workspaceView = this.modeler.getDrawingView();
            if (workspaceView != null) {
                JaspiraAction action;
                Vector selectedFigures = workspaceView.selection();
                int n = selectedFigures.size();
                if (n > 0) {
                    for (int i = 0; i < n; ++i) {
                        Object o = selectedFigures.get(i);
                        if (!(o instanceof ParamConnection) && !(o instanceof ParamFigure)) continue;
                        flipableSelected = true;
                    }
                }
                if ((action = ActionMgr.getInstance().getAction("modeler.edit.fliporientation")) != null) {
                    action.setEnabled(flipableSelected);
                }
            }
            return EVENT_HANDLED;
        }
        return EVENT_IGNORED;
    }

    public JaspiraEventHandlerCode open_modeler(OpenEvent oe) {
        ModelQualifier qualifier = null;
        Object o = oe.getObject();
        if (o instanceof String) {
            qualifier = new ModelQualifier((String)o);
            qualifier.setItemType("Process");
        } else if (o instanceof ModelQualifier) {
            qualifier = (ModelQualifier)o;
        } else if (o instanceof ProcessItem) {
            qualifier = ((ProcessItem)o).getQualifier();
        }
        if (qualifier != null && this.modeler.getProcessQualifier().matches((Object)qualifier, 7)) {
            this.modeler.focusPlugin();
            ProcessElementContainer pec = this.modeler.getDrawing().getFigureByQualifier(qualifier);
            if (pec != null) {
                WorkspaceDrawingView view = this.modeler.getDrawingView();
                view.singleSelect(pec);
            }
            return EVENT_CONSUMED;
        }
        return EVENT_IGNORED;
    }

    public JaspiraEventHandlerCode global_edit_geteditedinstance(AskEvent ae) {
        Object o = ae.getObject();
        if (o == null || o instanceof ModelQualifier && ((ModelQualifier)o).matches((Object)this.modeler.getProcessQualifier()) || o instanceof ProcessItem && ((ProcessItem)o).getQualifier().matches((Object)this.modeler.getProcessQualifier())) {
            ae.setAnswer(this.modeler.getProcess());
            return EVENT_CONSUMED;
        }
        return EVENT_IGNORED;
    }

    public JaspiraEventHandlerCode global_edit_geteditor(AskEvent ae) {
        Object o = ae.getObject();
        if (o == null || o instanceof ModelQualifier && ((ModelQualifier)o).matches((Object)this.modeler.getProcessQualifier()) || o instanceof ProcessItem && ((ProcessItem)o).getQualifier().matches((Object)this.modeler.getProcessQualifier())) {
            ae.setAnswer(this.modeler);
            return EVENT_CONSUMED;
        }
        return EVENT_IGNORED;
    }

    public JaspiraEventHandlerCode standard_file_save(JaspiraActionEvent jae) {
        if (!this.modeler.getPluginComponent().isShowing()) {
            return EVENT_IGNORED;
        }
        return this.standard_file_saveall(jae);
    }

    public JaspiraEventHandlerCode standard_file_saveall(JaspiraActionEvent jae) {
        ProcessItem process = this.modeler.getProcess();
        if (process == null) {
            return EVENT_IGNORED;
        }
        if (!process.isModified()) {
            return EVENT_IGNORED;
        }
        VetoableEvent ve = new VetoableEvent(this.modeler, "modeler.view.asksave", this.modeler);
        this.modeler.fireEvent(ve);
        if (!ve.isVetoed() && this.modeler.saveProcess()) {
            this.modeler.getDrawing().clearModified();
            this.modeler.fireEvent(new StatusBarTextEvent(this.modeler, "Process " + this.modeler.getProcessQualifier() + " saved."));
            this.modeler.fireEvent(new JaspiraEvent(this.modeler, "modeler.view.saved", this.modeler));
        }
        return EVENT_HANDLED;
    }

    public JaspiraEventHandlerCode standard_file_askdelete(VetoableEvent ve) {
        Object o = ve.getObject();
        ModelQualifier qualifier = null;
        if (o instanceof ModelQualifier) {
            qualifier = (ModelQualifier)o;
        } else if (o instanceof ProcessItem) {
            qualifier = ((ProcessItem)o).getQualifier();
        }
        if (!this.modeler.getProcessQualifier().matches((Object)qualifier)) {
            return EVENT_IGNORED;
        }
        ProcessItem process = this.modeler.getProcess();
        if (process.isModified()) {
            String msg = "" + process.getQualifier() + " has been modified. Really delete?";
            int result = JMsgBox.show(null, (String)msg, (int)0x100000C);
            if (result != 4) {
                ve.veto();
                return EVENT_CONSUMED;
            }
            process.clearModified();
        }
        PluginMgr.getInstance().removeInstance(this.modeler);
        this.modeler.getPluginHolder().unlinkHolder();
        this.modeler.fireEvent("modeler.view.closed", this.modeler);
        return EVENT_HANDLED;
    }

    public JaspiraEventHandlerCode invalidate(QualifierEvent je) {
        ProcessElementContainer pec = this.modeler.getDrawing().getFigureByQualifier(je.getQualifier());
        if (pec == null) {
            return EVENT_IGNORED;
        }
        if (pec instanceof AbstractTagFigure) {
            ((AbstractTagFigure)((Object)pec)).checkDecoratedContentState();
        }
        pec.invalidate();
        return this.modeler.getPluginComponent().isShowing() ? EVENT_CONSUMED : EVENT_IGNORED;
    }

    public JaspiraEventHandlerCode refresh(JaspiraEvent je) {
        this.modeler.getDrawingView().checkDamage();
        return this.modeler.getPluginComponent().isShowing() ? EVENT_CONSUMED : EVENT_IGNORED;
    }

    public JaspiraEventHandlerCode redraw(JaspiraEvent je) {
        this.modeler.getDrawingView().redraw();
        return this.modeler.getPluginComponent().isShowing() ? EVENT_CONSUMED : EVENT_IGNORED;
    }

    public JaspiraEventHandlerCode setzoomfactor(JaspiraEvent je) {
        if (this.modeler.getPluginComponent().isShowing()) {
            double factor = (Double)je.getObject();
            WorkspaceDrawingView view = this.modeler.getDrawingView();
            view.setScaleFactor(factor);
            view.redraw();
            view.revalidate();
            this.modeler.focusPlugin();
            return EVENT_CONSUMED;
        }
        return EVENT_IGNORED;
    }

    public JaspiraEventHandlerCode modechange(JaspiraEvent je) {
        int state = ViewModeMgr.getInstance().getTagState(this.modeler);
        this.modeler.getDrawing().setTagState(state);
        WorkspaceDrawingView view = this.modeler.getDrawingView();
        view.clearSelection();
        view.redraw();
        return EVENT_HANDLED;
    }

    public JaspiraEventHandlerCode updatedrawing(JaspiraEvent je) {
        this.modeler.getDrawing().updateFigure();
        return this.modeler.getPluginComponent().isShowing() ? EVENT_CONSUMED : EVENT_IGNORED;
    }

    public JaspiraEventHandlerCode show(QualifierEvent je) {
        ProcessElementContainer pec = this.modeler.getDrawing().getFigureByQualifier(je.getQualifier());
        if (pec == null) {
            return EVENT_IGNORED;
        }
        this.modeler.getDrawingView().scrollIntoView(pec, true);
        return this.modeler.getPluginComponent().isShowing() ? EVENT_CONSUMED : EVENT_IGNORED;
    }

    public JaspiraEventHandlerCode showexact(QualifierEvent je) {
        ProcessElementContainer pec = this.modeler.getDrawing().getFigureByQualifier(je.getQualifier());
        if (pec == null) {
            return EVENT_IGNORED;
        }
        this.modeler.getDrawingView().scrollIntoView(pec, false);
        return this.modeler.getPluginComponent().isShowing() ? EVENT_CONSUMED : EVENT_IGNORED;
    }

    public JaspiraEventHandlerCode select(QualifierEvent je) {
        ProcessElementContainer pec = this.modeler.getDrawing().getFigureByQualifier(je.getQualifier());
        if (pec == null) {
            return EVENT_IGNORED;
        }
        WorkspaceDrawingView view = this.modeler.getDrawingView();
        view.singleSelect(pec);
        return this.modeler.getPluginComponent().isShowing() ? EVENT_CONSUMED : EVENT_IGNORED;
    }

    public JaspiraEventHandlerCode getselectioncount(AskEvent ae) {
        if (this.modeler.getPluginComponent().isShowing()) {
            WorkspaceDrawingView workspaceView = this.modeler.getDrawingView();
            ae.setAnswer(new Integer(workspaceView.selectionCount()));
            return EVENT_CONSUMED;
        }
        return EVENT_IGNORED;
    }

    public JaspiraEventHandlerCode getselection(AskEvent ae) {
        if (this.modeler.getPluginComponent().isShowing()) {
            WorkspaceDrawingView workspaceView = this.modeler.getDrawingView();
            ae.setAnswer(workspaceView.selection());
            return EVENT_CONSUMED;
        }
        return EVENT_IGNORED;
    }

    public JaspiraEventHandlerCode getbyqualifier(AskEvent ae) {
        ProcessElementContainer pec;
        if (this.modeler.getPluginComponent().isShowing() && (pec = this.modeler.getDrawing().getFigureByQualifier((ModelQualifier)ae.getObject())) != null) {
            ae.setAnswer(pec);
            return EVENT_CONSUMED;
        }
        return EVENT_IGNORED;
    }

    public JaspiraEventHandlerCode importtoselection(JaspiraEvent je) {
        Vector selectedFigures;
        int n;
        boolean imported = false;
        Object regionId = null;
        Transferable transferable = (Transferable)je.getObject();
        WorkspaceDrawingView workspaceView = this.modeler.getDrawingView();
        if (workspaceView != null && (n = (selectedFigures = workspaceView.selection()).size()) > 0) {
            for (int i = 0; i < n; ++i) {
                InteractionClient interactionClient;
                Object o = selectedFigures.get(i);
                if (!(o instanceof InteractionClient) || !(interactionClient = (InteractionClient)o).importData(regionId, transferable, null)) continue;
                imported = true;
            }
        }
        if (imported) {
            return EVENT_HANDLED;
        }
        return EVENT_IGNORED;
    }

    public JaspiraEventHandlerCode modeler_edit_selectall(JaspiraActionEvent jae) {
        if (jae.getSourcePlugin() == this.modeler) {
            WorkspaceDrawingView view = this.modeler.getDrawingView();
            view.clearSelection();
            Iterator it = this.modeler.getDrawing().getAllFigures();
            while (it.hasNext()) {
                Figure figure = (Figure)it.next();
                view.addToSelection(figure);
            }
            return EVENT_CONSUMED;
        }
        return EVENT_IGNORED;
    }

    public JaspiraEventHandlerCode modeler_edit_normalize(JaspiraActionEvent jae) {
        if (jae.getSourcePlugin() == this.modeler) {
            this.modeler.startUndoForAction(jae);
            this.modeler.getDrawing().normalize();
            this.modeler.endUndo();
            return EVENT_CONSUMED;
        }
        return EVENT_IGNORED;
    }

    public JaspiraEventHandlerCode snaptogrid(JaspiraActionEvent jae) {
        return EVENT_HANDLED;
    }

    public JaspiraEventHandlerCode modeler_edit_fliporientation(JaspiraActionEvent jae) {
        if (jae.getSourcePlugin() == this.modeler) {
            WorkspaceDrawingView workspaceView = this.modeler.getDrawingView();
            Vector selectedFigures = workspaceView.selection();
            int n = selectedFigures.size();
            if (n > 0) {
                boolean found = false;
                for (int i = 0; i < n; ++i) {
                    Object o = selectedFigures.get(i);
                    if (!(o instanceof ParamConnection)) continue;
                    if (!found) {
                        this.modeler.startUndoForAction(jae);
                        found = true;
                    }
                    ((ParamConnection)o).flipOrientation();
                }
                if (found) {
                    this.modeler.endUndo();
                }
            }
            return EVENT_CONSUMED;
        }
        return EVENT_IGNORED;
    }

    public JaspiraEventHandlerCode editor_shadow(JaspiraEvent je) {
        Object o = ((Option)je.getObject()).getValue();
        this.modeler.getDrawingView().setShadowLayouter((ShadowLayouter)o);
        return EVENT_HANDLED;
    }

    public JaspiraEventHandlerCode editor_grid_type(JaspiraEvent je) {
        Object o = ((Option)je.getObject()).getValue();
        this.modeler.getDrawingView().setGridType((Integer)o);
        return EVENT_HANDLED;
    }

    public JaspiraEventHandlerCode editor_grid_display(JaspiraEvent je) {
        Object o = ((Option)je.getObject()).getValue();
        this.modeler.getDrawingView().setGridDisplayed((Boolean)o);
        return EVENT_HANDLED;
    }

    public JaspiraEventHandlerCode editor_color_workspace(JaspiraEvent je) {
        Color color = (Color)((Option)je.getObject()).getValue();
        this.modeler.getDrawingView().setBackground(color);
        return EVENT_HANDLED;
    }

    public JaspiraEventHandlerCode editor_autoconnector_datalink(JaspiraEvent je) {
        AutoConnector.determineDataLinkAutoConnectorMode();
        return EVENT_HANDLED;
    }

    public JaspiraEventHandlerCode displayobject_changed_titlemode(JaspiraEvent event) {
        this.modeler.getDrawing().updateFigure();
        this.modeler.getDrawingView().redraw();
        return EVENT_HANDLED;
    }

    public JaspiraEventHandlerCode miniview_created(MiniViewEvent mve) {
        mve.addEditor(this.modeler);
        return EVENT_HANDLED;
    }

    public JaspiraEventHandlerCode plugin_propertybrowser_executesave(PropertyBrowserSaveEvent oee) {
        MultiSocketNode node;
        if (!(oee.original instanceof ProcessObject)) {
            return EVENT_IGNORED;
        }
        ProcessObject orig = (ProcessObject)oee.original;
        if (!this.modeler.getProcessQualifier().equals((Object)orig.getProcess().getQualifier())) {
            return EVENT_IGNORED;
        }
        this.modeler.startUndo("Edit Properties");
        try {
            orig.copyFrom(oee.getObject(), 0);
        }
        catch (CloneNotSupportedException e) {
            ExceptionUtil.printTrace((Throwable)e);
            return EVENT_CONSUMED;
        }
        orig.maintainReferences(0);
        if (orig instanceof MultiSocketNode && (node = (MultiSocketNode)orig).getConfigurationBean() != null && node.getConfigurationBean().hasDefaultValues()) {
            node.setConfigurationBean(null);
        }
        this.modeler.getDrawing().updateFigure();
        Object o = orig.getRepresentation();
        if (o instanceof Figure) {
            ((Figure)o).invalidate();
            this.modeler.getDrawingView().checkDamage();
        } else {
            this.modeler.getDrawingView().redraw();
        }
        if (orig instanceof ProcessVariable) {
            this.modeler.fireEvent("variables.refresh");
        }
        oee.saved = true;
        this.modeler.endUndo();
        return EVENT_CONSUMED;
    }

    public JaspiraEventHandlerCode modeler_drawing_figureadded(JaspiraEvent je) {
        if (je.getSourcePlugin() != this.modeler) {
            return EVENT_IGNORED;
        }
        Figure addedFigure = (Figure)je.getObject();
        if (addedFigure instanceof NodeFigure) {
            NodeFigure newNode = (NodeFigure)addedFigure;
            if (OptionMgr.getInstance().getBooleanOption("editor.paramvaluewizard", true)) {
                ParamValueWizard.displayParameterValueWizard(this.modeler, newNode, null, null);
            }
            AutoConnector autoConnector = new AutoConnector(this.modeler, newNode);
            autoConnector.autoConnectAll();
        }
        WorkspaceDrawingView workspaceView = this.modeler.getDrawingView();
        workspaceView.singleSelect(addedFigure);
        if (addedFigure instanceof NodeFigure && ((NodeFigure)addedFigure).isCreatedFromScratch()) {
            this.modeler.getToolSupport().displayInPlaceEditor((NodeFigure)addedFigure);
        } else {
            this.modeler.focusPlugin();
        }
        return this.modeler.getPluginComponent().isShowing() ? EVENT_CONSUMED : EVENT_IGNORED;
    }

    public JaspiraEventHandlerCode modeler_drawing_socketadded(JaspiraEvent je) {
        if (je.getSourcePlugin() != this.modeler) {
            return EVENT_IGNORED;
        }
        SocketFigure newSocket = (SocketFigure)je.getObject();
        AutoConnector autoConnector = new AutoConnector(this.modeler, newSocket);
        autoConnector.autoConnectAll();
        WorkspaceDrawingView workspaceView = this.modeler.getDrawingView();
        workspaceView.singleSelect(newSocket);
        this.modeler.getToolSupport().displayInPlaceEditor(newSocket);
        return this.modeler.getPluginComponent().isShowing() ? EVENT_CONSUMED : EVENT_IGNORED;
    }

    public JaspiraEventHandlerCode modeler_drawing_paramadded(JaspiraEvent je) {
        if (je.getSourcePlugin() != this.modeler) {
            return EVENT_IGNORED;
        }
        ParamFigure newParam = (ParamFigure)je.getObject();
        WorkspaceDrawingView workspaceView = this.modeler.getDrawingView();
        workspaceView.singleSelect(newParam);
        this.modeler.getToolSupport().displayInPlaceEditor(newParam);
        return this.modeler.getPluginComponent().isShowing() ? EVENT_CONSUMED : EVENT_IGNORED;
    }

    public JaspiraEventHandlerCode modeler_process_modified(JaspiraEvent je) {
        this.modeler.getDrawing().setModified();
        return this.modeler.getPluginComponent().isShowing() ? EVENT_CONSUMED : EVENT_IGNORED;
    }

    public JaspiraEventHandlerCode undo_history(JaspiraEvent je) {
        this.modeler.getUndoMgr().reloadHistorySize();
        return EVENT_CONSUMED;
    }
}

