/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.modeler.drawing;

import CH.ifa.draw.framework.Connector;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.standard.CompositeFigure;
import CH.ifa.draw.standard.StandardDrawing;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JScrollPane;
import org.openbp.cockpit.itemeditor.ItemCreationUtil;
import org.openbp.cockpit.modeler.drawing.DrawingEditorPlugin;
import org.openbp.cockpit.modeler.drawing.WorkspaceDrawingView;
import org.openbp.cockpit.modeler.figures.VisualElement;
import org.openbp.cockpit.modeler.figures.VisualElementEvent;
import org.openbp.cockpit.modeler.figures.generic.GeometryException;
import org.openbp.cockpit.modeler.figures.generic.UpdatableFigure;
import org.openbp.cockpit.modeler.figures.process.FlowConnection;
import org.openbp.cockpit.modeler.figures.process.HLineFigure;
import org.openbp.cockpit.modeler.figures.process.LineFigure;
import org.openbp.cockpit.modeler.figures.process.NodeFigure;
import org.openbp.cockpit.modeler.figures.process.ParamConnection;
import org.openbp.cockpit.modeler.figures.process.ParamFigure;
import org.openbp.cockpit.modeler.figures.process.ProcessElementContainer;
import org.openbp.cockpit.modeler.figures.process.ProcessElementFigureRegistry;
import org.openbp.cockpit.modeler.figures.process.ProcessVariableConnection;
import org.openbp.cockpit.modeler.figures.process.SocketFigure;
import org.openbp.cockpit.modeler.figures.process.TextElementFigure;
import org.openbp.cockpit.modeler.figures.process.VLineFigure;
import org.openbp.cockpit.modeler.figures.spline.PolySplineConnection;
import org.openbp.cockpit.modeler.skins.Skin;
import org.openbp.cockpit.modeler.util.FigureUtil;
import org.openbp.cockpit.modeler.util.ModelerFlavors;
import org.openbp.common.CommonUtil;
import org.openbp.common.ExceptionUtil;
import org.openbp.common.MsgFormat;
import org.openbp.common.generic.Modifiable;
import org.openbp.core.model.Model;
import org.openbp.core.model.ModelQualifier;
import org.openbp.core.model.item.Item;
import org.openbp.core.model.item.process.ControlLink;
import org.openbp.core.model.item.process.DataLink;
import org.openbp.core.model.item.process.Node;
import org.openbp.core.model.item.process.NodeParam;
import org.openbp.core.model.item.process.NodeProvider;
import org.openbp.core.model.item.process.NodeSocket;
import org.openbp.core.model.item.process.Param;
import org.openbp.core.model.item.process.ProcessItem;
import org.openbp.core.model.item.process.ProcessObject;
import org.openbp.core.model.item.process.ProcessVariable;
import org.openbp.core.model.item.process.TextElement;
import org.openbp.guiclient.util.ClientFlavors;
import org.openbp.jaspira.action.ActionMgr;
import org.openbp.jaspira.action.JaspiraAction;
import org.openbp.jaspira.event.AskEvent;
import org.openbp.jaspira.gui.interaction.DropClientUtil;
import org.openbp.jaspira.gui.interaction.Importer;
import org.openbp.jaspira.gui.interaction.InteractionClient;
import org.openbp.jaspira.gui.interaction.ViewDropRegion;
import org.openbp.jaspira.plugins.propertybrowser.PropertyBrowserSetEvent;
import org.openbp.jaspira.util.StandardFlavors;
import org.openbp.swing.SwingUtil;
import org.openbp.swing.components.JMsgBox;

public class ProcessDrawing
extends StandardDrawing
implements ProcessElementContainer,
Modifiable {
    private ProcessItem process;
    private ModelQualifier processQualifier;
    private Skin processSkin;
    private int visualStatus;
    private boolean readOnly;
    private DrawingEditorPlugin editor;
    private Comparator zComparator = new ZComparator();
    private static Class[] figureClassOrder = new Class[]{PolySplineConnection.class, ProcessVariableConnection.class, NodeFigure.class, TextElementFigure.class, LineFigure.class};

    public ProcessDrawing(ProcessItem process, DrawingEditorPlugin editor) {
        this.editor = editor;
        this.setProcess(process);
    }

    public ProcessItem getProcess() {
        return this.process;
    }

    public void setProcess(ProcessItem process) {
        if (this.process != null) {
            this.process.maintainReferences(256);
        }
        this.processSkin = null;
        if (process != null) {
            try {
                this.process = process;
                process.setRepresentation((Object)this);
                this.processQualifier = process.getQualifier();
                this.processSkin = FigureUtil.determineProcessSkin(process);
                this.setTitle(process.getDisplayName());
                this.decodeGeometry();
            }
            catch (RuntimeException e) {
                String msg = e instanceof GeometryException ? ExceptionUtil.getNestedMessage((Throwable)e) : MsgFormat.format((String)"Error parsing geometry information of process $0: {1}", (Object)process.getQualifier().toString(), (Object)ExceptionUtil.getNestedMessage((Throwable)e));
                JMsgBox.show(null, (String)msg, (int)0x40040001);
                throw e;
            }
        }
    }

    public Skin getProcessSkin() {
        return this.processSkin;
    }

    public void setProcessSkin(Skin processSkin) {
        this.processSkin = processSkin;
    }

    public DrawingEditorPlugin getEditor() {
        return this.editor;
    }

    public void setEditor(DrawingEditorPlugin editor) {
        this.editor = editor;
    }

    public WorkspaceDrawingView getView() {
        return this.editor != null ? (WorkspaceDrawingView)this.editor.view() : null;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public Iterator getAllFigures() {
        return this.getFigureList().iterator();
    }

    protected List getFigureList() {
        ArrayList<Figure> li = new ArrayList<Figure>();
        FigureEnumeration fe = this.figures();
        while (fe.hasMoreElements()) {
            Figure f = fe.nextFigure();
            li.add(f);
        }
        return li;
    }

    public Iterator getNodeFigures() {
        return this.getNodeFigureList().iterator();
    }

    protected List getNodeFigureList() {
        ArrayList<Figure> li = new ArrayList<Figure>();
        FigureEnumeration fe = this.figures();
        while (fe.hasMoreElements()) {
            Figure f = fe.nextFigure();
            if (!(f instanceof NodeFigure)) continue;
            li.add(f);
        }
        return li;
    }

    public Iterator getParamConnections() {
        return this.getParamConnectionList().iterator();
    }

    protected List getParamConnectionList() {
        ArrayList<Figure> li = new ArrayList<Figure>();
        FigureEnumeration fe = this.figures();
        while (fe.hasMoreElements()) {
            Figure f = fe.nextFigure();
            if (!(f instanceof ParamConnection)) continue;
            li.add(f);
        }
        return li;
    }

    public Iterator getFlowConnections() {
        return this.getFlowConnectionList().iterator();
    }

    protected List getFlowConnectionList() {
        ArrayList<Figure> li = new ArrayList<Figure>();
        FigureEnumeration fe = this.figures();
        while (fe.hasMoreElements()) {
            Figure f = fe.nextFigure();
            if (!(f instanceof FlowConnection)) continue;
            li.add(f);
        }
        return li;
    }

    public Figure add(Figure figure) {
        if (figure == null) {
            return null;
        }
        Figure result = super.add(figure);
        if (result instanceof VisualElement) {
            ((VisualElement)result).setDrawing(this);
        }
        return result;
    }

    public void setTagState(int stateUpdate) {
        FigureEnumeration drawingFigures = this.figures();
        while (drawingFigures.hasMoreElements()) {
            Figure f = (Figure)drawingFigures.nextElement();
            if (!(f instanceof NodeFigure)) continue;
            FigureEnumeration nodeFigures = ((NodeFigure)f).figures();
            while (nodeFigures.hasMoreElements()) {
                Figure nodeChild = nodeFigures.nextFigure();
                if (!(nodeChild instanceof SocketFigure)) continue;
                SocketFigure socketFigure = (SocketFigure)nodeChild;
                int contentState = socketFigure.getContentState();
                contentState &= 0xFFFFFFF3;
                socketFigure.setContentState(contentState |= stateUpdate);
            }
        }
        this.layoutAllConnections();
    }

    public void layoutAllConnections() {
        FigureEnumeration drawingFigures = this.figures();
        while (drawingFigures.hasMoreElements()) {
            Figure f = drawingFigures.nextFigure();
            if (!(f instanceof PolySplineConnection)) continue;
            ((PolySplineConnection)f).layoutConnection();
        }
    }

    public Figure remove(Figure figure) {
        if (figure instanceof ProcessElementContainer) {
            VisualElement parent = ((ProcessElementContainer)figure).getParentElement();
            if (parent instanceof ProcessDrawing) {
                return super.remove(figure);
            }
            if (parent instanceof CompositeFigure) {
                ((CompositeFigure)parent).remove(figure);
                figure.release();
                return figure;
            }
        } else {
            this.orphan(figure);
        }
        return figure;
    }

    public void removeAndUpdate(Figure figure) {
        this.editor.fireEvent(new PropertyBrowserSetEvent(this.editor));
        this.editor.fireEvent("global.clipboard.updatestatus");
        this.setModified();
        this.remove(figure);
        this.editor.repairDamage();
    }

    public Figure findFigure(int x, int y) {
        FigureEnumeration figures = this.figures();
        while (figures.hasMoreElements()) {
            Figure figure = figures.nextFigure();
            if (!figure.containsPoint(x, y)) continue;
            return figure;
        }
        return null;
    }

    public ProcessElementContainer getFigureByQualifier(ModelQualifier qualifier) {
        if (!CommonUtil.equalsNull((Object)this.processQualifier.getModel(), (Object)qualifier.getModel())) {
            return null;
        }
        if (!CommonUtil.equalsNull((Object)this.processQualifier.getItem(), (Object)qualifier.getItem())) {
            return null;
        }
        if (qualifier.getItemType() != null && !CommonUtil.equalsNull((Object)this.processQualifier.getItemType(), (Object)qualifier.getItemType())) {
            return null;
        }
        ProcessObject po = this.process.getProcessElementByName(qualifier.getObjectPath());
        if (po == null) {
            return null;
        }
        if (po.getRepresentation() == null) {
            Throwable t = new Throwable("No representation for qualifier '" + qualifier + "'.");
            ExceptionUtil.printTrace((Throwable)t);
        }
        return (ProcessElementContainer)po.getRepresentation();
    }

    public void bringToFront(Figure f) {
        if (!(f instanceof PolySplineConnection) && !(f instanceof TextElementFigure)) {
            while (f instanceof ProcessElementContainer && !(f instanceof NodeFigure)) {
                f = ((ProcessElementContainer)f).getParentElement();
            }
        }
        if (f != null) {
            super.bringToFront(f);
        }
        this.recalculateZOrders();
    }

    protected void recalculateZOrders() {
        Collections.sort(this.fFigures, this.zComparator);
        int n = this.fFigures.size();
        for (int i = 0; i < n; ++i) {
            Figure f = (Figure)this.fFigures.elementAt(i);
            f.setZValue(i);
        }
        this._nLowestZ = 0;
        this._nHighestZ = n - 1;
    }

    private static int getFigureTypeZOrder(Figure f) {
        for (int i = 0; i < figureClassOrder.length; ++i) {
            if (!figureClassOrder[i].isInstance(f)) continue;
            return i + 1;
        }
        return 0;
    }

    public Rectangle displayBox() {
        int n = this.fFigures.size();
        if (n <= 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        Rectangle r = ((Figure)this.fFigures.elementAt(0)).displayBox();
        for (int i = 1; i < n; ++i) {
            Figure f = (Figure)this.fFigures.elementAt(i);
            if (f instanceof LineFigure) continue;
            r.add(f.displayBox());
        }
        r.y = 0;
        r.x = 0;
        return r;
    }

    public Point getActualOrigin() {
        return super.displayBox().getLocation();
    }

    public void normalize() {
        Point p = this.getActualOrigin();
        this.moveBy(-p.x + 50, -p.y + 50);
        this.setModified();
    }

    public void encodeGeometry() {
        String geometry = this.encodeProcessGeometry();
        this.process.setGeometry(geometry);
        FigureEnumeration en = this.figures();
        while (en.hasMoreElements()) {
            Figure f = (Figure)en.nextElement();
            if (f instanceof NodeFigure) {
                ((NodeFigure)f).encodeGeometry();
                continue;
            }
            if (f instanceof ParamConnection) {
                ((ParamConnection)f).encodeGeometry();
                continue;
            }
            if (f instanceof FlowConnection) {
                ((FlowConnection)f).encodeGeometry();
                continue;
            }
            if (!(f instanceof TextElementFigure)) continue;
            ((TextElementFigure)f).encodeGeometry();
        }
    }

    public void decodeGeometry() {
        ProcessElementContainer p;
        this.removeAll();
        this.decodeProcessGeometry(this.process.getGeometry());
        Iterator it = this.process.getNodes();
        while (it.hasNext()) {
            p = this.createNodeFigure((Node)it.next());
            if (p == null) continue;
            this.add(p);
        }
        it = this.process.getControlLinks();
        while (it.hasNext()) {
            p = this.createFlowConnection((ControlLink)it.next());
            if (p == null) continue;
            this.add(p);
        }
        it = this.process.getDataLinks();
        while (it.hasNext()) {
            p = this.createParamConnection((DataLink)it.next());
            if (p == null) continue;
            this.add(p);
        }
        it = this.process.getTextElements();
        while (it.hasNext()) {
            p = this.createTextElementFigure((TextElement)it.next());
            if (p == null) continue;
            this.add(p);
        }
        this.recalculateZOrders();
        this.layoutAllConnections();
    }

    protected String encodeProcessGeometry() {
        StringBuffer sb = new StringBuffer();
        FigureEnumeration en = this.figures();
        while (en.hasMoreElements()) {
            Figure f = (Figure)en.nextElement();
            if (!(f instanceof LineFigure)) continue;
            if (sb.length() > 0) {
                sb.append("|");
            }
            if (f instanceof VLineFigure) {
                sb.append("vline:");
            } else {
                sb.append("hline:");
            }
            sb.append(((LineFigure)f).encodeGeometry());
        }
        return sb.length() > 0 ? sb.toString() : null;
    }

    protected void decodeProcessGeometry(String geometry) {
        if (geometry == null) {
            return;
        }
        StringTokenizer tok = new StringTokenizer(geometry, "|");
        while (tok.hasMoreTokens()) {
            String t = tok.nextToken();
            int i = t.indexOf(":");
            if (i <= 0) continue;
            String ident = t.substring(0, i);
            LineFigure lineFigure = null;
            if (ident.equalsIgnoreCase("vline")) {
                lineFigure = new VLineFigure(this);
            } else if (ident.equalsIgnoreCase("hline")) {
                lineFigure = new HLineFigure(this);
            }
            if (lineFigure == null) continue;
            lineFigure.decodeGeometry(t.substring(i + 1));
            this.add(lineFigure);
        }
    }

    public NodeFigure createNodeFigure(Node node) {
        NodeFigure figure = (NodeFigure)ProcessElementFigureRegistry.getInstance().createProcessElementContainer((ProcessObject)node);
        figure.connect(node, this);
        return figure;
    }

    public TextElementFigure createTextElementFigure(TextElement textElement) {
        TextElementFigure figure = new TextElementFigure();
        figure.connect(textElement, this);
        return figure;
    }

    public FlowConnection createFlowConnection(ControlLink link) {
        NodeSocket source = link.getSourceSocket();
        NodeSocket target = link.getTargetSocket();
        if (source == null) {
            System.err.println("Missing source socket for control link '" + link.getQualifier() + "'");
            return null;
        }
        if (target == null) {
            System.err.println("Missing target socket for control link '" + link.getQualifier() + "'");
            return null;
        }
        SocketFigure sourceFigure = (SocketFigure)source.getRepresentation();
        if (sourceFigure == null) {
            System.err.println("Control link source socket '" + source.getQualifier() + "' has no figure representation.");
            return null;
        }
        SocketFigure targetFigure = (SocketFigure)target.getRepresentation();
        if (targetFigure == null) {
            System.err.println("Control link target socket '" + target.getQualifier() + "' has no figure representation.");
            return null;
        }
        Connector start = sourceFigure.connectorAt(0, 0);
        Connector end = targetFigure.connectorAt(0, 0);
        link.unlink();
        FlowConnection flow = new FlowConnection(link, this);
        flow.connectStart(start);
        flow.connectEnd(end);
        return flow;
    }

    public ParamConnection createParamConnection(DataLink link) {
        Param source = link.getSourceParam();
        Param target = link.getTargetParam();
        if (source == null) {
            System.err.println("Missing source parameter for data link '" + link.getQualifier() + "'");
            return null;
        }
        if (target == null) {
            System.err.println("Missing target parameter for data link '" + link.getQualifier() + "'");
            return null;
        }
        ParamFigure sourceFigure = null;
        ParamFigure targetFigure = null;
        if (source instanceof NodeParam && (sourceFigure = (ParamFigure)source.getRepresentation()) == null) {
            System.err.println("Data link source parameter '" + source.getQualifier() + "' has no figure representation.");
            return null;
        }
        if (target instanceof NodeParam && (targetFigure = (ParamFigure)target.getRepresentation()) == null) {
            System.err.println("Data link target parameter '" + target.getQualifier() + "' has no figure representation.");
            return null;
        }
        if (source instanceof ProcessVariable && targetFigure != null) {
            targetFigure.setProcessVariableConnection((ProcessVariable)source, link);
        } else if (target instanceof ProcessVariable && sourceFigure != null) {
            sourceFigure.setProcessVariableConnection((ProcessVariable)target, link);
        } else if (sourceFigure != null && targetFigure != null) {
            Connector start = sourceFigure.connectorAt(0, 0);
            Connector end = targetFigure.connectorAt(0, 0);
            link.unlink();
            return new ParamConnection(link, start, end, this);
        }
        return null;
    }

    @Override
    public ProcessObject getProcessElement() {
        return this.process;
    }

    @Override
    public ProcessObject getReferredProcessElement() {
        return this.getProcessElement();
    }

    @Override
    public Figure selectionOnDelete() {
        return null;
    }

    @Override
    public ProcessDrawing getDrawing() {
        return this;
    }

    @Override
    public void setDrawing(ProcessDrawing processDrawing) {
    }

    @Override
    public VisualElement getParentElement() {
        return null;
    }

    @Override
    public Figure getPresentationFigure() {
        return this;
    }

    @Override
    public void updatePresentationFigure() {
    }

    @Override
    public boolean isVisible() {
        return (this.visualStatus & 1) != 0;
    }

    @Override
    public void setVisible(boolean visible) {
        this.willChange();
        this.visualStatus = visible ? (this.visualStatus |= 1) : (this.visualStatus &= 0xFFFFFFFE);
        this.changed();
    }

    @Override
    public boolean handleEvent(VisualElementEvent event) {
        VisualElement child = (VisualElement)FigureUtil.findChildFigure(this, event.x, event.y, VisualElement.class);
        if (child != null) {
            return child.handleEvent(event);
        }
        return false;
    }

    public boolean isDisplayAll() {
        return (this.visualStatus & 4) != 0;
    }

    public void setDisplayAll(boolean visible) {
        this.willChange();
        this.visualStatus = visible ? (this.visualStatus |= 4) : (this.visualStatus &= 0xFFFFFFFB);
        this.changed();
    }

    @Override
    public void updateFigure() {
        this.willChange();
        FigureEnumeration fe = this.figures();
        while (fe.hasMoreElements()) {
            Figure f = fe.nextFigure();
            if (!(f instanceof UpdatableFigure)) continue;
            ((UpdatableFigure)f).updateFigure();
        }
        this.changed();
    }

    public String getName() {
        return this.process.getName();
    }

    public void setName(String string) {
        this.process.setName(string);
    }

    public String getDescription() {
        return this.process.getDescription();
    }

    public void setDescription(String string) {
        this.process.setDescription(string);
    }

    public String getDisplayName() {
        return this.process.getDisplayName();
    }

    public void setDisplayName(String string) {
        this.process.setDisplayName(string);
    }

    public String getDisplayText() {
        return this.process.getDisplayText();
    }

    public String getDescriptionText() {
        return this.process.getDescriptionText();
    }

    public boolean isModified() {
        return this.process.isModified();
    }

    public void setModified() {
        this.process.setModified();
        this.updateModificationState();
    }

    public void clearModified() {
        this.process.clearModified();
        this.updateModificationState();
    }

    public void updateModificationState() {
        JaspiraAction action = ActionMgr.getInstance().getAction("standard.file.save");
        if (action != null) {
            action.setEnabled(this.process.isModified());
        }
    }

    @Override
    public void dragActionTriggered(Object regionId, Point p) {
    }

    @Override
    public void dragEnded(Transferable transferable) {
        DropClientUtil.dragEnded(this, transferable);
    }

    @Override
    public void dragStarted(Transferable transferable) {
        DropClientUtil.dragStarted(this, transferable);
    }

    @Override
    public List getAllDropRegions(List flavors, Transferable data, MouseEvent mouseEvent) {
        return DropClientUtil.getAllDropRegions(this, flavors, data, mouseEvent);
    }

    @Override
    public List getDropRegions(List flavors, Transferable data, MouseEvent mouseEvent) {
        String regionId = null;
        if (flavors.contains(ClientFlavors.NODE_PROVIDER)) {
            regionId = "addNode";
        } else if (flavors.contains(ClientFlavors.TEXT_ELEMENT)) {
            regionId = "addTextElement";
        } else if (flavors.contains(ModelerFlavors.HLINE)) {
            regionId = "addHLine";
        } else if (flavors.contains(ModelerFlavors.VLINE)) {
            regionId = "addVLine";
        }
        if (regionId != null) {
            WorkspaceDrawingView view = this.getView();
            Rectangle viewSize = new Rectangle(view.getSize());
            return Collections.singletonList(new ViewDropRegion(regionId, this, viewSize, (Component)((Object)view)));
        }
        return null;
    }

    @Override
    public List getImportersAt(Point p) {
        WorkspaceDrawingView view = this.getDrawing().getView();
        JScrollPane pane = SwingUtil.getScrollPaneAncestor((Component)((Object)view));
        Rectangle localBounds = SwingUtil.convertBoundsToGlassCoords((Component)pane.getViewport());
        if (localBounds.contains(p)) {
            ArrayList<Importer> result = new ArrayList<Importer>();
            result.add(new Importer("addNode", this, new DataFlavor[]{ClientFlavors.NODE_PROVIDER}));
            result.add(new Importer("addTextElement", this, new DataFlavor[]{ClientFlavors.TEXT_ELEMENT}));
            result.add(new Importer("addHLine", this, new DataFlavor[]{ModelerFlavors.HLINE}));
            result.add(new Importer("addVLine", this, new DataFlavor[]{ModelerFlavors.VLINE}));
            return result;
        }
        return null;
    }

    @Override
    public List getAllImportersAt(Point p) {
        WorkspaceDrawingView view = this.getDrawing().getView();
        JScrollPane pane = SwingUtil.getScrollPaneAncestor((Component)((Object)view));
        Rectangle localBounds = SwingUtil.convertBoundsToGlassCoords((Component)pane.getViewport());
        if (localBounds.contains(p)) {
            Point docPoint = SwingUtil.convertFromGlassCoords((Point)p, (Component)((Object)view));
            ProcessElementContainer pec = (ProcessElementContainer)FigureUtil.findChildFigure(this, docPoint.x, docPoint.y, ProcessElementContainer.class);
            if (pec != null && !(pec instanceof PolySplineConnection)) {
                return pec.getAllImportersAt(p);
            }
            return this.getImportersAt(p);
        }
        return null;
    }

    @Override
    public List getSubClients() {
        return FigureUtil.getTypedFigureList(this, InteractionClient.class);
    }

    @Override
    public boolean importData(Object regionId, Transferable data, Point p) {
        p = SwingUtil.convertFromGlassCoords((Point)p, (Component)((Object)this.getDrawing().getView()));
        try {
            VisualElement addedFigure = null;
            if ("addNode".equals(regionId)) {
                NodeProvider np = (NodeProvider)data.getTransferData(StandardFlavors.OBJECT);
                NodeFigure nodeFigure = this.createNodeFigureFromNodeProvider(np);
                if (nodeFigure == null) {
                    return false;
                }
                this.editor.startUndo("Add Node");
                Node node = nodeFigure.getNode();
                this.process.addNode(node);
                node.maintainReferences(5);
                nodeFigure.displayBox(new Rectangle(p));
                this.add(nodeFigure);
                addedFigure = nodeFigure;
            } else if ("addTextElement".equals(regionId)) {
                this.editor.startUndo("Add Text Element");
                TextElement textElement = this.process.createTextElement();
                this.process.addTextElement(textElement);
                TextElementFigure textElementFigure = this.createTextElementFigure(textElement);
                Rectangle db = textElementFigure.displayBox();
                db.x = p.x - db.width / 2;
                db.y = p.y - db.height / 2;
                textElementFigure.displayBox(db);
                this.add(textElementFigure);
                addedFigure = textElementFigure;
            } else if ("addHLine".equals(regionId)) {
                this.editor.startUndo("Add Horizontal Swimlane Line");
                HLineFigure hLineFigure = new HLineFigure(this);
                Rectangle db = hLineFigure.displayBox();
                db.x = p.x;
                db.y = p.y;
                hLineFigure.displayBox(db);
                this.add(hLineFigure);
                addedFigure = hLineFigure;
            } else if ("addVLine".equals(regionId)) {
                this.editor.startUndo("Add Vertical Swimlane Line");
                VLineFigure vLineFigure = new VLineFigure(this);
                Rectangle db = vLineFigure.displayBox();
                db.x = p.x;
                db.y = p.y;
                vLineFigure.displayBox(db);
                this.add(vLineFigure);
                addedFigure = vLineFigure;
            }
            if (addedFigure != null) {
                this.editor.endUndo();
                this.editor.repairDamage();
                this.editor.fireEvent("modeler.drawing.figureadded", addedFigure);
                this.editor.repairDamage();
            }
        }
        catch (UnsupportedFlavorException e) {
            ExceptionUtil.printTrace((Throwable)e);
        }
        catch (IOException e) {
            ExceptionUtil.printTrace((Throwable)e);
        }
        return false;
    }

    private NodeFigure createNodeFigureFromNodeProvider(NodeProvider np) {
        int syncFlags = 120;
        boolean isSkeleton = true;
        if (np instanceof Item) {
            Item npItem = (Item)np;
            if (npItem.getRuntimeAttribute("_skeleton") != null) {
                Item newItem;
                Model model = this.process.getModel();
                String processType = null;
                if (npItem instanceof ProcessItem) {
                    processType = ((ProcessItem)npItem).getProcessType();
                }
                if ((newItem = ItemCreationUtil.createItem(model, null, null, npItem.getItemType(), processType)) == null) {
                    return null;
                }
                npItem = newItem;
            } else {
                isSkeleton = false;
                AskEvent ae = new AskEvent(this.editor, "global.edit.geteditedinstance", npItem);
                this.editor.fireEvent(ae);
                Item editedItem = (Item)ae.getAnswer();
                if (editedItem != null) {
                    npItem = editedItem;
                }
            }
            np = (NodeProvider)npItem;
            if (!npItem.getQualifier().equals((Object)this.processQualifier)) {
                syncFlags |= 0x80;
            }
        }
        Node node = np.toNode(this.process, syncFlags);
        node.setProcess(this.process);
        node.setName(this.process.createUniqueNodeName(node.getName()));
        NodeFigure nodeFigure = this.createNodeFigure(node);
        if (isSkeleton) {
            nodeFigure.setCreatedFromScratch(true);
        }
        return nodeFigure;
    }

    private static class ZComparator
    implements Comparator {
        private ZComparator() {
        }

        public int compare(Object o1, Object o2) {
            int fo2;
            Figure f1 = (Figure)o1;
            Figure f2 = (Figure)o2;
            int fo1 = ProcessDrawing.getFigureTypeZOrder(f1);
            if (fo1 == (fo2 = ProcessDrawing.getFigureTypeZOrder(f2))) {
                return f1.getZValue() - f2.getZValue();
            }
            return fo1 - fo2;
        }
    }
}

