/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.modeler.drawing;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingChangeEvent;
import CH.ifa.draw.framework.DrawingChangeListener;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.framework.Handle;
import CH.ifa.draw.framework.Painter;
import CH.ifa.draw.standard.CompositeFigure;
import CH.ifa.draw.standard.SimpleUpdateStrategy;
import CH.ifa.draw.standard.StandardDrawingView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.PrintGraphics;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import org.openbp.cockpit.itemeditor.NodeItemEditorPlugin;
import org.openbp.cockpit.modeler.ModelerColors;
import org.openbp.cockpit.modeler.drawing.DrawingEditorPlugin;
import org.openbp.cockpit.modeler.drawing.ProcessDrawing;
import org.openbp.cockpit.modeler.drawing.SelectionDecorator;
import org.openbp.cockpit.modeler.drawing.Trackable;
import org.openbp.cockpit.modeler.drawing.shadowlayout.ParallelProjectionShadowLayouter;
import org.openbp.cockpit.modeler.drawing.shadowlayout.ShadowLayouter;
import org.openbp.cockpit.modeler.figures.VisualElement;
import org.openbp.cockpit.modeler.figures.VisualElementEvent;
import org.openbp.cockpit.modeler.figures.generic.ChildFigure;
import org.openbp.cockpit.modeler.figures.generic.Colorizable;
import org.openbp.cockpit.modeler.figures.process.LineFigure;
import org.openbp.cockpit.modeler.figures.process.ProcessElementContainer;
import org.openbp.cockpit.modeler.skins.Skin;
import org.openbp.cockpit.modeler.tools.ModelerToolSupport;
import org.openbp.cockpit.modeler.util.FigureUtil;
import org.openbp.cockpit.modeler.util.InputState;
import org.openbp.cockpit.modeler.util.ShadowEnumerator;
import org.openbp.common.CommonUtil;
import org.openbp.common.string.TextUtil;
import org.openbp.core.model.item.Item;
import org.openbp.core.model.item.process.MultiSocketNode;
import org.openbp.core.model.item.process.ProcessItem;
import org.openbp.core.model.item.process.ProcessObject;
import org.openbp.core.model.item.process.SubprocessNode;
import org.openbp.guiclient.model.ModelConnector;
import org.openbp.jaspira.action.JaspiraActionEvent;
import org.openbp.jaspira.action.JaspiraPopupMenu;
import org.openbp.jaspira.event.InteractionEvent;
import org.openbp.jaspira.event.JaspiraEvent;
import org.openbp.jaspira.gui.interaction.BasicTransferable;
import org.openbp.jaspira.gui.interaction.BreakoutEvent;
import org.openbp.jaspira.gui.interaction.BreakoutProvider;
import org.openbp.jaspira.gui.interaction.DragDropPane;
import org.openbp.jaspira.gui.interaction.MultiTransferable;
import org.openbp.jaspira.option.Option;
import org.openbp.jaspira.option.OptionMgr;
import org.openbp.jaspira.plugin.Plugin;
import org.openbp.jaspira.plugins.propertybrowser.PropertyBrowserSetEvent;
import org.openbp.swing.Scalable;
import org.openbp.swing.SwingUtil;

public class WorkspaceDrawingView
extends StandardDrawingView
implements DrawingChangeListener,
Scalable {
    public static final int GRIDTYPE_POINT = 1;
    public static final int GRIDTYPE_LINE = 2;
    public static final int GRIDTYPE_HEX = 3;
    private static final int MINWIDTH = 640;
    private static final int MINHEIGHT = 480;
    private static final int SIZE_OFFSET = 300;
    private static final double MIN_SCALE_FACTOR = 0.25;
    private static final double MAX_SCALE_FACTOR = 2.0;
    private double scaleFactor = 1.0;
    private int sizeOffset = 300;
    private boolean gridDisplayed;
    private int gridType = 2;
    private int gridSpacing = 100;
    private ShadowLayouter shadowLayouter = new ParallelProjectionShadowLayouter(5, 5);
    private SelectionDecorator selectionDecorator;
    private List selection;
    private Vector activeHandles;
    private Figure figureUnderCursor;
    protected boolean mouseInView;
    private Cursor cursor;

    public WorkspaceDrawingView(DrawingEditorPlugin editor) {
        super((DrawingEditor)editor, 640, 480);
        this.setLayout(null);
        Color workspaceColor = ModelerColors.WORKSPACE;
        Option o = OptionMgr.getInstance().getOption("editor.color.workspace");
        if (o != null) {
            workspaceColor = (Color)o.getValue();
        }
        this.setBackground(workspaceColor);
        this.setDisplayUpdate((Painter)new SimpleUpdateStrategy());
        ToolTipManager.sharedInstance().registerComponent((JComponent)((Object)this));
        this.selectionDecorator = new SelectionDecorator(this, editor);
        this.selection = new LinkedList();
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                WorkspaceDrawingView.this.mouseInView = true;
            }

            @Override
            public void mouseExited(MouseEvent e) {
                WorkspaceDrawingView.this.mouseInView = false;
            }
        });
        this.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                int notches = e.getWheelRotation();
                if (InputState.isCtrlDown()) {
                    WorkspaceDrawingView.this.invalidate();
                    double scaleFactor = WorkspaceDrawingView.this.getScaleFactor();
                    WorkspaceDrawingView.this.setScaleFactor(scaleFactor *= (100.0 + (double)(notches * 2)) / 100.0);
                    WorkspaceDrawingView.this.redraw();
                } else {
                    int mult = e.getScrollType() == 0 ? 25 : 100;
                    ((Trackable)WorkspaceDrawingView.this.editor()).moveTrackerBy(0, notches * mult);
                }
            }
        });
        this.addCursorKeySupport();
        this.addBreakoutSupport("breakout", 32);
        this.addBreakoutSupport("userbreakout", 49);
        this.gridType = OptionMgr.getInstance().getIntegerOption("editor.grid.type", this.gridType);
        this.gridDisplayed = OptionMgr.getInstance().getBooleanOption("editor.grid.display", this.gridDisplayed);
        o = OptionMgr.getInstance().getOption("editor.shadow");
        if (o != null) {
            this.shadowLayouter = (ShadowLayouter)o.getValue();
        }
    }

    public void unregister() {
        ToolTipManager.sharedInstance().unregisterComponent((JComponent)((Object)this));
        this.selectionDecorator.uninstall();
        if (this.drawing() != null) {
            this.drawing().removeDrawingChangeListener((DrawingChangeListener)this);
        }
        this.setEditor(null);
        this.selectionDecorator = null;
        this.activeHandles = null;
        this.selection = null;
    }

    public void setDrawing(Drawing drawing) {
        if (this.drawing() != null) {
            this.drawing().removeDrawingChangeListener((DrawingChangeListener)this);
        }
        super.setDrawing(drawing);
        if (this.drawing() != null) {
            drawing.addDrawingChangeListener((DrawingChangeListener)this);
        }
    }

    public Dimension getPreferredSize() {
        if (this.drawing() == null) {
            return new Dimension();
        }
        Rectangle r = ((Figure)this.drawing()).displayBox();
        r = this.applyScale(r, false);
        int offset = this.applyScale(this.sizeOffset, false);
        Dimension d = new Dimension(r.width + offset, r.height + offset);
        return d;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void setPreferredSize(Dimension d) {
        if (d.width < 640) {
            d.width = 640;
        }
        if (d.height < 480) {
            d.height = 480;
        }
        super.setPreferredSize(d);
    }

    public void setCursor(Cursor cursor) {
        if (this.cursor != cursor) {
            this.cursor = cursor;
            super.setCursor(cursor);
        }
    }

    public String getToolTipText(MouseEvent e) {
        if (e != null) {
            Point p = e.getPoint();
            p = this.applyScale(p, true);
            ProcessElementContainer pec = (ProcessElementContainer)FigureUtil.findInnermostFigure((ProcessDrawing)this.drawing(), p.x, p.y, ProcessElementContainer.class);
            if (pec != null && pec != this.drawing()) {
                return TextUtil.convertToHTML((String[])pec.getReferredProcessElement().getInfoText(), (boolean)true, (int)1, (int)50);
            }
        }
        return null;
    }

    public void redraw() {
        if (this.drawing() != null) {
            this.repaint();
        }
    }

    public void drawBackground(Graphics g) {
        block11: {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getBounds().width, this.getBounds().height);
            boolean isPrinting = g instanceof PrintGraphics;
            if (isPrinting) break block11;
            g.setColor(ModelerColors.GRID);
            int height = this.getHeight();
            int width = this.getWidth();
            int max = Math.max(height, width);
            if (this.gridDisplayed) {
                int spacing = this.applyScale(this.gridSpacing, false);
                if (this.gridType == 1) {
                    for (int x = spacing; x < max; x += spacing) {
                        for (int y = spacing; y < max; y += spacing) {
                            g.fillArc(x - 1, y - 1, x % (5 * spacing) == 0 && y % (5 * spacing) == 0 ? 4 : 2, x % (5 * spacing) == 0 && y % (5 * spacing) == 0 ? 4 : 2, 0, 360);
                        }
                    }
                } else if (this.gridType == 2) {
                    for (int i = spacing; i < max; i += spacing) {
                        g.drawLine(i, 0, i, height);
                        g.drawLine(0, i, width, i);
                    }
                } else if (this.gridType == 3) {
                    Graphics2D g2 = (Graphics2D)g;
                    int even = spacing / 2;
                    for (double y = 0.0; y < (double)(max + spacing); y += (double)spacing * 5.0 / 6.0) {
                        for (int x = even; x < max + spacing; x += spacing) {
                            g2.drawLine(x, (int)y, x, (int)y + spacing / 2);
                            g2.drawLine(x, (int)y + spacing / 2, x - spacing / 2, (int)(y + (double)spacing * 5.0 / 6.0));
                            g2.drawLine(x, (int)y + spacing / 2, x + spacing / 2, (int)(y + (double)spacing * 5.0 / 6.0));
                            g2.fillArc(x - 1, (int)y - 1, 2, 2, 0, 360);
                        }
                        even = Math.abs(even - spacing / 2);
                    }
                }
            }
        }
    }

    public void drawShadow(Graphics g) {
        Skin skin = ((ProcessDrawing)this.drawing()).getProcessSkin();
        if (this.shadowLayouter != null && !skin.isDisableShadows()) {
            this.shadowLayouter.drawShadows(ShadowEnumerator.enumerate((Figure)((CompositeFigure)this.drawing())), g);
        }
    }

    public void drawAll(Graphics g) {
        if (!(g instanceof Graphics2D)) {
            return;
        }
        boolean isPrinting = g instanceof PrintGraphics;
        this.drawBackground(g);
        Graphics2D g2 = (Graphics2D)g;
        AffineTransform oldTransform = g2.getTransform();
        if ((oldTransform.getType() & 6) == 0) {
            this.prepareGraphics(g2);
        }
        this.drawShadow(g);
        this.drawDrawing(g);
        if (!isPrinting) {
            this.drawHandles(g);
        }
        g2.setTransform(oldTransform);
    }

    public void draw(Graphics g, FigureEnumeration fe) {
        if (!(g instanceof Graphics2D)) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        AffineTransform oldTransform = g2.getTransform();
        if ((oldTransform.getType() & 6) == 0) {
            this.prepareGraphics(g2);
        }
        super.draw(g, fe);
        g2.setTransform(oldTransform);
    }

    public void prepareGraphics(Graphics2D g2) {
        g2.scale(this.scaleFactor, this.scaleFactor);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
    }

    public void drawHandles(Graphics g) {
        Enumeration k = this.selectionHandles();
        while (k.hasMoreElements()) {
            ((Handle)k.nextElement()).draw(g);
        }
    }

    public void scrollIntoView(Figure figure, boolean addEnlargement) {
        if (figure == null) {
            return;
        }
        Rectangle rect = new Rectangle(figure.displayBox());
        if (addEnlargement) {
            rect.grow(50, 50);
        }
        this.scrollRectToVisible(rect);
    }

    public void scrollRectToVisible(Rectangle rect) {
        Rectangle db = ((Figure)this.drawing()).displayBox();
        db.width += this.sizeOffset;
        db.height += this.sizeOffset;
        if ((rect = rect.intersection(db)).isEmpty()) {
            return;
        }
        rect = this.applyScale(rect, false);
        super.scrollRectToVisible(rect);
    }

    public void drawingRequestUpdate(DrawingChangeEvent e) {
        this.revalidate();
    }

    public void drawingInvalidated(DrawingChangeEvent e) {
        Rectangle r = e.getInvalidatedRectangle();
        if (this.shadowLayouter != null) {
            r.add(this.shadowLayouter.transformRectangle(r));
        }
        r = this.applyScale(r, false);
        super.drawingInvalidated(new DrawingChangeEvent(e.getDrawing(), r));
        this.revalidate();
    }

    public Rectangle applyScale(Rectangle r, boolean scaleToDoc) {
        Rectangle result = new Rectangle();
        result.x = this.applyScale(r.x, scaleToDoc);
        result.y = this.applyScale(r.y, scaleToDoc);
        result.width = this.applyScale(r.width, scaleToDoc);
        result.height = this.applyScale(r.height, scaleToDoc);
        return result;
    }

    public Point applyScale(Point p, boolean scaleToDoc) {
        Point result = new Point();
        result.x = this.applyScale(p.x, scaleToDoc);
        result.y = this.applyScale(p.y, scaleToDoc);
        return result;
    }

    public int applyScale(int coordinate, boolean scaleToDoc) {
        coordinate = scaleToDoc ? CommonUtil.rnd((double)((double)coordinate / this.scaleFactor)) : CommonUtil.rnd((double)((double)coordinate * this.scaleFactor));
        return coordinate;
    }

    public void setVisibleRect(Rectangle r) {
        JScrollPane pane = SwingUtil.getScrollPaneAncestor((Component)((Object)this));
        Rectangle vr = pane.getViewport().getBounds();
        double xFactor = (double)vr.width / (double)r.width;
        double yFactor = (double)vr.height / (double)r.height;
        double factor = Math.min(xFactor, yFactor);
        this.setScaleFactor(factor);
        this.redraw();
        this.revalidate();
        this.scrollRectToVisible(r);
    }

    public double getScaleFactor() {
        return this.scaleFactor;
    }

    public void setScaleFactor(double scaleFactor) {
        if (scaleFactor > 2.0) {
            scaleFactor = 2.0;
        } else if (scaleFactor < 0.25) {
            scaleFactor = 0.25;
        }
        this.scaleFactor = scaleFactor;
        ((DrawingEditorPlugin)this.editor()).fireEvent("modelerpage.view.showzoomfactor", new Double(scaleFactor));
    }

    public int selectionCount() {
        return this.selection.size();
    }

    public boolean isFigureSelected(Figure checkFigure) {
        return this.selection.contains(checkFigure);
    }

    public Vector selection() {
        return new Vector(this.selection);
    }

    public Vector selectionZOrdered() {
        return this.selection();
    }

    public void addToSelection(Figure figure) {
        while (figure != null && !(figure instanceof ProcessElementContainer) && !(figure instanceof LineFigure)) {
            if (!(figure instanceof ChildFigure)) {
                return;
            }
            figure = ((ChildFigure)figure).getParent();
        }
        if (figure == null) {
            return;
        }
        if (!this.isFigureSelected(figure)) {
            this.selection.add(figure);
            this.activeHandles = null;
            this.markSelectionFigureChanged(figure, true);
            this.fireSelectionChanged();
        }
        this.updateSelection();
        this.drawing().bringToFront(figure);
    }

    public void removeFromSelection(Figure figure) {
        if (this.isFigureSelected(figure)) {
            this.selection.remove(figure);
            this.activeHandles = null;
            figure.invalidate();
            this.fireSelectionChanged();
            this.markSelectionFigureChanged(figure, false);
            this.repairDamage();
            this.updateSelection();
        }
    }

    public void singleSelect(Figure figure) {
        this.clearSelection();
        if (figure != null) {
            this.addToSelection(figure);
            this.scrollIntoView(figure, true);
        }
    }

    public void clearSelection() {
        if (this.selection.isEmpty()) {
            return;
        }
        ArrayList oldSelection = new ArrayList(this.selection);
        this.selection.clear();
        this.activeHandles = null;
        Iterator it = oldSelection.iterator();
        while (it.hasNext()) {
            this.markSelectionFigureChanged((Figure)it.next(), false);
        }
        this.fireSelectionChanged();
        this.updateSelection();
        this.repairDamage();
    }

    private void markSelectionFigureChanged(Figure figure, boolean selected) {
        if (figure instanceof VisualElement) {
            String type = selected ? "Selected" : "Deselected";
            ((VisualElement)figure).handleEvent(new VisualElementEvent(type, (DrawingEditorPlugin)this.editor()));
        }
        while (figure != null) {
            if (figure instanceof VisualElement) {
                ((VisualElement)figure).handleEvent(new VisualElementEvent("UpdateState", (DrawingEditorPlugin)this.editor()));
            }
            figure.changed();
            if (!(figure instanceof ChildFigure)) break;
            figure = ((ChildFigure)figure).getParent();
        }
    }

    public void fireSelectionChanged() {
        super.fireSelectionChanged();
        ((DrawingEditorPlugin)this.editor()).fireEvent("modeler.view.selectionchanged");
    }

    public void updateSelection() {
        DrawingEditorPlugin modeler = (DrawingEditorPlugin)this.editor();
        int selSize = this.selection.size();
        if (selSize == 1) {
            Figure figure = (Figure)this.selection.get(0);
            if (figure instanceof ProcessElementContainer) {
                MultiSocketNode node;
                ProcessObject mo = ((ProcessElementContainer)figure).getReferredProcessElement();
                Item originalObject = null;
                ProcessItem referencedItem = null;
                if (mo instanceof SubprocessNode) {
                    referencedItem = ((SubprocessNode)mo).getSubprocess();
                }
                if (this.editor() instanceof NodeItemEditorPlugin) {
                    if (referencedItem != null) {
                        originalObject = ModelConnector.getInstance().getItemByQualifier(referencedItem.getQualifier(), false);
                        mo = referencedItem;
                    }
                } else if (mo instanceof MultiSocketNode && (node = (MultiSocketNode)mo).getConfigurationBean() == null && referencedItem != null) {
                    node.setConfigurationBean(referencedItem.createConfigurationBean());
                }
                mo.maintainReferences(5);
                String title = mo.getName();
                String modelObjectTypeName = mo.getModelObjectTypeName();
                if (modelObjectTypeName != null) {
                    title = title + " (" + modelObjectTypeName + ")";
                }
                modeler.fireEvent(new PropertyBrowserSetEvent(modeler, mo, originalObject, false, mo.getDescription(), title, null, false, true));
                modeler.fireEvent(new JaspiraEvent(modeler, "plugin.infopanel.setinfotext", mo));
            }
            if (figure instanceof Colorizable) {
                Colorizable colorizable = (Colorizable)figure;
                Color figureColor = colorizable.getFillColor();
                Color defaultColor = colorizable.getDefaultFillColor();
                if (figureColor != null && !figureColor.equals(defaultColor)) {
                    modeler.fireEvent("colorchooser.setcolor", figureColor);
                }
            }
        } else {
            modeler.fireEvent(new PropertyBrowserSetEvent(modeler));
            modeler.fireEvent(new JaspiraEvent(modeler, "plugin.infopanel.clearinfotext"));
        }
        modeler.fireEvent("global.clipboard.updatestatus");
    }

    private Enumeration selectionHandles() {
        if (this.activeHandles == null) {
            this.activeHandles = new Vector();
            FigureEnumeration k = this.selectionElements();
            while (k.hasMoreElements()) {
                Figure figure = k.nextFigure();
                Enumeration kk = figure.handles().elements();
                while (kk.hasMoreElements()) {
                    this.activeHandles.addElement(kk.nextElement());
                }
            }
        }
        return this.activeHandles.elements();
    }

    public Handle findHandle(int x, int y) {
        Enumeration k = this.selectionHandles();
        while (k.hasMoreElements()) {
            Handle handle = (Handle)k.nextElement();
            if (!handle.containsPoint(x, y)) continue;
            return handle;
        }
        return null;
    }

    public void keyPressed(KeyEvent e) {
        int code = e.getKeyCode();
        DrawingEditorPlugin modeler = (DrawingEditorPlugin)this.editor();
        if (code == 10 && !InputState.isCtrlDown() && !InputState.isAltDown()) {
            e.consume();
            if (this.selection.size() == 1) {
                Figure figure = (Figure)this.selection.get(0);
                this.displayPopupMenu(figure, null);
            }
            return;
        }
        if (code == 10 && InputState.isAltDown()) {
            Figure figure;
            if (this.selection.size() == 1 && (figure = (Figure)this.selection.get(0)) instanceof ProcessElementContainer && !(figure instanceof ProcessDrawing)) {
                modeler.getToolSupport().displayInPlaceEditor((ProcessElementContainer)figure);
            }
            return;
        }
        if (code == 127) {
            e.consume();
            modeler.fireEvent(new JaspiraActionEvent((Plugin)modeler, "global.clipboard.delete", 0));
            return;
        }
        this.tool().keyDown(e, code);
    }

    public void keyReleased(KeyEvent e) {
        ((ModelerToolSupport)this.tool()).keyUp(e, e.getKeyCode());
    }

    public void displayPopupMenu(Figure figure, MouseEvent me) {
        Transferable[] transferables = null;
        if (figure != null && figure != this.drawing()) {
            if (figure instanceof ProcessElementContainer) {
                ProcessObject pe = ((ProcessElementContainer)figure).getReferredProcessElement();
                transferables = new Transferable[]{new BasicTransferable(pe), new BasicTransferable(figure)};
            } else {
                transferables = new Transferable[]{new BasicTransferable(figure)};
            }
        }
        if (transferables != null) {
            DrawingEditorPlugin modeler = (DrawingEditorPlugin)this.editor();
            InteractionEvent iae = new InteractionEvent((Plugin)modeler, "popup", new MultiTransferable(transferables));
            modeler.fireEvent(iae);
            JaspiraPopupMenu menu = iae.createPopupMenu();
            if (menu != null) {
                Point location = null;
                if (me != null) {
                    location = new Point(me.getX(), me.getY());
                } else if (figure != null) {
                    location = figure.center();
                    location = this.applyScale(location, false);
                }
                this.adjustOffsets(this.getParent(), location);
                menu.setLocation(location);
                menu.setInvoker((Component)((Object)this));
                menu.setVisible(true);
                if (me != null && figure != null) {
                    figure.invalidate();
                }
            }
        }
    }

    private void adjustOffsets(Component comp, Point offsetPoint) {
        if (comp == null) {
            return;
        }
        if (comp instanceof JViewport) {
            Point pos = ((JViewport)comp).getViewPosition();
            offsetPoint.translate(-pos.x, -pos.y);
        } else {
            Point compLocation = comp.getLocation();
            offsetPoint.translate(compLocation.x, compLocation.y);
        }
        this.adjustOffsets(comp.getParent(), offsetPoint);
    }

    protected void addBreakoutSupport(String actionName, int keyCode) {
        ActionMap am = this.getActionMap();
        am.put(actionName, new BreakOutOnAction(keyCode));
        InputMap in = this.getInputMap(0);
        in.put(KeyStroke.getKeyStroke(keyCode, 0, false), actionName);
    }

    private void addCursorKeySupport() {
        this.addCursorKeySupport(37, 2, -1, 0);
        this.addCursorKeySupport(39, 2, 1, 0);
        this.addCursorKeySupport(38, 2, 0, -1);
        this.addCursorKeySupport(40, 2, 0, 1);
        this.addCursorKeySupport(37, 0, -10, 0);
        this.addCursorKeySupport(39, 0, 10, 0);
        this.addCursorKeySupport(38, 0, 0, -10);
        this.addCursorKeySupport(40, 0, 0, 10);
    }

    private void addCursorKeySupport(int keyCode, int modifiers, int xOffset, int yOffset) {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(keyCode, modifiers, false);
        String actionName = keyStroke.toString() + "_Action";
        ActionMap am = this.getActionMap();
        am.put(actionName, new CursorAction(xOffset, yOffset));
        InputMap in = this.getInputMap(0);
        in.put(KeyStroke.getKeyStroke(keyCode, modifiers, false), actionName);
    }

    public ShadowLayouter getShadowLayouter() {
        return this.shadowLayouter;
    }

    public void setShadowLayouter(ShadowLayouter shadowLayouter) {
        if (this.shadowLayouter != null) {
            this.shadowLayouter.releaseShadowLayouter();
        }
        this.shadowLayouter = shadowLayouter;
        this.redraw();
    }

    public Figure getFigureUnderCursor() {
        return this.figureUnderCursor;
    }

    public void setFigureUnderCursor(Figure figureUnderCursor) {
        this.figureUnderCursor = figureUnderCursor;
    }

    public boolean isGridDisplayed() {
        return this.gridDisplayed;
    }

    public void setGridDisplayed(boolean gridDisplayed) {
        boolean oldGridDisplayed = this.gridDisplayed;
        this.gridDisplayed = gridDisplayed;
        if (oldGridDisplayed != this.gridDisplayed) {
            this.redraw();
        }
    }

    public int getGridType() {
        return this.gridType;
    }

    public void setGridType(int gridType) {
        int oldGridType = this.gridType;
        this.gridType = gridType;
        if (this.gridDisplayed && oldGridType != this.gridType) {
            this.redraw();
        }
    }

    public int getGridSpacing() {
        return this.gridSpacing;
    }

    public void setGridSpacing(int gridSpacing) {
        int oldGridSpacing = this.gridSpacing;
        this.gridSpacing = gridSpacing;
        if (this.gridDisplayed && oldGridSpacing != this.gridSpacing) {
            this.redraw();
        }
    }

    public void setSizeOffset(int sizeOffset) {
        this.sizeOffset = sizeOffset;
    }

    private class CursorAction
    extends AbstractAction {
        int xOffset;
        int yOffset;

        public CursorAction(int xOffset, int yOffset) {
            this.xOffset = xOffset;
            this.yOffset = yOffset;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DrawingEditorPlugin modeler = (DrawingEditorPlugin)WorkspaceDrawingView.this.editor();
            if (WorkspaceDrawingView.this.selectionCount() > 0) {
                modeler.startUndo("Move element");
                boolean first = true;
                for (Figure f : WorkspaceDrawingView.this.selection) {
                    f.moveBy(this.xOffset, this.yOffset);
                    if (!first) continue;
                    WorkspaceDrawingView.this.scrollIntoView(f, true);
                    first = false;
                }
                modeler.endUndo();
                WorkspaceDrawingView.this.checkDamage();
            } else {
                ((Trackable)((Object)modeler)).moveTrackerBy(this.xOffset * 20, this.yOffset * 20);
            }
        }
    }

    private class BreakOutOnAction
    extends AbstractAction {
        int keyCode;

        public BreakOutOnAction(int keyCode) {
            this.keyCode = keyCode;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean breakoutModeActive = SwingUtil.getGlassPane((Component)((Object)WorkspaceDrawingView.this)).isVisible();
            if (WorkspaceDrawingView.this.mouseInView || breakoutModeActive) {
                if (!breakoutModeActive) {
                    Component glassPane;
                    BreakoutEvent event = new BreakoutEvent((Plugin)((DrawingEditorPlugin)WorkspaceDrawingView.this.editor()), this.keyCode);
                    ((DrawingEditorPlugin)WorkspaceDrawingView.this.editor()).fireEvent(event);
                    BreakoutProvider bop = event.getProvider();
                    if (bop != null && (glassPane = SwingUtil.getGlassPane((Component)((Object)WorkspaceDrawingView.this))) instanceof DragDropPane) {
                        Point lastPoint = ((ModelerToolSupport)WorkspaceDrawingView.this.tool()).getLastPoint();
                        if (lastPoint.x == 0 && lastPoint.y == 0) {
                            JScrollPane scrollPane = SwingUtil.getScrollPaneAncestor((Component)((Object)WorkspaceDrawingView.this));
                            Rectangle viewRect = SwingUtil.convertBoundsToGlassCoords((Component)scrollPane.getViewport());
                            lastPoint.x = viewRect.x + viewRect.width / 2;
                            lastPoint.y = viewRect.y + viewRect.height / 2;
                        }
                        Point bobPosition = SwingUtilities.convertPoint((Component)((Object)WorkspaceDrawingView.this), lastPoint, SwingUtil.getGlassPane((Component)((Object)WorkspaceDrawingView.this)));
                        ((DragDropPane)glassPane).startBreakOutMode(bop, bobPosition);
                    }
                } else {
                    Component glassPane = SwingUtil.getGlassPane((Component)((Object)WorkspaceDrawingView.this));
                    if (glassPane instanceof DragDropPane) {
                        ((DragDropPane)glassPane).endBreakOutMode();
                    }
                }
            }
        }
    }
}

