/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.modeler.drawing.shadowlayout;

import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import org.openbp.cockpit.modeler.drawing.shadowlayout.ShadowLayouter;

public class ParallelProjectionShadowLayouter
implements ShadowLayouter {
    private double dx;
    private double dy;

    public ParallelProjectionShadowLayouter(int dx, int dy) {
        this.dx = dx;
        this.dy = dy;
    }

    @Override
    public void drawShadows(FigureEnumeration en, Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        AffineTransform trans = g2.getTransform();
        g2.translate(this.dx, this.dy);
        while (en.hasMoreElements()) {
            Figure next = en.nextFigure();
            next.draw(g);
        }
        g2.setTransform(trans);
    }

    @Override
    public Rectangle transformRectangle(Rectangle r) {
        Rectangle rec = new Rectangle(r);
        rec.translate((int)this.dx, (int)this.dy);
        return rec;
    }

    @Override
    public void releaseShadowLayouter() {
    }
}

