/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.modeler.drawing.shadowlayout;

import CH.ifa.draw.framework.DrawingChangeEvent;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import javax.swing.Timer;
import org.openbp.cockpit.modeler.drawing.shadowlayout.ShadowLayouter;

public class RealLightSourceShadowLayouter
implements ActionListener,
ShadowLayouter {
    private double lightX;
    private double lightY;
    private double factor;
    private DrawingView view;
    private AffineTransform to = new AffineTransform();
    private Timer motor;
    private long time;

    public RealLightSourceShadowLayouter(DrawingView view, double factor) {
        this.view = view;
        this.factor = factor;
        this.actionPerformed(null);
        this.motor = new Timer(100, this);
        this.motor.start();
    }

    @Override
    public void drawShadows(FigureEnumeration en, Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        AffineTransform trans = g2.getTransform();
        g2.transform(this.to);
        while (en.hasMoreElements()) {
            Figure next = en.nextFigure();
            next.draw(g);
        }
        g2.setTransform(trans);
    }

    @Override
    public Rectangle transformRectangle(Rectangle r) {
        Point2D c1 = new Point2D.Double(r.getMinX(), r.getMinY());
        Point2D.Double c2 = new Point2D.Double(r.getMaxX(), r.getMaxY());
        c1 = this.to.transform(c1, null);
        Point p = new Point((int)c1.getX(), (int)c1.getY());
        Rectangle rec = new Rectangle(p);
        rec.add(this.to.transform(c2, null));
        return rec;
    }

    @Override
    public void actionPerformed(ActionEvent param1) {
        ++this.time;
        if (this.time > 1440L) {
            this.time -= 1440L;
        }
        double angle = (double)this.time * 2.0 * Math.PI / 1440.0 - 1.5707963267948966;
        this.lightX = Math.cos(angle) * this.view.getSize().getHeight() + this.view.getSize().getWidth() / 2.0;
        this.lightY = Math.sin(angle) * this.view.getSize().getHeight();
        this.to.translate(this.lightX, this.lightY);
        this.to.scale(this.factor, this.factor);
        this.to.translate(-this.lightX, -this.lightY);
        this.view.drawingInvalidated(new DrawingChangeEvent(this.view.drawing(), new Rectangle(-10000, -10000, 20000, 20000)));
        this.view.repairDamage();
    }

    @Override
    public void releaseShadowLayouter() {
        this.motor.stop();
        this.motor = null;
    }
}

