/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.modeler.figures.generic;

import CH.ifa.draw.figures.ChopEllipseConnector;
import CH.ifa.draw.framework.Connector;
import CH.ifa.draw.framework.Figure;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.RectangularShape;
import org.openbp.cockpit.modeler.figures.generic.CircleConstants;
import org.openbp.cockpit.modeler.figures.generic.XFigureDescriptor;
import org.openbp.cockpit.modeler.figures.generic.XRectangleFigure;
import org.openbp.common.CommonUtil;

public class XEllipseFigure
extends XRectangleFigure {
    protected int frameCount = 1;
    private int frameDistance;
    private static final int SECTOR_E = 1;
    private static final int SECTOR_SE = 2;
    private static final int SECTOR_S = 3;
    private static final int SECTOR_SW = 4;
    private static final int SECTOR_W = 5;
    private static final int SECTOR_NW = 6;
    private static final int SECTOR_N = 7;
    private static final int SECTOR_NE = 8;

    public Rectangle ellipseBox() {
        return this.box;
    }

    @Override
    public void initialize() {
        super.initialize();
        XFigureDescriptor descriptor = this.getDescriptor();
        if (descriptor != null) {
            this.frameDistance = descriptor.getCustomIntAttributeValue("frame-distance", this.frameDistance);
            this.frameCount = descriptor.getCustomIntAttributeValue("frame-count", this.frameCount);
        }
    }

    public boolean containsPoint(int x, int y) {
        Shape shape = this.createShape();
        return shape.contains(x, y);
    }

    public Insets connectionInsets() {
        Rectangle r = this.ellipseBox();
        int cx = r.width / 2;
        int cy = r.height / 2;
        return new Insets(cy, cx, cy, cx);
    }

    public Connector connectorAt(int x, int y) {
        return new ChopEllipseConnector((Figure)this);
    }

    @Override
    public Rectangle placeAdjacent(Rectangle rect, double angle) {
        double xRectCenter = rect.getWidth() / 2.0;
        double yRectCenter = rect.getHeight() / 2.0;
        Rectangle r = this.ellipseBox();
        double boxCenter = r.getHeight() / 2.0;
        double alpha = Math.atan(yRectCenter / (boxCenter + xRectCenter));
        alpha = CircleConstants.normalizeAngle(alpha);
        double beta = Math.atan((yRectCenter + boxCenter) / xRectCenter);
        beta = CircleConstants.normalizeAngle(beta);
        double correction = Math.PI / (2.0 * (beta - alpha));
        int sector = angle < alpha || angle > Math.PI * 2 - alpha ? 1 : (angle < beta ? 2 : (angle < Math.PI - beta ? 3 : (angle < Math.PI - alpha ? 4 : (angle < Math.PI + alpha ? 5 : (angle < Math.PI + beta ? 6 : (angle < Math.PI * 2 - beta ? 7 : 8))))));
        double x = 0.0;
        double y = 0.0;
        double newAngle = angle;
        switch (sector) {
            case 1: {
                x = boxCenter + xRectCenter;
                y = Math.tan(newAngle) * (boxCenter + xRectCenter);
                break;
            }
            case 2: {
                newAngle = correction * (newAngle - alpha);
                x = boxCenter * Math.cos(newAngle) + xRectCenter;
                y = boxCenter * Math.sin(newAngle) + yRectCenter;
                break;
            }
            case 3: {
                x = (boxCenter + yRectCenter) / Math.tan(newAngle);
                y = boxCenter + yRectCenter;
                break;
            }
            case 4: {
                newAngle = correction * (newAngle - Math.PI + beta) + 1.5707963267948966;
                x = boxCenter * Math.cos(newAngle) - xRectCenter;
                y = boxCenter * Math.sin(newAngle) + yRectCenter;
                break;
            }
            case 5: {
                x = -(boxCenter + xRectCenter);
                y = -(Math.tan(newAngle) * (boxCenter + xRectCenter));
                break;
            }
            case 6: {
                newAngle = correction * (newAngle - Math.PI - alpha) + Math.PI;
                x = boxCenter * Math.cos(newAngle) - xRectCenter;
                y = boxCenter * Math.sin(newAngle) - yRectCenter;
                break;
            }
            case 7: {
                x = -((boxCenter + yRectCenter) / Math.tan(newAngle));
                y = -(boxCenter + yRectCenter);
                break;
            }
            case 8: {
                newAngle = correction * (newAngle - Math.PI * 2 + beta) + 4.71238898038469;
                x = boxCenter * Math.cos(newAngle) + xRectCenter;
                y = boxCenter * Math.sin(newAngle) - yRectCenter;
            }
        }
        Point c = this.center();
        int xPos = c.x + CommonUtil.rnd((double)(x - xRectCenter));
        int yPos = c.y + CommonUtil.rnd((double)(y - yRectCenter));
        rect.setLocation(xPos, yPos);
        return rect;
    }

    @Override
    public Shape createShape() {
        return this.createRectangularShape();
    }

    @Override
    public RectangularShape createRectangularShape() {
        Ellipse2D.Double shape = new Ellipse2D.Double();
        Rectangle r = this.ellipseBox();
        shape.setFrame(r);
        return shape;
    }

    @Override
    protected void drawFigure(Graphics g) {
        Rectangle r = this.ellipseBox();
        if (this.frameDistance > 0) {
            r = new Rectangle(r);
            r.grow(-this.frameDistance, -this.frameDistance);
        }
        g.fillOval(r.x, r.y, r.width, r.height);
    }

    @Override
    protected void drawFrame(Graphics g) {
        Rectangle r = this.ellipseBox();
        g.drawOval(r.x, r.y, r.width - 1, r.height - 1);
        if (this.frameCount > 1) {
            r = new Rectangle(r);
            for (int i = 1; i < this.frameCount; ++i) {
                r.grow(-this.frameDistance, -this.frameDistance);
                g.drawOval(r.x, r.y, r.width - 1, r.height - 1);
            }
        }
    }
}

