/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.modeler.figures.generic;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Point;
import java.awt.Stroke;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.ImageIcon;
import org.openbp.awt.Color2StringConverter;
import org.openbp.cockpit.modeler.figures.generic.Orientation;
import org.openbp.cockpit.modeler.figures.generic.XFigure;
import org.openbp.cockpit.modeler.util.FigureResources;
import org.openbp.common.CommonUtil;
import org.openbp.common.MsgFormat;
import org.openbp.common.ReflectUtil;
import org.openbp.common.generic.taggedvalue.TaggedValue;
import org.openbp.common.logger.LogUtil;
import org.openbp.common.string.Object2StringConverter;
import org.openbp.common.string.StringUtil;
import org.openbp.common.util.iterator.EmptyIterator;
import org.springframework.core.io.ClassPathResource;

public class XFigureDescriptor {
    public static final int GRADIENTPOS_CENTER = -1;
    public static final int GRADIENTPOS_E = 0;
    public static final int GRADIENTPOS_SE = 1;
    public static final int GRADIENTPOS_S = 2;
    public static final int GRADIENTPOS_SW = 3;
    public static final int GRADIENTPOS_W = 4;
    public static final int GRADIENTPOS_NW = 5;
    public static final int GRADIENTPOS_N = 6;
    public static final int GRADIENTPOS_NE = 7;
    public static final int DEFAULT_SIZE = 50;
    public static final int DEFAULT_FRAME_STROKE_WIDTH = 10;
    public static final Orientation DEFAULT_ORIENTATION = Orientation.BOTTOM;
    public static final int DEFAULT_GRADIENT_POS = -1;
    public static final int MIN_SIZE = 5;
    public static final int MAX_SIZE = 400;
    public static final int FLAG_CYCLIC_GRADIENT = 32;
    private static Object2StringConverter orientationConverter;
    private static Object2StringConverter gradientPosConverter;
    private static final Point point0;
    private String figureType;
    private String figureClassName;
    private Orientation orientation = DEFAULT_ORIENTATION;
    private int sizeX;
    private int sizeY;
    private int minSizeX;
    private int minSizeY;
    private int maxSizeX;
    private int maxSizeY;
    private int frameStrokeWidth = 10;
    private Color frameColor;
    private Color fillColor;
    private Color fillColor2;
    private int gradientPos1 = -1;
    private int gradientPos2 = -1;
    private boolean cyclicGradient;
    private String imageFileName;
    private List taggedValueList;
    private Stroke frameStroke;
    private transient ImageIcon imageIcon;

    public boolean validate(String descriptorResourcePath, List errorMsgs) {
        String resPath;
        boolean ret = true;
        if (this.figureType == null && this.figureClassName == null) {
            this.addErrorMsg(errorMsgs, "Figure type and figure class not specified.");
            ret = false;
        } else {
            String className = this.determineFigureClassName();
            try {
                Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                this.addErrorMsg(errorMsgs, MsgFormat.format((String)"Figure type class $0 not found.", (Object)className));
                ret = false;
            }
        }
        if (!orientationConverter.checkValue((Object)this.orientation)) {
            this.addErrorMsg(errorMsgs, MsgFormat.format((String)"Orientation value $0 is not valid.", (Object)("" + this.orientation)));
            ret = false;
        }
        if (!gradientPosConverter.checkIntValue(this.gradientPos1)) {
            this.addErrorMsg(errorMsgs, MsgFormat.format((String)"Gradient position 1 value $0 is not valid.", (Object)("" + this.gradientPos1)));
            ret = false;
        }
        if (!gradientPosConverter.checkIntValue(this.gradientPos2)) {
            this.addErrorMsg(errorMsgs, MsgFormat.format((String)"Gradient position 2 value $0 is not valid.", (Object)("" + this.gradientPos2)));
            ret = false;
        }
        if (this.sizeX != 0 && (this.sizeX < 5 || this.sizeX > 400)) {
            this.addErrorMsg(errorMsgs, MsgFormat.format((String)"X size not between {0} and {1}.", (Object)new Integer(5), (Object)new Integer(400)));
            ret = false;
        }
        if (this.sizeY != 0 && (this.sizeY < 5 || this.sizeY > 400)) {
            this.addErrorMsg(errorMsgs, MsgFormat.format((String)"Y size not between {0} and {1}.", (Object)new Integer(5), (Object)new Integer(400)));
            ret = false;
        }
        if (this.minSizeX <= 0) {
            this.minSizeX = this.sizeX;
        }
        if (this.minSizeY <= 0) {
            this.minSizeY = this.sizeY;
        }
        if (this.maxSizeX <= 0) {
            this.maxSizeX = this.sizeX * 3;
        }
        if (this.maxSizeY <= 0) {
            this.maxSizeY = this.sizeY * 3;
        }
        if (this.frameStrokeWidth < 5 || this.frameStrokeWidth > 50) {
            this.addErrorMsg(errorMsgs, MsgFormat.format((String)"Frame stroke width not between {0} and {1}.", (Object)new Integer(5), (Object)new Integer(50)));
            ret = false;
        }
        if (this.imageFileName != null && !new ClassPathResource(resPath = StringUtil.buildPath((String)descriptorResourcePath, (String)this.imageFileName)).exists()) {
            ret = false;
            this.addErrorMsg(errorMsgs, MsgFormat.format((String)"Figure resource $0 does not exist.", (Object)resPath));
        }
        return ret;
    }

    protected void addErrorMsg(List errorMsgs, String errorMsg) {
        errorMsgs.add(errorMsg);
    }

    public boolean initialize(String descriptorResourcePath) {
        if (this.imageFileName != null) {
            String resPath = StringUtil.buildPath((String)descriptorResourcePath, (String)this.imageFileName);
            try {
                this.imageIcon = new ImageIcon(new ClassPathResource(resPath).getURL(), null);
            }
            catch (IOException e) {
                LogUtil.error(this.getClass(), (String)"Figure resource $0 does not exist.", (Object)resPath);
            }
        }
        return true;
    }

    public XFigure createFigure() {
        try {
            String className = this.determineFigureClassName();
            XFigure figure = (XFigure)ReflectUtil.instantiate((String)className, XFigure.class, (String)"figure");
            figure.setDescriptor(this);
            if (this.imageIcon != null) {
                figure.setImageIcon(this.imageIcon);
            }
            int x = this.sizeX;
            int y = this.sizeY;
            if (x == 0) {
                int n = x = this.imageIcon != null ? this.imageIcon.getIconWidth() : 50;
            }
            if (y == 0) {
                y = this.imageIcon != null ? this.imageIcon.getIconHeight() : 50;
            }
            figure.basicDisplayBox(point0, new Point(x, y));
            figure.setOrientation(this.orientation);
            figure.setFrameStroke(this.getFrameStroke());
            figure.initialize();
            return figure;
        }
        catch (Exception e) {
            LogUtil.error(this.getClass(), (String)"Error instantiating figure.", (Object)e);
            return null;
        }
    }

    protected String determineFigureClassName() {
        if (this.figureClassName != null) {
            return this.figureClassName;
        }
        return "org.openbp.cockpit.modeler.figures.generic.X" + this.figureType + "Figure";
    }

    public Iterator getTaggedValues() {
        if (this.taggedValueList == null) {
            return EmptyIterator.getInstance();
        }
        return this.taggedValueList.iterator();
    }

    public TaggedValue getTaggedValue(int index) {
        return (TaggedValue)this.taggedValueList.get(index);
    }

    public void addTaggedValue(TaggedValue taggedValue) {
        if (this.taggedValueList == null) {
            this.taggedValueList = new ArrayList();
        }
        this.taggedValueList.add(taggedValue);
    }

    public void clearTaggedValues() {
        this.taggedValueList = null;
    }

    public List getTaggedValueList() {
        return this.taggedValueList;
    }

    public void setTaggedValueList(List taggedValueList) {
        this.taggedValueList = taggedValueList;
    }

    public String getTaggedValue(String name) {
        if (this.taggedValueList != null) {
            int n = this.taggedValueList.size();
            for (int i = 0; i < n; ++i) {
                TaggedValue sa = (TaggedValue)this.taggedValueList.get(i);
                if (!CommonUtil.equalsNull((Object)sa.getName(), (Object)name)) continue;
                return sa.getValue();
            }
        }
        return null;
    }

    public int getCustomIntAttributeValue(String name, int dflt) {
        String s = this.getTaggedValue(name);
        if (s != null) {
            try {
                return Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return dflt;
    }

    public String getFigureType() {
        return this.figureType;
    }

    public void setFigureType(String figureType) {
        this.figureType = figureType;
    }

    public String getFigureClassName() {
        return this.figureClassName;
    }

    public void setFigureClassName(String figureClassName) {
        this.figureClassName = figureClassName;
    }

    public boolean hasOrientation() {
        return this.orientation != DEFAULT_ORIENTATION;
    }

    public Orientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(Orientation orientation) {
        this.orientation = orientation;
    }

    public String getOrientationStr() {
        return orientationConverter.value2Str((Object)this.orientation);
    }

    public void setOrientationStr(String s) {
        this.orientation = (Orientation)orientationConverter.str2Value(s);
    }

    public boolean hasSizeX() {
        return this.sizeX != 0;
    }

    public int getSizeX() {
        return this.sizeX;
    }

    public void setSizeX(int sizeX) {
        this.sizeX = sizeX;
    }

    public boolean hasSizeY() {
        return this.sizeY != 0;
    }

    public int getSizeY() {
        return this.sizeY;
    }

    public void setSizeY(int sizeY) {
        this.sizeY = sizeY;
    }

    public int getMinSizeX() {
        return this.minSizeX;
    }

    public void setMinSizeX(int minSizeX) {
        this.minSizeX = minSizeX;
    }

    public int getMinSizeY() {
        return this.minSizeY;
    }

    public void setMinSizeY(int minSizeY) {
        this.minSizeY = minSizeY;
    }

    public int getMaxSizeX() {
        return this.maxSizeX;
    }

    public void setMaxSizeX(int maxSizeX) {
        this.maxSizeX = maxSizeX;
    }

    public int getMaxSizeY() {
        return this.maxSizeY;
    }

    public void setMaxSizeY(int maxSizeY) {
        this.maxSizeY = maxSizeY;
    }

    public boolean hasFrameStrokeWidth() {
        return this.frameStrokeWidth != 10;
    }

    public int getFrameStrokeWidth() {
        return this.frameStrokeWidth;
    }

    public void setFrameStrokeWidth(int frameStrokeWidth) {
        this.frameStrokeWidth = frameStrokeWidth;
    }

    public Color getFrameColor() {
        return this.frameColor;
    }

    public void setFrameColor(Color frameColor) {
        this.frameColor = frameColor;
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(Color fillColor) {
        this.fillColor = fillColor;
    }

    public Color getFillColor2() {
        return this.fillColor2;
    }

    public void setFillColor2(Color fillColor2) {
        this.fillColor2 = fillColor2;
    }

    public int getGradientPos1() {
        return this.gradientPos1;
    }

    public void setGradientPos1(int gradientPos1) {
        this.gradientPos1 = gradientPos1;
    }

    public int getGradientPos2() {
        return this.gradientPos2;
    }

    public void setGradientPos2(int gradientPos2) {
        this.gradientPos2 = gradientPos2;
    }

    public String getGradientPos1Str() {
        return gradientPosConverter.intValue2Str(this.gradientPos1);
    }

    public void setGradientPos1Str(String s) {
        this.gradientPos1 = gradientPosConverter.str2IntValue(s);
    }

    public String getGradientPos2Str() {
        return gradientPosConverter.intValue2Str(this.gradientPos2);
    }

    public void setGradientPos2Str(String s) {
        this.gradientPos2 = gradientPosConverter.str2IntValue(s);
    }

    public boolean isCyclicGradient() {
        return this.cyclicGradient;
    }

    public void setCyclicGradient(boolean cyclicGradient) {
        this.cyclicGradient = cyclicGradient;
    }

    public String getFrameColorStr() {
        return Color2StringConverter.color2Str((Color)this.frameColor);
    }

    public void setFrameColorStr(String s) {
        this.frameColor = Color2StringConverter.str2Color((String)s);
    }

    public String getFillColorStr() {
        return Color2StringConverter.color2Str((Color)this.fillColor);
    }

    public void setFillColorStr(String s) {
        this.fillColor = Color2StringConverter.str2Color((String)s);
    }

    public String getFillColor2Str() {
        return Color2StringConverter.color2Str((Color)this.fillColor2);
    }

    public void setFillColor2Str(String s) {
        this.fillColor2 = Color2StringConverter.str2Color((String)s);
    }

    public String getImageFileName() {
        return this.imageFileName;
    }

    public void setImageFileName(String imageFileName) {
        this.imageFileName = imageFileName;
    }

    public Stroke getFrameStroke() {
        if (this.frameStroke == null && this.frameStrokeWidth > 0) {
            this.frameStroke = this.frameStrokeWidth == 10 ? FigureResources.standardStroke1 : (this.frameStrokeWidth == 20 ? FigureResources.standardStroke2 : (this.frameStrokeWidth == 30 ? FigureResources.standardStroke3 : new BasicStroke((float)this.frameStrokeWidth / 10.0f)));
        }
        return this.frameStroke;
    }

    public ImageIcon getImageIcon() {
        return this.imageIcon;
    }

    static {
        point0 = new Point(0, 0);
        orientationConverter = new Object2StringConverter();
        orientationConverter.setDefaultValue((Object)DEFAULT_ORIENTATION);
        orientationConverter.addValue((Object)Orientation.TOP, "n", "Top");
        orientationConverter.addValue((Object)Orientation.RIGHT, "e", "Right");
        orientationConverter.addValue((Object)Orientation.BOTTOM, "s", "Bottom");
        orientationConverter.addValue((Object)Orientation.LEFT, "w", "Left");
        gradientPosConverter = new Object2StringConverter();
        gradientPosConverter.setDefaultValue((Object)new Integer(-1));
        gradientPosConverter.addIntValue(-1, "c", "Center");
        gradientPosConverter.addIntValue(6, "n", "Top");
        gradientPosConverter.addIntValue(7, "ne", "Top right");
        gradientPosConverter.addIntValue(0, "e", "Right");
        gradientPosConverter.addIntValue(1, "se", "Bottom right");
        gradientPosConverter.addIntValue(2, "s", "Bottom");
        gradientPosConverter.addIntValue(3, "sw", "Bottom left");
        gradientPosConverter.addIntValue(4, "w", "Left");
        gradientPosConverter.addIntValue(5, "nw", "Top left");
    }
}

