/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.modeler.figures.generic;

import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.Locator;
import CH.ifa.draw.standard.LocatorHandle;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import org.openbp.cockpit.modeler.ModelerColors;
import org.openbp.cockpit.modeler.figures.process.TextElementFigure;

public class XFontSizeHandle
extends LocatorHandle {
    private Font currentFont;

    public XFontSizeHandle(TextElementFigure owner, Locator locator) {
        super((Figure)owner, locator);
    }

    public void invokeStart(int x, int y, DrawingView view) {
        TextElementFigure textOwner = (TextElementFigure)this.owner();
        this.currentFont = textOwner.getFont();
    }

    public void invokeStep(int x, int y, int anchorX, int anchorY, DrawingView view) {
        int newSize;
        TextElementFigure textOwner = (TextElementFigure)this.owner();
        int xDiff = x - anchorX;
        int yDiff = y - anchorY;
        int dist = (int)Math.sqrt(xDiff * xDiff + yDiff * yDiff) / 10;
        if (xDiff + yDiff < 0) {
            dist = -dist;
        }
        if ((newSize = this.currentFont.getSize() + dist) < 8) {
            newSize = 8;
        }
        textOwner.setFont(new Font(this.currentFont.getName(), this.currentFont.getStyle(), newSize));
    }

    public void invokeEnd(int x, int y, int anchorX, int anchorY, DrawingView view) {
    }

    public void draw(Graphics g) {
        Rectangle r = this.displayBox();
        g.setColor(ModelerColors.HANDLE_TEXTSIZE_FILL);
        g.fillOval(r.x, r.y, r.width, r.height);
        g.setColor(ModelerColors.HANDLE_LINE);
        g.drawOval(r.x, r.y, r.width, r.height);
    }
}

