/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.modeler.figures.generic;

import CH.ifa.draw.framework.Connector;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import org.openbp.cockpit.modeler.figures.generic.XFigureDescriptor;
import org.openbp.cockpit.modeler.figures.generic.XRectangleFigure;

public class XRoundRectangleFigure
extends XRectangleFigure {
    private int arcWidth = 8;
    private int arcHeight = 8;
    private static final int DEFAULT_ARC = 8;

    @Override
    public void initialize() {
        super.initialize();
        XFigureDescriptor descriptor = this.getDescriptor();
        if (descriptor != null) {
            this.arcWidth = descriptor.getCustomIntAttributeValue("arc-width", this.arcWidth);
            this.arcHeight = descriptor.getCustomIntAttributeValue("arc-height", this.arcHeight);
        }
    }

    public Insets connectionInsets() {
        return new Insets(this.realArcHeight() / 2, this.realArcWidth() / 2, this.realArcHeight() / 2, this.realArcWidth() / 2);
    }

    public Connector connectorAt(int x, int y) {
        return null;
    }

    @Override
    protected void drawFigure(Graphics g) {
        g.fillRoundRect(this.box.x, this.box.y, this.box.width, this.box.height, this.realArcWidth(), this.realArcHeight());
    }

    @Override
    protected void drawFrame(Graphics g) {
        Rectangle r = this.box;
        g.drawRoundRect(r.x, r.y, r.width - 1, r.height - 1, this.realArcWidth(), this.realArcHeight());
        if (this.frameCount > 1) {
            r = new Rectangle(r);
            for (int i = 1; i < this.frameCount; ++i) {
                r.grow(-this.frameDistance, -this.frameDistance);
                g.drawRoundRect(r.x, r.y, r.width - 1, r.height - 1, this.realArcWidth(), this.realArcHeight());
            }
        }
    }

    @Override
    public Shape createShape() {
        return this.createRectangularShape();
    }

    @Override
    public RectangularShape createRectangularShape() {
        RoundRectangle2D.Double shape = new RoundRectangle2D.Double();
        Rectangle r = this.displayBox();
        ((RoundRectangle2D)shape).setRoundRect(r.getX(), r.getY(), r.getWidth(), r.getHeight(), this.realArcWidth(), this.realArcHeight());
        return shape;
    }

    public int getArcWidth() {
        return this.arcWidth;
    }

    public void setArcWidth(int arcWidth) {
        this.arcWidth = arcWidth;
    }

    public int getArcHeight() {
        return this.arcHeight;
    }

    public void setArcHeight(int arcHeight) {
        this.arcHeight = arcHeight;
    }

    public int realArcWidth() {
        if (this.arcWidth < 100) {
            return this.arcWidth;
        }
        int n = Math.min(this.box.width, this.box.height);
        return n;
    }

    public int realArcHeight() {
        if (this.arcHeight < 100) {
            return this.arcHeight;
        }
        int n = Math.min(this.box.width, this.box.height);
        return n;
    }
}

