/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.modeler.figures.layouter;

import java.awt.Insets;
import java.awt.Rectangle;
import org.openbp.cockpit.modeler.figures.generic.CircleConstants;
import org.openbp.cockpit.modeler.figures.layouter.TagLayouter;
import org.openbp.cockpit.modeler.figures.tag.AbstractTagFigure;

public abstract class AbstractTagLayouter
implements TagLayouter {
    protected Insets insets;
    protected int direction = 2;
    protected AbstractTagFigure tagFigure;

    public AbstractTagLayouter(AbstractTagFigure tagFigure) {
        this.tagFigure = tagFigure;
        this.insets = new Insets(3, 3, 3, 3);
        this.setupLayouter();
    }

    protected void setupLayouter() {
    }

    public abstract void applyDirection();

    @Override
    public abstract boolean isVerticalLayouter();

    @Override
    public Insets getInsets() {
        return this.insets;
    }

    @Override
    public void setInsets(Insets insets) {
        this.insets = insets;
    }

    @Override
    public void setDirection(int direction) {
        if (this.direction != direction) {
            this.direction = direction;
            this.applyDirection();
        }
    }

    @Override
    public void determineDirection() {
        double angle = this.tagFigure.getAngle();
        Rectangle centerBox = this.tagFigure.getCenterFigureBox();
        int dir = CircleConstants.determineEighth(angle, centerBox);
        this.setDirection(dir);
    }

    static String dirstr(int dir) {
        switch (dir) {
            case 0: {
                return "E ";
            }
            case 1: {
                return "SE";
            }
            case 2: {
                return "S ";
            }
            case 3: {
                return "SW";
            }
            case 4: {
                return "W ";
            }
            case 5: {
                return "NW";
            }
            case 6: {
                return "N ";
            }
            case 7: {
                return "NE";
            }
        }
        return "? ";
    }
}

