/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.modeler.figures.layouter;

import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import java.awt.Rectangle;
import org.openbp.cockpit.modeler.figures.generic.Expandable;
import org.openbp.cockpit.modeler.figures.generic.Orientation;
import org.openbp.cockpit.modeler.figures.layouter.AbstractTagLayouter;
import org.openbp.cockpit.modeler.figures.layouter.LayoutableTag;
import org.openbp.cockpit.modeler.figures.tag.AbstractTagFigure;
import org.openbp.common.CommonUtil;

public class HorizontalLayouter
extends AbstractTagLayouter {
    protected Orientation vAlign = Orientation.CENTER;
    protected Orientation hAlign = Orientation.CENTER;

    public HorizontalLayouter(AbstractTagFigure tagFigure) {
        super(tagFigure);
    }

    @Override
    public void applyDirection() {
        this.hAlign = this.direction < 2 || this.direction >= 6 ? Orientation.RIGHT : Orientation.LEFT;
        this.vAlign = Orientation.CENTER;
    }

    @Override
    public boolean isVerticalLayouter() {
        return false;
    }

    @Override
    public Rectangle calculateSize() {
        int height = 0;
        int width = 0;
        FigureEnumeration en = this.tagFigure.figures();
        while (en.hasMoreElements()) {
            Figure subFigure = en.nextFigure();
            Rectangle r = subFigure instanceof Expandable ? ((Expandable)subFigure).compactDisplayBox() : (subFigure instanceof LayoutableTag ? ((LayoutableTag)subFigure).getLayouter().calculateSize() : subFigure.displayBox());
            height = Math.max(r.height, height);
            width += r.width + this.insets.left + this.insets.right;
        }
        return new Rectangle(0, 0, width, height += this.insets.top + this.insets.bottom);
    }

    @Override
    public void performLayout(Rectangle box) {
        FigureEnumeration en;
        double yFactor;
        int yBaseLine;
        switch (this.vAlign) {
            case TOP: {
                yBaseLine = box.y + this.insets.top;
                yFactor = 0.0;
                break;
            }
            case BOTTOM: {
                yBaseLine = box.y + box.height - this.insets.bottom;
                yFactor = -1.0;
                break;
            }
            default: {
                yBaseLine = box.y + box.height / 2;
                yFactor = -0.5;
            }
        }
        int xPos = this.insets.left + box.x;
        FigureEnumeration figureEnumeration = en = this.hAlign == Orientation.RIGHT ? this.tagFigure.figures() : this.tagFigure.figuresReverse();
        while (en.hasMoreElements()) {
            Figure subFigure = en.nextFigure();
            Rectangle r = subFigure instanceof Expandable ? ((Expandable)subFigure).compactDisplayBox() : (subFigure instanceof LayoutableTag ? ((LayoutableTag)subFigure).getLayouter().calculateSize() : subFigure.displayBox());
            int y = yBaseLine + CommonUtil.rnd((double)(yFactor * (double)r.height));
            r.setLocation(xPos, y);
            subFigure.displayBox(r);
            xPos += this.insets.left + this.insets.right + r.width;
        }
    }
}

