/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.modeler.figures.process;

import CH.ifa.draw.framework.ConnectionFigure;
import CH.ifa.draw.framework.Connector;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureChangeListener;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.util.List;
import java.util.StringTokenizer;
import org.openbp.cockpit.modeler.ViewModeMgr;
import org.openbp.cockpit.modeler.drawing.ProcessDrawing;
import org.openbp.cockpit.modeler.figures.VisualElementEvent;
import org.openbp.cockpit.modeler.figures.generic.GeometryException;
import org.openbp.cockpit.modeler.figures.generic.XFigure;
import org.openbp.cockpit.modeler.figures.process.ParamConnector;
import org.openbp.cockpit.modeler.figures.process.ParamFigure;
import org.openbp.cockpit.modeler.figures.process.ProcessElementContainer;
import org.openbp.cockpit.modeler.figures.process.SocketFigure;
import org.openbp.cockpit.modeler.figures.spline.PolySplineConnection;
import org.openbp.cockpit.modeler.figures.tag.AbstractTagFigure;
import org.openbp.cockpit.modeler.figures.tag.TagConnector;
import org.openbp.cockpit.modeler.skins.LinkDescriptor;
import org.openbp.cockpit.modeler.skins.SymbolDescriptor;
import org.openbp.common.CommonUtil;
import org.openbp.common.generic.description.DisplayObject;
import org.openbp.common.util.ToStringHelper;
import org.openbp.core.model.item.process.ControlLink;
import org.openbp.core.model.item.process.ControlLinkImpl;
import org.openbp.core.model.item.process.NodeSocket;
import org.openbp.core.model.item.process.ProcessItem;
import org.openbp.core.model.item.process.ProcessObject;

public class FlowConnection
extends PolySplineConnection
implements ProcessElementContainer {
    private ControlLink controlLink;
    private ProcessItem process;
    private XFigure beginFigure;
    private XFigure commitFigure;
    private XFigure commitBeginFigure;
    private XFigure rollbackFigure;
    private XFigure rollbackBeginFigure;
    private Color commitColor = Color.BLACK;
    private Color rollbackColor = Color.BLACK;
    private Color defaultColor = Color.BLACK;

    public FlowConnection(ControlLink controlLink, ProcessDrawing drawing) {
        super(drawing);
        this.controlLink = controlLink;
        controlLink.setRepresentation((Object)this);
        this.process = controlLink.getProcess();
        this.getLabel().setClient((DisplayObject)controlLink);
        this.decodeGeometry();
        this.initializeFigureAttributes();
    }

    public FlowConnection(ProcessDrawing drawing) {
        super(drawing);
        this.process = drawing.getProcess();
        this.controlLink = this.process.createControlLink();
        this.controlLink.setRepresentation((Object)this);
        this.getLabel().setClient((DisplayObject)this.controlLink);
        this.initializeFigureAttributes();
    }

    protected void initializeFigureAttributes() {
        SymbolDescriptor figureDesc;
        LinkDescriptor linkDesc = this.getDrawing().getProcessSkin().getLinkDescriptor("Control");
        if (linkDesc != null) {
            this.setStroke(linkDesc.getStroke());
            this.setFrameColor(linkDesc.getColor());
            this.commitColor = linkDesc.getColor2();
            this.rollbackColor = linkDesc.getColor3();
            this.defaultColor = linkDesc.getColor4();
        }
        if ((figureDesc = this.getDrawing().getProcessSkin().getSymbolDescriptor("Begin")) != null) {
            this.beginFigure = figureDesc.createFigure();
        }
        if ((figureDesc = this.getDrawing().getProcessSkin().getSymbolDescriptor("Commit")) != null) {
            this.commitFigure = figureDesc.createFigure();
        }
        if ((figureDesc = this.getDrawing().getProcessSkin().getSymbolDescriptor("CommitBegin")) != null) {
            this.commitBeginFigure = figureDesc.createFigure();
        }
        if ((figureDesc = this.getDrawing().getProcessSkin().getSymbolDescriptor("Rollback")) != null) {
            this.rollbackFigure = figureDesc.createFigure();
        }
        if ((figureDesc = this.getDrawing().getProcessSkin().getSymbolDescriptor("RollbackBegin")) != null) {
            this.rollbackBeginFigure = figureDesc.createFigure();
        }
    }

    @Override
    protected boolean decodeParameter(String parameter, String errName) {
        if (super.decodeParameter(parameter, errName)) {
            return true;
        }
        StringTokenizer st = new StringTokenizer(parameter, ":");
        String paramName = st.nextToken();
        throw new GeometryException("Unknown paramter '" + paramName + "'.", errName);
    }

    public ControlLink getControlLink() {
        return this.controlLink;
    }

    public String toString() {
        return ToStringHelper.toString((Object)this, (String)"controlLink");
    }

    @Override
    public Rectangle displayBox() {
        Rectangle ret = super.displayBox();
        XFigure transactionFigure = null;
        switch (this.controlLink.getTransactionControl()) {
            case 1: {
                transactionFigure = this.beginFigure;
                break;
            }
            case 2: {
                transactionFigure = this.commitFigure;
                break;
            }
            case 3: {
                transactionFigure = this.commitBeginFigure;
                break;
            }
            case 4: {
                transactionFigure = this.rollbackFigure;
                break;
            }
            case 5: {
                transactionFigure = this.rollbackBeginFigure;
            }
        }
        if (transactionFigure != null) {
            Rectangle taDb = transactionFigure.displayBox();
            ret.add(taDb.width, taDb.height);
        }
        return ret.union(this.label.displayBox());
    }

    @Override
    public void draw(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        Stroke oldStroke = g2.getStroke();
        g2.setStroke(this.getStroke());
        Color oldColor = g2.getColor();
        Color c = null;
        XFigure transactionFigure = null;
        switch (this.controlLink.getTransactionControl()) {
            case 1: {
                transactionFigure = this.beginFigure;
                break;
            }
            case 2: {
                c = this.commitColor;
                transactionFigure = this.commitFigure;
                break;
            }
            case 3: {
                c = this.commitColor;
                transactionFigure = this.commitBeginFigure;
                break;
            }
            case 4: {
                c = this.rollbackColor;
                transactionFigure = this.rollbackFigure;
                break;
            }
            case 5: {
                c = this.rollbackColor;
                transactionFigure = this.rollbackBeginFigure;
            }
        }
        if (c == null) {
            c = this.defaultColor;
        }
        g2.setColor(c);
        this.drawSpline(g2);
        if (transactionFigure != null) {
            this.setTransactionFigurePosition(transactionFigure);
            g2.setColor(c);
            transactionFigure.draw(g2);
        }
        if (this.drawDecorations) {
            g2.setColor(c);
            this.drawDecorations(g);
        }
        g2.setColor(oldColor);
        g2.setStroke(oldStroke);
    }

    private void setTransactionFigurePosition(XFigure transactionFigure) {
        Rectangle tafDb = transactionFigure.displayBox();
        Point2D p = this.getPointOnCurve(0.5);
        Point p1 = new Point(CommonUtil.rnd((double)(p.getX() - (double)(tafDb.width / 2))), CommonUtil.rnd((double)(p.getY() - (double)(tafDb.height / 2))));
        Point p2 = new Point(CommonUtil.rnd((double)(p.getX() + (double)tafDb.width - (double)(tafDb.width / 2))), CommonUtil.rnd((double)(p.getY() + (double)tafDb.height - (double)(tafDb.height / 2))));
        transactionFigure.changed();
        transactionFigure.basicDisplayBox(p1, p2);
        transactionFigure.changed();
    }

    @Override
    public boolean canConnectFigures(Figure start, Figure end, int flags) {
        while (start instanceof ParamFigure) {
            start = ((ParamFigure)start).getParent();
        }
        while (end instanceof ParamFigure) {
            end = ((ParamFigure)end).getParent();
        }
        if (!(start instanceof SocketFigure) || !(end instanceof SocketFigure)) {
            return false;
        }
        return ControlLinkImpl.canLink((NodeSocket)((SocketFigure)start).getNodeSocket(), (NodeSocket)((SocketFigure)end).getNodeSocket()) != 0;
    }

    @Override
    protected boolean shouldReverse(Figure start, Figure end) {
        SocketFigure socketFigure = (SocketFigure)this.startFigure();
        return socketFigure.isEntrySocket();
    }

    @Override
    protected void handleConnect(Figure start, Figure end) {
        SocketFigure startFigure = (SocketFigure)start;
        SocketFigure endFigure = (SocketFigure)end;
        this.controlLink.link(startFigure.getNodeSocket(), endFigure.getNodeSocket());
        startFigure.addFlowConnection(this);
        endFigure.addFlowConnection(this);
        List links = this.process.getControlLinkList();
        if (links != null) {
            int n = links.size();
            for (int i = 0; i < n; ++i) {
                Object link = links.get(i);
                if (link != this.controlLink) continue;
                return;
            }
        }
        this.process.addControlLink(this.controlLink);
        this.controlLink.maintainReferences(5);
    }

    @Override
    protected void handleDisconnect(Figure start, Figure end) {
        this.process.removeControlLink(this.controlLink);
        SocketFigure startFigure = (SocketFigure)start;
        SocketFigure endFigure = (SocketFigure)end;
        if (startFigure != null) {
            startFigure.removeFlowConnection(this);
        }
        if (endFigure != null) {
            endFigure.removeFlowConnection(this);
        }
    }

    @Override
    public void connectStart(Connector newStartConnector) {
        while (newStartConnector instanceof ParamConnector) {
            newStartConnector = ((AbstractTagFigure)newStartConnector.owner()).getParent().connectorAt(0, 0);
        }
        super.connectStart(newStartConnector);
    }

    @Override
    public void connectEnd(Connector newEndConnector) {
        while (newEndConnector instanceof ParamConnector) {
            newEndConnector = ((AbstractTagFigure)newEndConnector.owner()).getParent().connectorAt(0, 0);
        }
        super.connectEnd(newEndConnector);
    }

    @Override
    public boolean connectsSame(ConnectionFigure other) {
        if (!(other instanceof FlowConnection)) {
            return false;
        }
        ControlLink otherLink = ((FlowConnection)other).getControlLink();
        return this.controlLink.getSourceSocketName().equals(otherLink.getSourceSocketName()) && this.controlLink.getTargetSocketName().equals(otherLink.getTargetSocketName());
    }

    @Override
    protected void addStartConnectorChangeListener() {
        if (this.getStartConnector() != null) {
            ((TagConnector)this.getStartConnector()).getSocketFigure().addFigureChangeListener((FigureChangeListener)this);
        }
    }

    @Override
    protected void removeStartConnectorChangeListener() {
        if (this.getStartConnector() != null) {
            ((TagConnector)this.getStartConnector()).getSocketFigure().removeFigureChangeListener((FigureChangeListener)this);
        }
    }

    @Override
    protected void addEndConnectorChangeListener() {
        if (this.getEndConnector() != null) {
            ((TagConnector)this.getEndConnector()).getSocketFigure().addFigureChangeListener((FigureChangeListener)this);
        }
    }

    @Override
    protected void removeEndConnectorChangeListener() {
        if (this.getEndConnector() != null) {
            ((TagConnector)this.getEndConnector()).getSocketFigure().removeFigureChangeListener((FigureChangeListener)this);
        }
    }

    @Override
    public boolean isMinimized() {
        return !ViewModeMgr.getInstance().isControlLinkVisible(this);
    }

    @Override
    public void release() {
        super.release();
        this.process.removeControlLink(this.controlLink);
    }

    public void decodeGeometry() {
        String errIdent = this.controlLink.getQualifier().toUntypedString();
        this.decode(this.controlLink.getGeometry(), errIdent);
    }

    public void encodeGeometry() {
        this.controlLink.setGeometry(this.encode());
    }

    @Override
    public boolean handleEvent(VisualElementEvent event) {
        boolean ret = false;
        if (event.type == "UpdateState") {
            if (!ViewModeMgr.getInstance().isControlAnchorVisible(this)) {
                if (this.getStartConnector() != null) {
                    ((TagConnector)this.getStartConnector()).getSocketFigure().handleEvent(event);
                }
                if (this.getEndConnector() != null) {
                    ((TagConnector)this.getEndConnector()).getSocketFigure().handleEvent(event);
                }
            }
            ret = true;
        }
        if (super.handleEvent(event)) {
            ret = true;
        }
        return ret;
    }

    @Override
    public ProcessObject getProcessElement() {
        return this.controlLink;
    }

    @Override
    public ProcessObject getReferredProcessElement() {
        return this.getProcessElement();
    }

    @Override
    public Figure selectionOnDelete() {
        return (SocketFigure)this.startFigure();
    }
}

