/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.modeler.figures.process;

import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureChangeEvent;
import CH.ifa.draw.framework.FigureChangeListener;
import CH.ifa.draw.standard.AbstractFigure;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.openbp.cockpit.modeler.drawing.ProcessDrawing;
import org.openbp.cockpit.modeler.figures.VisualElement;
import org.openbp.cockpit.modeler.figures.VisualElementEvent;
import org.openbp.cockpit.modeler.figures.generic.GeometryException;
import org.openbp.cockpit.modeler.figures.generic.GeometryUtil;
import org.openbp.common.CollectionUtil;

public abstract class LineFigure
extends AbstractFigure
implements VisualElement {
    private boolean verticalLine;
    private Stroke stroke;
    private Color color;
    protected int xPos;
    protected int yPos;
    private int visualStatus = 1;
    private ProcessDrawing drawing;

    public LineFigure(ProcessDrawing drawing) {
        this.drawing = drawing;
    }

    public boolean isVerticalLine() {
        return this.verticalLine;
    }

    public void setVerticalLine(boolean verticalLine) {
        this.verticalLine = verticalLine;
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Vector handles() {
        return CollectionUtil.EMPTY_VECTOR;
    }

    public void basicDisplayBox(Point origin, Point corner) {
        this.xPos = origin.x;
        if (this.xPos < 0) {
            this.xPos = 0;
        }
        this.yPos = origin.y;
        if (this.yPos < 0) {
            this.yPos = 0;
        }
    }

    public Rectangle displayBox() {
        return new Rectangle(this.xPos - 1, this.yPos - 1, 3, 3);
    }

    public void invalidate() {
        FigureChangeListener l = this.listener();
        if (l != null) {
            Rectangle r = this.infiniteDisplayBox();
            l.figureInvalidated(new FigureChangeEvent((Figure)this, r));
        }
    }

    protected void basicMoveBy(int x, int y) {
        this.xPos += x;
        if (this.xPos < 0) {
            this.xPos = 0;
        }
        this.yPos += y;
        if (this.yPos < 0) {
            this.yPos = 0;
        }
    }

    public Rectangle infiniteDisplayBox() {
        Rectangle r = this.verticalLine ? new Rectangle(this.xPos - 1, 0, 3, 10000) : new Rectangle(0, this.yPos - 1, 10000, 3);
        return r;
    }

    public boolean containsPoint(int x, int y) {
        if (this.verticalLine) {
            return x >= this.xPos - 4 && x <= this.xPos + 4;
        }
        return y >= this.yPos - 4 && y <= this.yPos + 4;
    }

    public void draw(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        Color oldColor = g2.getColor();
        g2.setColor(this.getColor());
        Stroke oldStroke = g2.getStroke();
        g2.setStroke(this.getStroke());
        if (this.verticalLine) {
            g.drawLine(this.xPos, 0, this.xPos, 10000);
        } else {
            g.drawLine(0, this.yPos, 10000, this.yPos);
        }
        g2.setColor(oldColor);
        g2.setStroke(oldStroke);
    }

    public void decodeGeometry(String geometry) {
        if (geometry == null) {
            return;
        }
        String errIdent = "line figure";
        StringTokenizer st = new StringTokenizer(geometry, ":");
        while (st.hasMoreTokens()) {
            String paramName = st.nextToken();
            if (paramName.equalsIgnoreCase("x")) {
                this.xPos = GeometryUtil.parseInt(st, paramName, errIdent);
                continue;
            }
            if (paramName.equalsIgnoreCase("y")) {
                this.yPos = GeometryUtil.parseInt(st, paramName, errIdent);
                continue;
            }
            throw new GeometryException("Unknown paramter '" + paramName + "'.", errIdent);
        }
    }

    public String encodeGeometry() {
        return "x:" + this.xPos + ":y:" + this.yPos;
    }

    @Override
    public void setDrawing(ProcessDrawing drawing) {
        this.drawing = drawing;
    }

    @Override
    public ProcessDrawing getDrawing() {
        return this.drawing;
    }

    @Override
    public VisualElement getParentElement() {
        return this.getDrawing();
    }

    @Override
    public Figure getPresentationFigure() {
        return null;
    }

    @Override
    public void updatePresentationFigure() {
    }

    @Override
    public boolean isVisible() {
        return (this.visualStatus & 1) != 0;
    }

    @Override
    public void setVisible(boolean visible) {
        this.willChange();
        this.visualStatus = visible ? (this.visualStatus |= 1) : (this.visualStatus &= 0xFFFFFFFE);
        this.changed();
    }

    @Override
    public boolean handleEvent(VisualElementEvent event) {
        return false;
    }

    @Override
    public void dragActionTriggered(Object regionId, Point p) {
    }

    @Override
    public void dragEnded(Transferable transferable) {
    }

    @Override
    public void dragStarted(Transferable transferable) {
    }

    @Override
    public List getAllDropRegions(List flavors, Transferable data, MouseEvent mouseEvent) {
        return this.getDropRegions(flavors, data, mouseEvent);
    }

    @Override
    public List getDropRegions(List flavors, Transferable data, MouseEvent mouseEvent) {
        return null;
    }

    @Override
    public List getImportersAt(Point p) {
        return null;
    }

    @Override
    public List getAllImportersAt(Point p) {
        return null;
    }

    @Override
    public List getSubClients() {
        return null;
    }

    @Override
    public boolean importData(Object regionId, Transferable data, Point p) {
        return false;
    }
}

