/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.modeler.figures.process;

import CH.ifa.draw.framework.Connector;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.Locator;
import CH.ifa.draw.standard.AbstractHandle;
import CH.ifa.draw.standard.AbstractLocator;
import CH.ifa.draw.standard.TextHolder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.openbp.cockpit.modeler.AutoConnector;
import org.openbp.cockpit.modeler.Modeler;
import org.openbp.cockpit.modeler.ModelerColors;
import org.openbp.cockpit.modeler.ModelerGraphics;
import org.openbp.cockpit.modeler.ViewModeMgr;
import org.openbp.cockpit.modeler.drawing.DrawingEditorPlugin;
import org.openbp.cockpit.modeler.drawing.WorkspaceDrawingView;
import org.openbp.cockpit.modeler.figures.VisualElementEvent;
import org.openbp.cockpit.modeler.figures.generic.FixedTitleFigure;
import org.openbp.cockpit.modeler.figures.generic.GeometryException;
import org.openbp.cockpit.modeler.figures.generic.GeometryUtil;
import org.openbp.cockpit.modeler.figures.generic.MoveableTitleFigure;
import org.openbp.cockpit.modeler.figures.generic.Orientation;
import org.openbp.cockpit.modeler.figures.generic.SimpleImageFigure;
import org.openbp.cockpit.modeler.figures.generic.XFigure;
import org.openbp.cockpit.modeler.figures.layouter.MultiplexLayouter;
import org.openbp.cockpit.modeler.figures.process.NodeFigure;
import org.openbp.cockpit.modeler.figures.process.ParamConnection;
import org.openbp.cockpit.modeler.figures.process.ParamConnector;
import org.openbp.cockpit.modeler.figures.process.ProcessElementContainer;
import org.openbp.cockpit.modeler.figures.process.ProcessVariableConnection;
import org.openbp.cockpit.modeler.figures.process.ProcessVariableFigure;
import org.openbp.cockpit.modeler.figures.process.SocketFigure;
import org.openbp.cockpit.modeler.figures.tag.AbstractTagFigure;
import org.openbp.cockpit.modeler.figures.tag.StraightTagFigure;
import org.openbp.cockpit.modeler.paramvaluewizard.ParamValueWizard;
import org.openbp.cockpit.modeler.skins.SymbolDescriptor;
import org.openbp.common.CollectionUtil;
import org.openbp.common.generic.description.DisplayObject;
import org.openbp.common.util.ToStringHelper;
import org.openbp.core.model.item.Item;
import org.openbp.core.model.item.process.DataLink;
import org.openbp.core.model.item.process.DataLinkImpl;
import org.openbp.core.model.item.process.NodeParam;
import org.openbp.core.model.item.process.Param;
import org.openbp.core.model.item.process.ProcessObject;
import org.openbp.core.model.item.process.ProcessVariable;
import org.openbp.core.model.item.type.DataTypeItem;
import org.openbp.guiclient.model.item.ItemIconMgr;
import org.openbp.guiclient.util.ClientFlavors;
import org.openbp.jaspira.gui.interaction.ViewDropRegion;
import org.openbp.swing.SwingUtil;

public class ParamFigure
extends StraightTagFigure
implements ProcessElementContainer,
TextHolder {
    private static final int DFLT_LABEL_DISTANCE = 5;
    public static final String PARAM_TYPE_NAME = "TypeName";
    private NodeParam nodeParam;
    private LinkedList paramConnections;
    private FixedTitleFigure titleFigure;
    private Figure iconFigure;
    private ProcessVariableFigure processVariableFigure;
    private ProcessVariableConnection processVariableConnection;
    private MoveableTitleFigure globalTitleLabel;
    GlobalDistanceLocator globalDistanceLocator;
    int labelDistance;

    public ParamFigure(AbstractTagFigure parent, NodeParam nodeParam, Point origin) {
        super(parent, nodeParam, origin);
    }

    @Override
    protected XFigure createPresentationFigure() {
        SymbolDescriptor desc = this.getDrawing().getProcessSkin().getSymbolDescriptor("Param");
        if (desc != null) {
            return desc.createFigure();
        }
        return super.createPresentationFigure();
    }

    @Override
    protected void initTagLayouter() {
        this.layouter = this.getDrawing().getProcessSkin().isRadialTags() ? MultiplexLayouter.getRadialInstance2(this) : MultiplexLayouter.getUpDownInstance(this);
        this.layouter.setInsets(new Insets(1, 1, 1, 1));
    }

    @Override
    protected void initContent(Object modelObject) {
        this.nodeParam = (NodeParam)modelObject;
        this.nodeParam.setRepresentation((Object)this);
        String titleFormat = this.getDrawing().getProcessSkin().getParamTitleFormat();
        if (titleFormat != null) {
            this.titleFigure = new FixedTitleFigure((DisplayObject)this.nodeParam);
            this.titleFigure.setTitleFormat(titleFormat);
            this.titleFigure.setAutoSize(true);
            this.titleFigure.updateFigure();
            this.addContent(this.titleFigure, 2);
            this.contentState = 2;
        } else {
            this.iconFigure = new SimpleImageFigure(ItemIconMgr.getInstance().getTypeIcon(this.getDrawing().getProcessSkin().getName(), this.nodeParam.getDataType(), 16));
            this.addContent(this.iconFigure, 1);
            this.contentState = 1;
        }
        this.decodeGeometry();
    }

    @Override
    protected void initShadow() {
    }

    public NodeParam getNodeParam() {
        return this.nodeParam;
    }

    public String toString() {
        return ToStringHelper.toString((Object)this, (String)"nodeParam");
    }

    public void addParamConnection(ParamConnection connection) {
        if (this.paramConnections == null) {
            this.paramConnections = new LinkedList();
        } else if (this.paramConnections.contains(connection)) {
            return;
        }
        this.paramConnections.add(connection);
    }

    public void removeParamConnection(ParamConnection connection) {
        if (this.paramConnections != null) {
            this.paramConnections.remove(connection);
            if (this.paramConnections.isEmpty()) {
                this.paramConnections = null;
            }
        }
    }

    public void removeConnections() {
        while (this.paramConnections != null && !this.paramConnections.isEmpty()) {
            ParamConnection connection = (ParamConnection)this.paramConnections.getFirst();
            this.getDrawing().remove(connection);
            connection.release();
        }
        this.removeProcessVariableConnection();
    }

    public ProcessVariableConnection setProcessVariableConnection(ProcessVariable param, DataLink data) {
        if (this.processVariableFigure != null) {
            return null;
        }
        this.processVariableConnection = new ProcessVariableConnection(data, this);
        this.addContent(this.processVariableConnection, 3);
        this.processVariableFigure = new ProcessVariableFigure(param, this);
        this.addContent(this.processVariableFigure, 8);
        this.globalDistanceLocator = new GlobalDistanceLocator();
        this.globalTitleLabel = new MoveableTitleFigure((DisplayObject)param);
        this.globalTitleLabel.setVerboseDisplay(true);
        this.globalTitleLabel.connect(this);
        this.setContentState(9);
        this.setAngle(this.getAngle());
        return this.processVariableConnection;
    }

    public void removeProcessVariableConnection() {
        if (this.processVariableFigure == null) {
            return;
        }
        Iterator it = this.content.iterator();
        while (it.hasNext()) {
            AbstractTagFigure.TagContent content = (AbstractTagFigure.TagContent)it.next();
            Figure contentFigure = content.getFigure();
            if (!(contentFigure instanceof ProcessVariableConnection) && !(contentFigure instanceof ProcessVariableFigure)) continue;
            it.remove();
        }
        this.invalidate();
        this.processVariableFigure.invalidate();
        this.processVariableConnection.invalidate();
        this.processVariableFigure = null;
        this.globalTitleLabel.disconnect(this);
        this.globalTitleLabel = null;
        this.globalDistanceLocator = null;
        this.getDrawing().getEditor().view().clearSelection();
        this.getDrawing().getProcess().removeDataLink(this.processVariableConnection.getDataLink());
        this.processVariableConnection = null;
        this.setContentState(1);
        this.getDrawing().getEditor().view().checkDamage();
        this.getDrawing().setModified();
    }

    protected int determineStandardTitleDistance() {
        if (this.globalTitleLabel == null) {
            return 0;
        }
        String text = this.globalTitleLabel.getText();
        if (text == null) {
            return 0;
        }
        int dist = 0;
        FontMetrics fm = ModelerGraphics.getDefaultFontMetrics();
        Orientation orientation = this.getTagOrientation();
        if (orientation == Orientation.LEFT || orientation == Orientation.RIGHT) {
            Rectangle r = new Rectangle();
            SwingUtil.computeMultilineStringBounds((FontMetrics)fm, (String)text, (int)1, (Rectangle)r);
            dist = r.width / 2 + 5;
        } else {
            dist = 5 + fm.getHeight();
        }
        return dist;
    }

    @Override
    public boolean isVerticalOrientation() {
        return this.getLayouter().isVerticalLayouter();
    }

    @Override
    public Vector handles() {
        if (this.globalTitleLabel != null) {
            Vector<MoveLableHandle> v = new Vector<MoveLableHandle>();
            v.add(new MoveLableHandle());
            return v;
        }
        return CollectionUtil.EMPTY_VECTOR;
    }

    @Override
    public Connector connectorAt(int x, int y) {
        return new ParamConnector(this);
    }

    @Override
    public boolean canConnect() {
        return true;
    }

    @Override
    public boolean containsPoint(int x, int y) {
        if (this.iconFigure != null && this.iconFigure.containsPoint(x, y)) {
            return true;
        }
        if (this.titleFigure != null && this.titleFigure.containsPoint(x, y)) {
            return true;
        }
        if (this.processVariableConnection != null && this.processVariableConnection.containsPoint(x, y)) {
            return true;
        }
        return this.processVariableFigure != null && this.processVariableFigure.containsPoint(x, y);
    }

    @Override
    public Rectangle displayBox() {
        Rectangle result = super.displayBox();
        if (this.globalTitleLabel != null) {
            result.add(this.globalTitleLabel.displayBox());
        }
        return result;
    }

    @Override
    public void basicSetAngle(double angle) {
        super.basicSetAngle(angle);
        this.tagOrientation = this.determine2WayOrientation(this.isVerticalOrientation());
    }

    @Override
    public void draw(Graphics g) {
        super.draw(g);
        if (this.globalTitleLabel != null && ViewModeMgr.getInstance().isDataLinkVisible(this)) {
            this.globalTitleLabel.draw(g);
        }
    }

    public void release() {
        this.removeConnections();
        ((SocketFigure)this.getParent()).removeParam(this);
        super.release();
    }

    public Locator connectedTextLocator(Figure text) {
        return this.globalDistanceLocator;
    }

    Point getProcessVariableConnectionDockLocation() {
        Rectangle db = this.presentationFigure.displayBox();
        int x = 0;
        int y = 0;
        Orientation orientation = this.getTagOrientation();
        switch (orientation) {
            case RIGHT: {
                x = (int)db.getMaxX();
                y = (int)db.getCenterY();
                break;
            }
            case BOTTOM: {
                x = (int)db.getCenterX();
                y = (int)db.getMaxY();
                break;
            }
            case LEFT: {
                x = (int)db.getMinX();
                y = (int)db.getCenterY();
                break;
            }
            case TOP: {
                x = (int)db.getCenterX();
                y = (int)db.getMinY();
            }
        }
        return new Point(x, y);
    }

    @Override
    public ProcessObject getProcessElement() {
        return this.nodeParam;
    }

    @Override
    public ProcessObject getReferredProcessElement() {
        return this.getProcessElement();
    }

    @Override
    public Figure selectionOnDelete() {
        return this.parent;
    }

    public Rectangle textDisplayBox() {
        if (this.titleFigure != null) {
            return this.titleFigure.displayBox();
        }
        return this.displayBox();
    }

    public String getText() {
        return this.getProcessElement().getName();
    }

    public void setText(String newText) {
        this.getProcessElement().setName(newText);
    }

    public boolean acceptsTyping() {
        return true;
    }

    public int overlayColumns() {
        String text = this.getText();
        int columns = 20;
        if (text != null && text.length() > 17) {
            columns = text.length() + 3;
        }
        return columns;
    }

    public void connect(Figure connectedFigure) {
    }

    public void disconnect(Figure disconnectFigure) {
    }

    public Font getFont() {
        return ModelerGraphics.getStandardTextFont();
    }

    @Override
    public boolean handleEvent(VisualElementEvent event) {
        DrawingEditorPlugin editor;
        if (event.type == "UpdateState") {
            SocketFigure socketFigure = (SocketFigure)this.getParent();
            socketFigure.handleEvent(event);
            return true;
        }
        if (event.type == "DoubleClick" && (editor = this.getDrawing().getEditor()) instanceof Modeler) {
            SocketFigure socketFigure = (SocketFigure)this.getParent();
            ParamValueWizard.displayParameterValueWizard((Modeler)editor, (NodeFigure)socketFigure.getParent(), socketFigure.getNodeSocket().getName(), this.nodeParam.getName());
            return true;
        }
        return false;
    }

    @Override
    public void updateFigure() {
        super.updateFigure();
        if (this.globalTitleLabel != null) {
            this.globalTitleLabel.updateFigure();
        }
    }

    @Override
    public Rectangle compactDisplayBox() {
        Rectangle r = this.iconFigure != null ? new Rectangle(this.iconFigure.displayBox()) : (this.titleFigure != null ? new Rectangle(this.titleFigure.displayBox()) : new Rectangle());
        r.grow(1, 1);
        return r;
    }

    public void decodeGeometry() {
        if (this.nodeParam.getGeometry() == null) {
            return;
        }
        StringTokenizer tok = new StringTokenizer(this.nodeParam.getGeometry(), "|");
        while (tok.hasMoreTokens()) {
            this.decodeParameter(tok.nextToken());
        }
    }

    protected void decodeParameter(String parameter) {
        String errIdent = this.nodeParam.getQualifier().toUntypedString();
        StringTokenizer st = new StringTokenizer(parameter, ":");
        String paramName = st.nextToken();
        if (!paramName.equals("distance")) {
            throw new GeometryException("Unknown paramter '" + paramName + "'.", errIdent);
        }
        this.labelDistance = GeometryUtil.parseInt(st, paramName, errIdent);
    }

    public void encodeGeometry() {
        String geometry = null;
        int stdDist = this.determineStandardTitleDistance();
        if (this.labelDistance != 0 && this.labelDistance != stdDist) {
            geometry = "distance:" + this.labelDistance;
        }
        this.nodeParam.setGeometry(geometry);
    }

    @Override
    public List getDropRegions(List flavors, Transferable data, MouseEvent mouseEvent) {
        boolean accept = false;
        if (flavors.contains(ClientFlavors.PROCESS_VARIABLE)) {
            if (this.processVariableFigure == null) {
                try {
                    ProcessVariable processVariable = (ProcessVariable)data.getTransferData(ClientFlavors.PROCESS_VARIABLE);
                    int flags = 2;
                    if (mouseEvent != null && mouseEvent.isShiftDown()) {
                        flags = 1;
                    }
                    if (DataLinkImpl.canLink((Param)this.nodeParam, null, (Param)processVariable, null, (int)flags) != 0) {
                        accept = true;
                    }
                }
                catch (UnsupportedFlavorException e) {
                }
                catch (IOException e) {}
            }
        } else if (flavors.contains(ClientFlavors.COMPLEX_TYPE_ITEM) && mouseEvent != null && mouseEvent.isControlDown() && this.nodeParam.getName().equals(PARAM_TYPE_NAME)) {
            accept = true;
        }
        if (accept) {
            WorkspaceDrawingView view = this.getDrawing().getView();
            Rectangle r = this.iconFigure != null ? this.iconFigure.displayBox() : (this.titleFigure != null ? this.titleFigure.displayBox() : new Rectangle());
            r = view.applyScale(r, false);
            ViewDropRegion region = new ViewDropRegion("global", this, r, (Component)((Object)view));
            region.setPaint(ModelerColors.DROP_REGION);
            return Collections.singletonList(region);
        }
        return null;
    }

    @Override
    public boolean importData(Object regionId, Transferable data, Point p) {
        p = SwingUtil.convertFromGlassCoords((Point)p, (Component)((Object)this.getDrawing().getView()));
        try {
            if (data.isDataFlavorSupported(ClientFlavors.PROCESS_VARIABLE)) {
                NodeParam targetParam;
                ProcessVariable sourceParam;
                ProcessVariable processVariable = (ProcessVariable)data.getTransferData(ClientFlavors.PROCESS_VARIABLE);
                this.getDrawing().getEditor().startUndo("Add Global Link");
                DataLink dataLink = this.getDrawing().getProcess().createDataLink();
                SocketFigure socketFigure = (SocketFigure)this.getParent();
                if (socketFigure.isEntrySocket()) {
                    sourceParam = processVariable;
                    targetParam = this.nodeParam;
                } else {
                    sourceParam = this.nodeParam;
                    targetParam = processVariable;
                }
                dataLink.link((Param)sourceParam, (Param)targetParam);
                String sourceMemberPath = AutoConnector.checkAutoConversion((Param)sourceParam, null, (Param)targetParam, null);
                dataLink.setSourceMemberPath(sourceMemberPath);
                this.getDrawing().getProcess().addDataLink(dataLink);
                ((WorkspaceDrawingView)this.getDrawing().getEditor().view()).singleSelect(this.setProcessVariableConnection(processVariable, dataLink));
                ((Component)this.getDrawing().getEditor().view()).requestFocus();
                this.getDrawing().getEditor().endUndo();
                return true;
            }
            if (data.isDataFlavorSupported(ClientFlavors.COMPLEX_TYPE_ITEM)) {
                DataTypeItem type = (DataTypeItem)data.getTransferData(ClientFlavors.COMPLEX_TYPE_ITEM);
                this.getDrawing().getEditor().startUndo("Assign Type Name");
                String typeName = this.getDrawing().getProcess().determineItemRef((Item)type);
                this.nodeParam.setExpression('\"' + typeName + '\"');
                ((WorkspaceDrawingView)this.getDrawing().getEditor().view()).singleSelect(this);
                ((Component)this.getDrawing().getEditor().view()).requestFocus();
                this.getDrawing().getEditor().endUndo();
                return true;
            }
            this.getDrawing().getEditor().focusPlugin();
        }
        catch (UnsupportedFlavorException e) {
        }
        catch (IOException e) {
            // empty catch block
        }
        return false;
    }

    class MoveLableHandle
    extends AbstractHandle {
        int lastY;

        public MoveLableHandle() {
            super((Figure)ParamFigure.this);
        }

        public void invokeStart(int x, int y, Drawing drawing) {
            this.lastY = y;
        }

        public void invokeStep(int x, int y, int ax, int ay, DrawingView view) {
            ParamFigure.this.willChange();
            ParamFigure.this.labelDistance = ParamFigure.this.isVerticalOrientation() ? y - ParamFigure.this.getProcessVariableConnectionDockLocation().y : x - ParamFigure.this.getProcessVariableConnectionDockLocation().x;
            Orientation orientation = ParamFigure.this.getTagOrientation();
            if (orientation == Orientation.LEFT) {
                ParamFigure.this.labelDistance = -ParamFigure.this.labelDistance;
            } else if (orientation == Orientation.TOP) {
                ParamFigure.this.labelDistance = -ParamFigure.this.labelDistance;
            }
            ParamFigure.this.labelDistance = Math.max(5, ParamFigure.this.labelDistance);
            ParamFigure.this.changed();
        }

        public Point locate() {
            return ParamFigure.this.globalDistanceLocator.locate(null);
        }

        public void draw(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            super.draw(g);
            Point p1 = ParamFigure.this.getProcessVariableConnectionDockLocation();
            Point p2 = this.locate();
            Stroke old = g2.getStroke();
            g2.setStroke(ModelerGraphics.labelHandleStroke);
            Color olc = g.getColor();
            g.setColor(ModelerColors.LABEL_HANDLE_LINE);
            g.drawLine(p1.x, p1.y, p2.x, p2.y);
            g2.setStroke(old);
            g.setColor(olc);
        }
    }

    class GlobalDistanceLocator
    extends AbstractLocator {
        public Point locate(Figure figure) {
            Point p = ParamFigure.this.getProcessVariableConnectionDockLocation();
            int dist = ParamFigure.this.labelDistance != 0 ? ParamFigure.this.labelDistance : ParamFigure.this.determineStandardTitleDistance();
            Orientation orientation = ParamFigure.this.getTagOrientation();
            if (orientation == Orientation.LEFT) {
                p.x -= dist;
            } else if (orientation == Orientation.RIGHT) {
                p.x += dist;
            } else {
                p.y = orientation == Orientation.TOP ? (p.y -= dist) : (p.y += dist);
            }
            return p;
        }
    }
}

