/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.modeler.figures.process;

import java.awt.Component;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import org.openbp.cockpit.itemeditor.ItemCreationUtil;
import org.openbp.cockpit.modeler.drawing.ProcessDrawing;
import org.openbp.cockpit.modeler.figures.VisualElementEvent;
import org.openbp.cockpit.modeler.figures.process.MultiSocketNodeFigure;
import org.openbp.cockpit.modeler.util.FigureUtil;
import org.openbp.common.rc.ResourceCollection;
import org.openbp.core.model.Model;
import org.openbp.core.model.ModelObject;
import org.openbp.core.model.ModelQualifier;
import org.openbp.core.model.item.Item;
import org.openbp.core.model.item.process.Node;
import org.openbp.core.model.item.process.PlaceholderNode;
import org.openbp.core.model.item.process.ProcessItem;
import org.openbp.guiclient.model.item.itemtree.ItemSelectionDialog;
import org.openbp.guiclient.model.item.itemtree.ItemTreeState;
import org.openbp.guiclient.util.ClientFlavors;
import org.openbp.jaspira.gui.interaction.BasicTransferable;
import org.openbp.jaspira.plugin.ApplicationUtil;
import org.openbp.jaspira.util.StandardFlavors;
import org.openbp.swing.SwingUtil;
import org.openbp.swing.components.JMsgBox;

public class PlaceholderNodeFigure
extends MultiSocketNodeFigure {
    private boolean isReferencingPlaceholder;

    @Override
    public boolean handleEvent(VisualElementEvent event) {
        PlaceholderNode placeholderNode;
        if (event.type == "DoubleClick" && (placeholderNode = (PlaceholderNode)this.node).getReferencePath() == null) {
            ResourceCollection res = this.getDrawing().getEditor().getPluginResourceCollection();
            String title = res.getRequiredString("placeholder.referencedialog.title");
            String text = res.getRequiredString("placeholder.referencedialog.text");
            JMsgBox msgBox = new JMsgBox(null, title, text, 14);
            msgBox.setResource(res);
            msgBox.setResourcePrefix("placeholder.referencedialog.");
            msgBox.initDialog();
            SwingUtil.show((JDialog)msgBox);
            int choice = msgBox.getUserChoice();
            Model model = this.node.getOwningModel();
            if (choice == 4) {
                final Item item = ItemCreationUtil.createItem(model, placeholderNode.getName(), placeholderNode.getDisplayName(), "Process", null);
                if (item != null) {
                    this.assignPlaceholderReference((ModelObject)item);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            PlaceholderNodeFigure.this.getDrawing().getEditor().fireEvent("plugin.association.open", new BasicTransferable(item));
                        }
                    });
                }
            } else if (choice == 8) {
                ItemSelectionDialog dlg = new ItemSelectionDialog(ApplicationUtil.getActiveWindow(), true);
                String dlgTitle = res.getRequiredString("placeholder.referencedialog.select");
                dlg.setTitle(dlgTitle);
                dlg.setSelectionMode(1);
                dlg.setShowGroups(false);
                dlg.setSupportedItemTypes(new String[]{"Model", "Process"});
                dlg.setSelectableItemTypes(new String[]{"Process"});
                dlg.setSupportedObjectClasses(new Class[]{Node.class});
                dlg.setSelectableObjectClasses(new Class[]{Node.class});
                ItemTreeState state = new ItemTreeState();
                state.addExpandedQualifier(model.getQualifier());
                dlg.rebuildTree();
                dlg.expand(1);
                dlg.restoreState(state);
                dlg.setVisible(true);
                List selection = dlg.getSelectedObjects();
                if (selection != null) {
                    ModelObject selectedObject = (ModelObject)selection.get(0);
                    this.assignPlaceholderReference(selectedObject);
                }
            }
            return true;
        }
        return super.handleEvent(event);
    }

    @Override
    public void updateFigure() {
        boolean hasReference;
        super.updateFigure();
        boolean bl = hasReference = ((PlaceholderNode)this.node).getReferencePath() != null;
        if (hasReference != this.isReferencingPlaceholder) {
            this.isReferencingPlaceholder = hasReference;
            FigureUtil.updateSkin(this);
        }
    }

    @Override
    protected String getDropRegionIdForFlavor(List flavors, Transferable data, MouseEvent mouseEvent) {
        String regionId = super.getDropRegionIdForFlavor(flavors, data, mouseEvent);
        if (regionId == null && (flavors.contains(ClientFlavors.PROCESS_ITEM) || flavors.contains(ClientFlavors.NODE) || flavors.contains(ClientFlavors.MODEL_QUALIFIER))) {
            regionId = this.node.getQualifier().toString();
        }
        return regionId;
    }

    @Override
    public boolean importData(Object regionId, Transferable data, Point p) {
        if (super.importData(regionId, data, p)) {
            return true;
        }
        p = SwingUtil.convertFromGlassCoords((Point)p, (Component)((Object)this.getDrawing().getView()));
        try {
            if (data.isDataFlavorSupported(ClientFlavors.PROCESS_ITEM) || data.isDataFlavorSupported(ClientFlavors.NODE)) {
                ModelObject mo = (ModelObject)data.getTransferData(StandardFlavors.OBJECT);
                this.assignPlaceholderReference(mo);
                this.getDrawing().getEditor().focusPlugin();
                return true;
            }
            if (data.isDataFlavorSupported(ClientFlavors.MODEL_QUALIFIER)) {
                ModelQualifier qualifier = (ModelQualifier)data.getTransferData(ClientFlavors.MODEL_QUALIFIER);
                this.assignPlaceholderReference(qualifier.toString());
                this.getDrawing().getEditor().focusPlugin();
                return true;
            }
        }
        catch (UnsupportedFlavorException e) {
        }
        catch (IOException e) {
            // empty catch block
        }
        return false;
    }

    protected void assignPlaceholderReference(ModelObject mo) {
        String referencePath = null;
        Model model = this.getDrawing().getProcess().getModel();
        if (model != null) {
            referencePath = model.determineObjectRef(mo);
        }
        if (referencePath == null) {
            referencePath = mo.getQualifier().toString();
        }
        this.assignPlaceholderReference(referencePath);
    }

    public void assignPlaceholderReference(String referencePath) {
        ProcessDrawing drawing = this.getDrawing();
        drawing.getEditor().startUndo("Create placeholder reference");
        PlaceholderNode placeholderNode = (PlaceholderNode)this.node;
        placeholderNode.setReferencePath(referencePath);
        this.updateFigure();
        drawing.getView().updateSelection();
        drawing.getEditor().endUndo();
        drawing.getView().redraw();
    }

    protected void substitutePlaceholderNode(Node newNode, boolean newNodeFlag) {
        ProcessDrawing drawing = this.getDrawing();
        ProcessItem process = drawing.getProcess();
        drawing.encodeGeometry();
        drawing.getEditor().startUndo("Replace placeholder");
        process.addNode(this.node);
        this.node.maintainReferences(5);
        PlaceholderNode plNode = (PlaceholderNode)this.getNode();
        Iterator itSockets = plNode.getSockets();
        while (itSockets.hasNext()) {
        }
        drawing.setProcess(process);
        drawing.getEditor().endUndo();
        drawing.getView().redraw();
    }
}

