/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.modeler.figures.process;

import java.util.HashMap;
import java.util.Map;
import org.openbp.cockpit.modeler.figures.process.ProcessElementContainer;
import org.openbp.common.ReflectUtil;
import org.openbp.core.model.item.process.ProcessObject;

public class ProcessElementFigureRegistry {
    private Map elementClassToFigureClass = new HashMap();
    private static ProcessElementFigureRegistry singletonInstance;

    public static synchronized ProcessElementFigureRegistry getInstance() {
        if (singletonInstance == null) {
            singletonInstance = new ProcessElementFigureRegistry();
        }
        return singletonInstance;
    }

    private ProcessElementFigureRegistry() {
    }

    public void registerFigure(Class figureClass, Class elementClass) {
        this.elementClassToFigureClass.put(elementClass, figureClass);
    }

    public ProcessElementContainer createProcessElementContainer(ProcessObject po) {
        Class figureClass = this.findFigureClass(po.getClass());
        if (figureClass == null) {
            throw new RuntimeException("Cannot find figure for process object '" + po.getClass() + "'.");
        }
        try {
            return (ProcessElementContainer)ReflectUtil.instantiate((Class)figureClass, ProcessElementContainer.class, (String)"process element figure");
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot instantiate figure class", e);
        }
    }

    private Class findFigureClass(Class poCls) {
        Class figureClass = (Class)this.elementClassToFigureClass.get(poCls);
        if (figureClass == null) {
            Class<?>[] interfaces = poCls.getInterfaces();
            for (int i = 0; i < interfaces.length && (figureClass = this.findFigureClass(interfaces[i])) == null; ++i) {
            }
        }
        return figureClass;
    }
}

