/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.modeler.figures.process;

import CH.ifa.draw.figures.LineDecoration;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.standard.AbstractFigure;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Vector;
import org.openbp.cockpit.modeler.ViewModeMgr;
import org.openbp.cockpit.modeler.drawing.ProcessDrawing;
import org.openbp.cockpit.modeler.figures.VisualElement;
import org.openbp.cockpit.modeler.figures.VisualElementEvent;
import org.openbp.cockpit.modeler.figures.generic.Orientation;
import org.openbp.cockpit.modeler.figures.generic.XArrowTip;
import org.openbp.cockpit.modeler.figures.process.ParamFigure;
import org.openbp.cockpit.modeler.figures.process.ProcessElementContainer;
import org.openbp.cockpit.modeler.figures.process.SocketFigure;
import org.openbp.cockpit.modeler.skins.LinkDescriptor;
import org.openbp.cockpit.modeler.util.FigureResources;
import org.openbp.common.util.ToStringHelper;
import org.openbp.core.model.item.process.DataLink;
import org.openbp.core.model.item.process.ProcessObject;
import org.openbp.jaspira.decoration.DecorationMgr;

public class ProcessVariableConnection
extends AbstractFigure
implements ProcessElementContainer {
    public static final int ARROW_SIZE = 20;
    private static final LineDecoration endDecoration = new XArrowTip(0.4, 12.0, 9.0);
    private DataLink dataLink;
    private ParamFigure paramFigure;
    private Point start;
    private Stroke stroke = FigureResources.standardStroke1;
    private Color color = Color.BLACK;
    private Color color2 = Color.BLACK;

    public ProcessVariableConnection(DataLink link, ParamFigure paramFigure) {
        this.paramFigure = paramFigure;
        this.dataLink = link;
        this.dataLink.setRepresentation((Object)this);
        this.start = new Point();
        LinkDescriptor desc = this.getDrawing().getProcessSkin().getLinkDescriptor("Data");
        if (desc != null) {
            this.stroke = desc.getStroke();
            this.color = desc.getColor();
            this.color2 = desc.getColor2();
        }
    }

    public DataLink getDataLink() {
        return this.dataLink;
    }

    public String toString() {
        return ToStringHelper.toString((Object)this, (String)"paramFigure", (String)"DataLink");
    }

    protected void basicMoveBy(int dx, int dy) {
        this.start.x += dx;
        this.start.y += dy;
    }

    public void basicDisplayBox(Point start, Point end) {
        this.start = start;
    }

    public Rectangle displayBox() {
        int h;
        int w;
        Rectangle paramFigureBox = this.paramFigure.compactDisplayBox();
        if (this.paramFigure.isVerticalOrientation()) {
            w = paramFigureBox.width;
            h = 20;
        } else {
            w = 20;
            h = paramFigureBox.height;
        }
        return new Rectangle(this.start.x, this.start.y, w, h);
    }

    public Vector handles() {
        return this.paramFigure.handles();
    }

    public void draw(Graphics g) {
        if (!ViewModeMgr.getInstance().isDataLinkVisible(this)) {
            return;
        }
        Color c = this.dataLink.getSourceMemberPath() != null || this.dataLink.getTargetMemberPath() != null ? this.color2 : this.color;
        g.setColor(c);
        ((Graphics2D)g).setStroke(this.stroke);
        Rectangle r = this.displayBox();
        Point p1 = new Point();
        Point p2 = new Point();
        this.determineLineEndPoints(r, p1, p2);
        g.drawLine(p1.x, p1.y, p2.x, p2.y);
        endDecoration.draw(g, p2.x, p2.y, p1.x, p1.y);
        Stroke stroke = (Stroke)DecorationMgr.decorate(this, "Figure.FrameStroke", null);
        Color frame = (Color)DecorationMgr.decorate(this, "Figure.FrameColor", null);
        if (frame != null && stroke != null) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setStroke(stroke);
            g.setColor(frame);
            g.drawRoundRect(r.x, r.y, r.width, r.height, 8, 8);
        }
    }

    private void determineLineEndPoints(Rectangle r, Point p1, Point p2) {
        boolean isExit;
        SocketFigure socketFigure = (SocketFigure)this.paramFigure.getParent();
        boolean bl = isExit = !socketFigure.isEntrySocket();
        if (this.paramFigure.isVerticalOrientation()) {
            Orientation socketOrientation = socketFigure.determine2WayOrientation(true);
            boolean topToBottom = socketOrientation == Orientation.TOP ^ isExit;
            int x = r.x + r.width / 2;
            if (topToBottom) {
                p1.setLocation(x, r.y);
                p2.setLocation(x, r.y + r.height);
            } else {
                p2.setLocation(x, r.y);
                p1.setLocation(x, r.y + r.height);
            }
        } else {
            Orientation socketOrientation = socketFigure.determine2WayOrientation(false);
            boolean leftToRight = socketOrientation == Orientation.LEFT ^ isExit;
            int y = r.y + r.height / 2;
            if (leftToRight) {
                p1.setLocation(r.x, y);
                p2.setLocation(r.x + r.width, y);
            } else {
                p2.setLocation(r.x, y);
                p1.setLocation(r.x + r.width, y);
            }
        }
    }

    public boolean canConnect() {
        return false;
    }

    public void release() {
        super.release();
        this.paramFigure.removeProcessVariableConnection();
    }

    @Override
    public ProcessObject getProcessElement() {
        return this.dataLink;
    }

    @Override
    public ProcessObject getReferredProcessElement() {
        return this.getProcessElement();
    }

    @Override
    public Figure selectionOnDelete() {
        return null;
    }

    @Override
    public void setDrawing(ProcessDrawing drawing) {
    }

    @Override
    public ProcessDrawing getDrawing() {
        return this.paramFigure.getDrawing();
    }

    @Override
    public VisualElement getParentElement() {
        return this.paramFigure;
    }

    @Override
    public Figure getPresentationFigure() {
        return this;
    }

    @Override
    public void updatePresentationFigure() {
    }

    @Override
    public boolean isVisible() {
        return false;
    }

    @Override
    public void setVisible(boolean visible) {
    }

    @Override
    public boolean handleEvent(VisualElementEvent event) {
        return false;
    }

    @Override
    public List getDropRegions(List flavors, Transferable data, MouseEvent mouseEvent) {
        return null;
    }

    @Override
    public List getImportersAt(Point p) {
        return null;
    }

    @Override
    public List getAllImportersAt(Point p) {
        return null;
    }

    @Override
    public List getAllDropRegions(List flavors, Transferable data, MouseEvent mouseEvent) {
        return null;
    }

    @Override
    public boolean importData(Object regionId, Transferable data, Point p) {
        return false;
    }

    @Override
    public void dragStarted(Transferable transferable) {
    }

    @Override
    public void dragEnded(Transferable transferable) {
    }

    @Override
    public void dragActionTriggered(Object regionId, Point p) {
    }

    @Override
    public List getSubClients() {
        return null;
    }

    @Override
    public void updateFigure() {
    }
}

