/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.modeler.figures.spline;

import CH.ifa.draw.framework.Connector;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.standard.AbstractHandle;
import CH.ifa.draw.util.Geom;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import org.openbp.cockpit.modeler.AutoConnector;
import org.openbp.cockpit.modeler.ModelerColors;
import org.openbp.cockpit.modeler.drawing.WorkspaceDrawingView;
import org.openbp.cockpit.modeler.figures.process.ParamConnection;
import org.openbp.cockpit.modeler.figures.spline.PolySplineConnection;
import org.openbp.cockpit.modeler.util.FigureResources;
import org.openbp.cockpit.modeler.util.InputState;
import org.openbp.core.model.item.process.DataLink;
import org.openbp.core.model.item.process.DataLinkImpl;
import org.openbp.core.model.item.process.Param;
import org.openbp.jaspira.decoration.DecorationMgr;
import org.openbp.jaspira.decoration.Decorator;
import org.openbp.jaspira.decoration.FilteredDecorator;

public abstract class ChangeConnectionHandle
extends AbstractHandle {
    protected PolySplineConnection connectionFigure;
    private Figure targetFigure;
    private Connector originalTarget;
    private Decorator canConnectDecorator = new CanConnectDecorator();

    protected ChangeConnectionHandle(Figure owner) {
        super(owner);
        this.connectionFigure = (PolySplineConnection)this.owner();
    }

    protected abstract void disconnect();

    protected abstract void connect(Connector var1);

    protected abstract void setPoint(int var1, int var2);

    protected abstract Connector target();

    protected Connector source() {
        if (this.target() == this.connectionFigure.getStartConnector()) {
            return this.connectionFigure.getEndConnector();
        }
        return this.connectionFigure.getStartConnector();
    }

    public void invokeStart(int x, int y, DrawingView view) {
        this.originalTarget = this.target();
        this.disconnect();
        DecorationMgr.addDecorator(null, "Figure.Overlay", this.canConnectDecorator);
        ((WorkspaceDrawingView)view).redraw();
    }

    public void invokeStep(int x, int y, int anchorX, int anchorY, DrawingView view) {
        Connector target;
        Point p = new Point(x, y);
        Figure figure = this.findConnectableFigure(x, y, view.drawing());
        if (figure != this.targetFigure) {
            if (this.targetFigure != null) {
                this.targetFigure.connectorVisibility(false);
            }
            this.targetFigure = figure;
            if (this.targetFigure != null) {
                this.targetFigure.connectorVisibility(true);
            }
        }
        if ((target = this.findConnectionTarget(p.x, p.y, view.drawing())) != null) {
            p = Geom.center((Rectangle)target.displayBox());
        }
        this.setPoint(p.x, p.y);
    }

    public void invokeEnd(int x, int y, int anchorX, int anchorY, DrawingView view) {
        ParamConnection paramConnection;
        DataLink dataLink;
        String newSourceMemberPath;
        DecorationMgr.removeDecorator(null, "Figure.Overlay", this.canConnectDecorator);
        ((WorkspaceDrawingView)view).redraw();
        Connector target = this.findConnectionTarget(x, y, view.drawing());
        if (target == null) {
            target = this.originalTarget;
        }
        this.setPoint(x, y);
        this.connect(target);
        if (this.connectionFigure instanceof ParamConnection && (newSourceMemberPath = DataLinkImpl.checkAutoConversion((Param)(dataLink = (paramConnection = (ParamConnection)this.connectionFigure).getDataLink()).getSourceParam(), (String)dataLink.getSourceMemberPath(), (Param)dataLink.getTargetParam(), (String)dataLink.getTargetMemberPath())) != null) {
            dataLink.setSourceMemberPath(newSourceMemberPath);
        }
        this.connectionFigure.layoutAndAdjustConnection();
        ((WorkspaceDrawingView)view).singleSelect(this.connectionFigure);
        if (this.targetFigure != null) {
            this.targetFigure.connectorVisibility(false);
            this.targetFigure = null;
        }
    }

    private Connector findConnectionTarget(int x, int y, Drawing drawing) {
        Figure target = this.findConnectableFigure(x, y, drawing);
        if (target != null && this.connectionFigure != null && target.canConnect() && !target.includes(this.source().owner()) && this.canLinkFigures(this.source().owner(), target)) {
            return target.connectorAt(x, y);
        }
        return null;
    }

    protected Connector findConnector(int x, int y, Figure figure) {
        return figure.connectorAt(x, y);
    }

    public void draw(Graphics g) {
        Rectangle r = this.displayBox();
        g.setColor(ModelerColors.HANDLE_ANGLE_FILL);
        g.fillRect(r.x, r.y, r.width, r.height);
        g.setColor(ModelerColors.HANDLE_ANGLE_BORDER);
        g.drawRect(r.x, r.y, r.width, r.height);
    }

    private Figure findConnectableFigure(int x, int y, Drawing drawing) {
        FigureEnumeration k = drawing.figures();
        while (k.hasMoreElements()) {
            Figure figure = k.nextFigure();
            if ((figure = figure.findFigureInside(x, y)) == null || figure.includes((Figure)this.connectionFigure) || !figure.canConnect()) continue;
            return figure;
        }
        return null;
    }

    public boolean canLinkFigures(Figure start, Figure target) {
        int flags = 0;
        if (InputState.isShiftDown()) {
            flags = 1;
        } else if (AutoConnector.getDataLinkAutoConnectorMode() >= 5) {
            flags = 2;
        }
        return this.connectionFigure.canConnectFigures(start, target, flags);
    }

    public class CanConnectDecorator
    extends FilteredDecorator {
        @Override
        public Object doDecorate(Object owner, String key, Object value) {
            return FigureResources.getAcceptOverlay(owner);
        }

        @Override
        public boolean qualifies(Object owner) {
            if (ChangeConnectionHandle.this.connectionFigure == null) {
                return false;
            }
            return ChangeConnectionHandle.this.canLinkFigures(ChangeConnectionHandle.this.source().owner(), (Figure)owner);
        }
    }
}

