/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.modeler.figures.spline;

import CH.ifa.draw.figures.LineDecoration;
import CH.ifa.draw.framework.ConnectionFigure;
import CH.ifa.draw.framework.Connector;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureChangeEvent;
import CH.ifa.draw.framework.Locator;
import CH.ifa.draw.standard.AbstractHandle;
import CH.ifa.draw.standard.AbstractLocator;
import CH.ifa.draw.util.Storable;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseEvent;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.openbp.cockpit.modeler.Modeler;
import org.openbp.cockpit.modeler.ModelerColors;
import org.openbp.cockpit.modeler.ModelerGraphics;
import org.openbp.cockpit.modeler.drawing.DrawingEditorPlugin;
import org.openbp.cockpit.modeler.drawing.ProcessDrawing;
import org.openbp.cockpit.modeler.figures.VisualElement;
import org.openbp.cockpit.modeler.figures.VisualElementEvent;
import org.openbp.cockpit.modeler.figures.generic.GeometryUtil;
import org.openbp.cockpit.modeler.figures.generic.MoveableTitleFigure;
import org.openbp.cockpit.modeler.figures.generic.Orientation;
import org.openbp.cockpit.modeler.figures.generic.UpdatableFigure;
import org.openbp.cockpit.modeler.figures.generic.XArrowTip;
import org.openbp.cockpit.modeler.figures.spline.ChangeConnectionEndHandle;
import org.openbp.cockpit.modeler.figures.spline.ChangeConnectionStartHandle;
import org.openbp.cockpit.modeler.figures.spline.ConstrainedControlPointHandle;
import org.openbp.cockpit.modeler.figures.spline.ControlPointHandle;
import org.openbp.cockpit.modeler.figures.spline.PolySplineFigure;
import org.openbp.cockpit.modeler.figures.spline.WayPointHandle;
import org.openbp.cockpit.modeler.figures.tag.TagConnector;
import org.openbp.cockpit.modeler.undo.ModelerUndoable;
import org.openbp.cockpit.modeler.util.FigureUtil;
import org.openbp.common.CommonUtil;
import org.openbp.jaspira.decoration.DecorationMgr;

public abstract class PolySplineConnection
extends PolySplineFigure
implements ConnectionFigure,
VisualElement,
UpdatableFigure {
    public static final Double NAN = new Double(Double.NaN);
    public static final String DECO_ANIMATION = "Line.Animation";
    private static final LineDecoration endDecoration = new XArrowTip(0.4, 15.0, 10.0);
    private static final LineDecoration animationDecoration = new XArrowTip(0.4, 10.0, -1.0);
    private Connector startConnector;
    private Connector endConnector;
    private SplineLocator textLocator;
    protected MoveableTitleFigure label;
    private ProcessDrawing drawing;
    private double startFactor = 0.3;
    private double endFactor = 0.3;
    private int visualStatus = 1;

    public PolySplineConnection(ProcessDrawing drawing) {
        this();
        this.setDrawing(drawing);
    }

    public PolySplineConnection() {
        this.setEndDecoration(endDecoration);
        this.setAnimationDecoration(animationDecoration);
        this.textLocator = new SplineLocator();
        this.label = new MoveableTitleFigure();
        this.label.connect(this);
    }

    public abstract boolean canConnectFigures(Figure var1, Figure var2, int var3);

    public boolean canConnect(Figure startFigure, Figure endFigure) {
        return this.canConnectFigures(startFigure, endFigure, 0);
    }

    public void connectStart(Connector startConnector) {
        this.startConnector = startConnector;
        this.addStartConnectorChangeListener();
        if (this.endConnector != null) {
            this.handleConnect(this.startFigure(), this.endFigure());
        }
    }

    public void connectEnd(Connector endConnector) {
        this.endConnector = endConnector;
        this.addEndConnectorChangeListener();
        if (this.shouldReverse(this.startFigure(), this.endFigure())) {
            Connector swap = this.startConnector;
            this.startConnector = this.endConnector;
            this.endConnector = swap;
        }
        this.layoutConnection();
        this.handleConnect(this.startFigure(), this.endFigure());
    }

    public void disconnectStart() {
        this.handleDisconnect(this.startFigure(), this.endFigure());
        this.removeStartConnectorChangeListener();
        this.startConnector = null;
    }

    public void disconnectEnd() {
        this.handleDisconnect(this.startFigure(), this.endFigure());
        this.removeEndConnectorChangeListener();
        this.endConnector = null;
    }

    public abstract boolean connectsSame(ConnectionFigure var1);

    public void updateConnection() {
        this.layoutConnection();
    }

    protected void setStartConnector(Connector startConnector) {
        this.startConnector = startConnector;
    }

    public Connector getStartConnector() {
        return this.startConnector;
    }

    protected void setEndConnector(Connector endConnector) {
        this.endConnector = endConnector;
    }

    public Connector getEndConnector() {
        return this.endConnector;
    }

    public void startPoint(int x, int y) {
        if (this.segments.size() == 0) {
            this.willChange();
            this.segments.add(new CubicCurve2D.Double(x, y, x, y, x, y, x, y));
            this.changed();
        } else {
            this.setPointAt(0, new Point(x, y));
        }
    }

    public Point startPoint() {
        Point2D p = this.getPointAt(0);
        return new Point(CommonUtil.rnd((double)p.getX()), CommonUtil.rnd((double)p.getY()));
    }

    public void endPoint(int x, int y) {
        this.setPointAt(this.segments.size(), new Point(x, y));
    }

    public Point endPoint() {
        Point2D p = this.getPointAt(this.segments.size());
        return new Point(CommonUtil.rnd((double)p.getX()), CommonUtil.rnd((double)p.getY()));
    }

    public Figure startFigure() {
        if (this.startConnector != null) {
            return this.startConnector.owner();
        }
        return null;
    }

    public Figure endFigure() {
        if (this.endConnector != null) {
            return this.endConnector.owner();
        }
        return null;
    }

    @Override
    protected Point2D constrainCtrlPoint(int index, int side, Point2D ctrl) {
        if (index == 0 && side == 1 && this.startFigure() != null || index == this.segments.size() && side == 0 && this.endFigure() != null) {
            Orientation orientation;
            Point2D start = this.getPointAt(index);
            Point2D end = this.getPointAt(index == 0 ? 1 : this.segments.size() - 1);
            double xdiff = start.getX() - end.getX();
            xdiff *= xdiff;
            double ydiff = start.getY() - end.getY();
            ydiff *= ydiff;
            double distance = Math.sqrt(xdiff + ydiff);
            if (index == 0) {
                distance *= this.getStartFactor();
                orientation = ((TagConnector)this.getStartConnector()).getOrientation();
            } else {
                distance *= this.getEndFactor();
                orientation = ((TagConnector)this.getEndConnector()).getOrientation();
            }
            switch (orientation) {
                case TOP: {
                    distance = -distance;
                }
                case BOTTOM: {
                    ctrl.setLocation(start.getX(), start.getY() + distance);
                    break;
                }
                case LEFT: {
                    distance = -distance;
                }
                case RIGHT: {
                    ctrl.setLocation(start.getX() + distance, start.getY());
                }
            }
        }
        return ctrl;
    }

    @Override
    protected void basicMoveBy(int dx, int dy) {
        super.basicMoveBy(dx, dy);
        this.layoutConnection();
    }

    @Override
    public Rectangle displayBox() {
        return super.displayBox().union(this.label.displayBox());
    }

    @Override
    protected void drawSpline(Graphics2D g2) {
        if (this.isVisible() && !this.isMinimized()) {
            super.drawSpline(g2);
            this.label.draw(g2);
        }
    }

    @Override
    protected void drawDecorations(Graphics g) {
        if (this.isVisible() && !this.isMinimized()) {
            double pos;
            super.drawDecorations(g);
            if (this.getAnimationDecoration() != null && (pos = ((Double)DecorationMgr.decorate(this, DECO_ANIMATION, NAN)).doubleValue()) >= 0.0 && pos <= 1.0) {
                Point2D p = this.getPointOnCurve(pos);
                g.fillOval(CommonUtil.rnd((double)p.getX()) - 4, CommonUtil.rnd((double)p.getY()) - 4, 8, 8);
            }
        }
    }

    @Override
    public boolean containsPoint(int x, int y) {
        if (!this.isVisible() || this.isMinimized()) {
            return false;
        }
        return this.label.containsPoint(x, y) || super.containsPoint(x, y);
    }

    @Override
    public Vector handles() {
        int i;
        Vector<AbstractHandle> handles = new Vector<AbstractHandle>(this.segments.size() * 3 + 1);
        int max = this.segments.size();
        handles.add(new ConstrainedControlPointHandle(this, 0, 1));
        for (i = 1; i < max; ++i) {
            handles.add(new ControlPointHandle(this, i, 0));
            handles.add(new ControlPointHandle(this, i, 1));
        }
        handles.add(new ConstrainedControlPointHandle(this, max, max - 1));
        handles.addElement(new ChangeConnectionStartHandle(this));
        handles.addElement(new ChangeConnectionEndHandle(this));
        for (i = 1; i < max; ++i) {
            handles.add(new WayPointHandle(this, i));
        }
        handles.add(new MoveLableHandle());
        return handles;
    }

    public void setPointAt(Point p, int i) {
        super.setPointAt(i, p);
        this.layoutConnection();
    }

    public Locator connectedTextLocator(Figure figure) {
        return this.textLocator;
    }

    public void release() {
        super.release();
        this.handleDisconnect(this.startFigure(), this.endFigure());
        this.removeStartConnectorChangeListener();
        this.removeEndConnectorChangeListener();
    }

    protected boolean shouldReverse(Figure startFigure, Figure endFigure) {
        return false;
    }

    protected void handleConnect(Figure startFigure, Figure endFigure) {
    }

    protected void handleDisconnect(Figure startFigure, Figure endFigure) {
    }

    protected void addStartConnectorChangeListener() {
    }

    protected void removeStartConnectorChangeListener() {
    }

    protected void addEndConnectorChangeListener() {
    }

    protected void removeEndConnectorChangeListener() {
    }

    public double getStartFactor() {
        return this.startFactor;
    }

    public void setStartFactor(double startFactor) {
        this.startFactor = startFactor;
        this.layoutConnection();
    }

    public double getEndFactor() {
        return this.endFactor;
    }

    public void setEndFactor(double endFactor) {
        this.endFactor = endFactor;
        this.layoutConnection();
    }

    public MoveableTitleFigure getLabel() {
        return this.label;
    }

    public boolean isMinimized() {
        return false;
    }

    public void layoutConnection() {
        Point end;
        Point start;
        if (this.startConnector != null && (start = this.startConnector.findStart((ConnectionFigure)this)) != null) {
            this.startPoint(start.x, start.y);
        }
        if (this.endConnector != null && (end = this.endConnector.findEnd((ConnectionFigure)this)) != null) {
            this.endPoint(end.x, end.y);
        }
        this.clearShapeCache();
    }

    public void layoutAndAdjustConnection() {
        this.layoutConnection();
    }

    public void figureChanged(FigureChangeEvent e) {
        this.layoutConnection();
    }

    public void figureRemoved(FigureChangeEvent e) {
    }

    public void figureRequestRemove(FigureChangeEvent e) {
    }

    public void figureInvalidated(FigureChangeEvent e) {
    }

    public void figureRequestUpdate(FigureChangeEvent e) {
    }

    public void decode(String geometry, String errName) {
        if (geometry == null) {
            return;
        }
        StringTokenizer tok = new StringTokenizer(geometry, "|");
        while (tok.hasMoreTokens()) {
            this.decodeParameter(tok.nextToken(), errName);
        }
        this.rebuildShapeCache();
    }

    protected boolean decodeParameter(String parameter, String errName) {
        StringTokenizer st = new StringTokenizer(parameter, ":");
        String name = st.nextToken();
        if (name.equals("points")) {
            int x = GeometryUtil.parseInt(st, "points", errName);
            this.segments.clear();
            for (int i = 0; i < x; ++i) {
                double x1 = GeometryUtil.parseDouble(st, "points", errName);
                double y1 = GeometryUtil.parseDouble(st, "points", errName);
                double x2 = GeometryUtil.parseDouble(st, "points", errName);
                double y2 = GeometryUtil.parseDouble(st, "points", errName);
                double x3 = GeometryUtil.parseDouble(st, "points", errName);
                double y3 = GeometryUtil.parseDouble(st, "points", errName);
                double x4 = GeometryUtil.parseDouble(st, "points", errName);
                double y4 = GeometryUtil.parseDouble(st, "points", errName);
                this.segments.add(new CubicCurve2D.Double(x1, y1, x2, y2, x3, y3, x4, y4));
            }
            return true;
        }
        if (name.equals("label")) {
            int x = GeometryUtil.parseInt(st, "label", errName);
            int y = GeometryUtil.parseInt(st, "label", errName);
            this.label.moveBy(x, y);
            return true;
        }
        if (name.equals("factors")) {
            this.startFactor = GeometryUtil.parseDouble(st, "factors", errName);
            this.endFactor = GeometryUtil.parseDouble(st, "factors", errName);
            return true;
        }
        return false;
    }

    protected String encode() {
        String result = "points:" + this.segments.size();
        for (CubicCurve2D next : this.segments) {
            result = result + ":" + FigureUtil.printInt(next.getX1()) + ":" + FigureUtil.printInt(next.getY1()) + ":" + FigureUtil.printInt(next.getCtrlX1()) + ":" + FigureUtil.printInt(next.getCtrlY1()) + ":" + FigureUtil.printInt(next.getCtrlX2()) + ":" + FigureUtil.printInt(next.getCtrlY2()) + ":" + FigureUtil.printInt(next.getX2()) + ":" + FigureUtil.printInt(next.getY2());
        }
        result = result + "|label:" + (this.label.center().x - this.textLocator.locate((Figure)this).x) + ":" + (this.label.center().y - this.textLocator.locate((Figure)this).y);
        result = result + "|factors:" + this.startFactor + ":" + this.endFactor;
        return result;
    }

    @Override
    public void setDrawing(ProcessDrawing drawing) {
        this.drawing = drawing;
    }

    @Override
    public ProcessDrawing getDrawing() {
        return this.drawing;
    }

    @Override
    public VisualElement getParentElement() {
        return this.getDrawing();
    }

    @Override
    public Figure getPresentationFigure() {
        return this;
    }

    @Override
    public void updatePresentationFigure() {
    }

    @Override
    public boolean isVisible() {
        return (this.visualStatus & 1) != 0;
    }

    @Override
    public void setVisible(boolean visible) {
        this.willChange();
        this.visualStatus = visible ? (this.visualStatus |= 1) : (this.visualStatus &= 0xFFFFFFFE);
        this.changed();
    }

    @Override
    public boolean handleEvent(VisualElementEvent event) {
        if (event.type == "DoubleClick") {
            DrawingEditorPlugin editor = this.getDrawing().getEditor();
            editor.startUndo("Remove Link Control Point");
            if (!this.joinSegments(event.x, event.y)) {
                this.splitSegment(event.x, event.y);
                ModelerUndoable undoable = (ModelerUndoable)((Modeler)editor).getCurrentUndoable();
                undoable.setDisplayName("Add Link Control Point");
            }
            editor.view().toggleSelection((Figure)this);
            editor.view().toggleSelection((Figure)this);
            editor.endUndo();
            this.layoutConnection();
            return true;
        }
        return false;
    }

    @Override
    public void updateFigure() {
        this.label.updateFigure();
    }

    @Override
    public void dragActionTriggered(Object regionId, Point p) {
    }

    @Override
    public void dragEnded(Transferable transferable) {
    }

    @Override
    public void dragStarted(Transferable transferable) {
    }

    @Override
    public List getAllDropRegions(List flavors, Transferable data, MouseEvent mouseEvent) {
        return this.getDropRegions(flavors, data, mouseEvent);
    }

    @Override
    public List getDropRegions(List flavors, Transferable data, MouseEvent mouseEvent) {
        return null;
    }

    @Override
    public List getImportersAt(Point p) {
        return null;
    }

    @Override
    public List getAllImportersAt(Point p) {
        return this.getImportersAt(p);
    }

    @Override
    public List getSubClients() {
        return null;
    }

    @Override
    public boolean importData(Object regionId, Transferable data, Point p) {
        return false;
    }

    @Override
    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeStorable((Storable)this.startConnector);
        dw.writeStorable((Storable)this.endConnector);
    }

    @Override
    public void read(StorableInput dr) throws IOException {
        Connector end;
        super.read(dr);
        Connector start = (Connector)dr.readStorable();
        if (start != null) {
            this.connectStart(start);
        }
        if ((end = (Connector)dr.readStorable()) != null) {
            this.connectEnd(end);
        }
        if (start != null && end != null) {
            this.layoutConnection();
        }
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        if (this.startConnector != null) {
            this.connectStart(this.startConnector);
        }
        if (this.endConnector != null) {
            this.connectEnd(this.endConnector);
        }
    }

    class MoveLableHandle
    extends AbstractHandle {
        int lastX;
        int lastY;

        public MoveLableHandle() {
            super((Figure)PolySplineConnection.this);
        }

        public void invokeStart(int x, int y, Drawing drawing) {
            this.lastX = x;
            this.lastY = y;
        }

        public void invokeStep(int x, int y, int ax, int ay, DrawingView view) {
            PolySplineConnection.this.willChange();
            PolySplineConnection.this.label.moveBy(x - this.lastX, y - this.lastY);
            this.lastX = x;
            this.lastY = y;
            PolySplineConnection.this.changed();
        }

        public Point locate() {
            return PolySplineConnection.this.label.displayBox().getLocation();
        }

        public void draw(Graphics g) {
            super.draw(g);
            Graphics2D g2 = (Graphics2D)g;
            Point p1 = PolySplineConnection.this.textLocator.locate(PolySplineConnection.this);
            Point p2 = this.locate();
            Stroke old = g2.getStroke();
            g2.setStroke(ModelerGraphics.labelHandleStroke);
            Color olc = g.getColor();
            g.setColor(ModelerColors.LABEL_HANDLE_LINE);
            g.drawLine(p1.x, p1.y, p2.x, p2.y);
            g2.setStroke(old);
            g.setColor(olc);
        }
    }

    class SplineLocator
    extends AbstractLocator {
        private double position = 0.5;

        public Point locate(Figure figure) {
            Point2D p = PolySplineConnection.this.getPointOnCurve(this.position);
            return new Point(CommonUtil.rnd((double)p.getX()), CommonUtil.rnd((double)p.getY()));
        }

        public double getPosition() {
            return this.position;
        }

        public void setPosition(double position) {
            this.position = position;
        }
    }
}

