/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.modeler.figures.tag;

import CH.ifa.draw.framework.Connector;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureChangeListener;
import CH.ifa.draw.standard.CompositeFigure;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import org.openbp.cockpit.modeler.ViewModeMgr;
import org.openbp.cockpit.modeler.drawing.ProcessDrawing;
import org.openbp.cockpit.modeler.figures.VisualElement;
import org.openbp.cockpit.modeler.figures.VisualElementEvent;
import org.openbp.cockpit.modeler.figures.generic.ChildFigure;
import org.openbp.cockpit.modeler.figures.generic.CircleConstants;
import org.openbp.cockpit.modeler.figures.generic.Expandable;
import org.openbp.cockpit.modeler.figures.generic.Orientation;
import org.openbp.cockpit.modeler.figures.generic.Quarter;
import org.openbp.cockpit.modeler.figures.generic.ShadowDropper;
import org.openbp.cockpit.modeler.figures.generic.UpdatableFigure;
import org.openbp.cockpit.modeler.figures.generic.XFigure;
import org.openbp.cockpit.modeler.figures.layouter.HorizontalLayouter;
import org.openbp.cockpit.modeler.figures.layouter.LayoutableTag;
import org.openbp.cockpit.modeler.figures.layouter.TagLayouter;
import org.openbp.cockpit.modeler.skins.SymbolDescriptor;
import org.openbp.cockpit.modeler.util.FigureUtil;
import org.openbp.common.CollectionUtil;
import org.openbp.common.util.ToStringHelper;
import org.openbp.jaspira.decoration.DecorationMgr;
import org.openbp.jaspira.gui.interaction.DropClientUtil;
import org.openbp.jaspira.gui.interaction.InteractionClient;

public abstract class AbstractTagFigure
extends CompositeFigure
implements LayoutableTag,
FigureChangeListener,
ShadowDropper,
Expandable,
ChildFigure,
VisualElement,
UpdatableFigure {
    public static final String DECO_TAGCONTENTTYPE = "Tag.ContentType";
    public static final int CONTENT_ICON = 1;
    public static final int CONTENT_TEXT = 2;
    public static final int CONTENT_FLOW = 4;
    public static final int CONTENT_DATA = 8;
    public static final int CONTENT_USER1 = 16;
    public static final int CONTENT_USER2 = 32;
    public static final int CONTENT_INTERACTION = 12;
    public static final int CONTENT_STATIC = 3;
    protected VisualElement parent;
    protected XFigure presentationFigure;
    protected Figure shadowFigure;
    protected List content;
    protected TagLayouter layouter;
    protected double angle;
    protected Point origin;
    protected int contentState;
    protected int currentContentState;
    protected int visualStatus = 1;

    public AbstractTagFigure(VisualElement parent, Object modelObject) {
        this.parent = parent;
        this.origin = parent.center();
        this.contentState = this.getDrawing().isDisplayAll() ? 15 : 3 | ViewModeMgr.getInstance().getTagState(this);
        this.content = new ArrayList();
        this.initPresentationFigure();
        this.initTagLayouter();
        this.initContent(modelObject);
        this.applyContentState();
    }

    protected void initPresentationFigure() {
        this.presentationFigure = this.createPresentationFigure();
        this.presentationFigure.setParent(this);
        this.initShadow();
    }

    protected XFigure createPresentationFigure() {
        SymbolDescriptor desc = this.getDrawing().getProcessSkin().getSymbolDescriptor("Tag");
        return desc.createFigure();
    }

    protected void initShadow() {
        this.shadowFigure = FigureUtil.createShadowFigure(this.presentationFigure);
    }

    protected void initTagLayouter() {
        this.layouter = new HorizontalLayouter(this);
    }

    protected void initContent(Object modelObject) {
    }

    public List getContent() {
        return this.content;
    }

    public void addContent(Figure newFigure, int type) {
        TagContent tagContent = new TagContent(newFigure, type);
        this.content.add(tagContent);
    }

    public void addContentAt(Figure newFigure, int index, int type) {
        TagContent tagContent = new TagContent(newFigure, type);
        this.content.add(index, tagContent);
    }

    public void moveContent(int oldIndex, int newIndex) {
        this.content.add(newIndex, this.content.remove(oldIndex));
        this.applyContentState();
    }

    public int getNumberOfContents() {
        return this.content.size();
    }

    public Figure getContentFigureAt(int pos) {
        return ((TagContent)this.content.get(pos)).getFigure();
    }

    public void checkDecoratedContentState() {
        int decoratedContentState = this.determineDecoratedContentState();
        if (decoratedContentState != this.currentContentState) {
            this.applyContentState();
        }
    }

    public void applyContentState() {
        int decoratedContentState;
        this.willChange();
        this.removeAll();
        this.currentContentState = decoratedContentState = this.determineDecoratedContentState();
        for (TagContent content : this.content) {
            if ((decoratedContentState & content.getContentType()) == 0) continue;
            this.add(content.figure);
        }
        this.layoutTag();
    }

    public void setContentState(int contentState) {
        this.contentState = contentState;
        this.applyContentState();
    }

    public int getContentState() {
        return this.contentState;
    }

    public int determineDecoratedContentState() {
        Integer stateObject = new Integer(this.getContentState());
        stateObject = (Integer)DecorationMgr.decorate(this, DECO_TAGCONTENTTYPE, stateObject);
        int state = stateObject;
        return state;
    }

    public boolean isVerticalOrientation() {
        return this.layouter != null ? this.layouter.isVerticalLayouter() : true;
    }

    public void basicDisplayBox(Point origin, Point corner) {
        this.setOrigin(new Point(origin.x + (corner.x - origin.x) / 2, origin.y + (corner.y - origin.y) / 2));
    }

    protected void basicMoveBy(int dx, int dy) {
        this.origin.setLocation(this.origin.getX() + (double)dx, this.origin.getY() + (double)dy);
        super.basicMoveBy(dx, dy);
        this.presentationFigure.moveBy(dx, dy);
        if (this.shadowFigure != null) {
            this.shadowFigure.moveBy(dx, dy);
        }
    }

    public Vector handles() {
        return CollectionUtil.EMPTY_VECTOR;
    }

    public Connector connectorAt(int x, int y) {
        return null;
    }

    public Rectangle displayBox() {
        Rectangle box = new Rectangle(this.presentationFigure.displayBox());
        try {
            Iterator it = this.fFigures.iterator();
            while (it.hasNext()) {
                box = box.union(((Figure)it.next()).displayBox());
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
        return box;
    }

    public void draw(Graphics g) {
        if (this.isVisible()) {
            Graphics2D g2 = (Graphics2D)g;
            this.presentationFigure.draw(g2);
            super.draw((Graphics)g2);
            Figure overlay = (Figure)DecorationMgr.decorate(this, "Figure.Overlay", null);
            if (overlay != null) {
                overlay.draw(g);
            }
        }
    }

    public void changed() {
        super.changed();
        this.presentationFigure.changed();
    }

    public void invalidate() {
        if (this.getParent() != null) {
            this.getParent().invalidate();
        }
    }

    public boolean containsPoint(int x, int y) {
        return this.presentationFigure.containsPoint(x, y);
    }

    public boolean canConnect() {
        return false;
    }

    public Figure findFigure(int x, int y) {
        ListIterator lit = this.content.listIterator(this.content.size());
        while (lit.hasPrevious()) {
            TagContent tc = (TagContent)lit.previous();
            if ((tc.getContentType() & 0xC) == 0 || !tc.getFigure().containsPoint(x, y)) continue;
            return tc.getFigure();
        }
        return this.containsPoint(x, y) ? this : null;
    }

    public Figure findFigureInside(int x, int y) {
        ListIterator lit = this.content.listIterator(this.content.size());
        while (lit.hasPrevious()) {
            TagContent tc = (TagContent)lit.previous();
            if ((tc.getContentType() & 0xC) == 0 || !tc.getFigure().containsPoint(x, y)) continue;
            return tc.getFigure().findFigureInside(x, y);
        }
        return this.containsPoint(x, y) ? this : null;
    }

    @Override
    public void layoutTag() {
        this.willChange();
        this.angle = CircleConstants.normalizeAngle(this.angle);
        this.layouter.determineDirection();
        Rectangle rect = this.layouter.calculateSize();
        rect = this.positionDisplayBox(rect);
        this.presentationFigure.displayBox(rect);
        if (this.shadowFigure != null) {
            this.shadowFigure.displayBox(rect);
        }
        this.layouter.performLayout(rect);
        this.changed();
    }

    @Override
    public TagLayouter getLayouter() {
        return this.layouter;
    }

    @Override
    public void setLayouter(TagLayouter layouter) {
        this.layouter = layouter;
    }

    protected Rectangle positionDisplayBox(Rectangle rect) {
        return rect;
    }

    public Point getOrigin() {
        return this.origin;
    }

    public void setOrigin(Point origin) {
        this.origin = new Point(origin);
        this.layoutTag();
    }

    public double getAngle() {
        return this.angle;
    }

    public void setAngle(double angle) {
        this.willChange();
        angle = CircleConstants.normalizeAngle(angle);
        this.basicSetAngle(angle);
        this.moveBy(0, 0);
        this.layoutTag();
    }

    public Figure getCenterFigure() {
        ChildFigure cf;
        VisualElement centerFigure = this.parent;
        while (centerFigure != null && centerFigure instanceof ChildFigure && (cf = (ChildFigure)((Object)centerFigure)).getParent() != null) {
            centerFigure = cf.getParent();
        }
        return centerFigure;
    }

    protected void basicSetAngle(double angle) {
        this.angle = angle;
    }

    public Orientation determine2WayOrientation(boolean vertical) {
        Rectangle centerBox = this.getCenterFigureBox();
        Quarter quarter = CircleConstants.determineQuarter(this.angle, centerBox);
        Orientation orientation = vertical ? (quarter == Quarter.NW || quarter == Quarter.NE ? Orientation.TOP : Orientation.BOTTOM) : (quarter == Quarter.SW || quarter == Quarter.NW ? Orientation.LEFT : Orientation.RIGHT);
        return orientation;
    }

    public Rectangle getCenterFigureBox() {
        Rectangle centerBox = null;
        Figure centerFigure = this.getCenterFigure();
        if (centerFigure != null) {
            centerBox = centerFigure instanceof Expandable ? ((Expandable)centerFigure).compactDisplayBox() : centerFigure.displayBox();
        }
        return centerBox;
    }

    @Override
    public Rectangle compactDisplayBox() {
        return this.presentationFigure.displayBox();
    }

    @Override
    public void setDrawing(ProcessDrawing processDrawing) {
    }

    @Override
    public ProcessDrawing getDrawing() {
        return this.parent.getDrawing();
    }

    @Override
    public VisualElement getParentElement() {
        return this.parent;
    }

    @Override
    public Figure getPresentationFigure() {
        return this.presentationFigure;
    }

    @Override
    public void updatePresentationFigure() {
        Rectangle db = null;
        if (this.presentationFigure != null) {
            this.presentationFigure.willChange();
            db = this.presentationFigure.displayBox();
        }
        this.initPresentationFigure();
        if (db != null) {
            this.presentationFigure.displayBox(db);
        }
        this.layoutTag();
        this.presentationFigure.changed();
    }

    @Override
    public boolean isVisible() {
        return (this.visualStatus & 1) != 0;
    }

    @Override
    public void setVisible(boolean visible) {
        this.willChange();
        this.visualStatus = visible ? (this.visualStatus |= 1) : (this.visualStatus &= 0xFFFFFFFE);
        Iterator it = this.content.iterator();
        while (it.hasNext()) {
            Figure fig = ((TagContent)it.next()).getFigure();
            if (!(fig instanceof VisualElement)) continue;
            ((VisualElement)fig).setVisible(visible);
        }
        this.changed();
    }

    public int getVisualStatus() {
        return this.visualStatus;
    }

    public void setVisualStatus(int visualStatus) {
        this.visualStatus = visualStatus;
    }

    @Override
    public boolean handleEvent(VisualElementEvent event) {
        Figure f;
        if (event.type == "DoubleClick" && (f = this.findFigure(event.x, event.y)) != this && f instanceof VisualElement) {
            return ((VisualElement)f).handleEvent(event);
        }
        return false;
    }

    @Override
    public void updateFigure() {
        if (this.presentationFigure instanceof UpdatableFigure) {
            ((UpdatableFigure)((Object)this.presentationFigure)).updateFigure();
        }
        Iterator it = this.content.iterator();
        while (it.hasNext()) {
            Figure next = ((TagContent)it.next()).getFigure();
            if (!(next instanceof UpdatableFigure)) continue;
            ((UpdatableFigure)next).updateFigure();
        }
        this.applyContentState();
    }

    @Override
    public Figure getParent() {
        return this.parent;
    }

    @Override
    public void setParent(Figure parent) {
    }

    @Override
    public Figure getShadow() {
        return this.isVisible() ? this.shadowFigure : null;
    }

    public void setFillColor(Color color) {
        this.presentationFigure.setFillColor(color);
    }

    public Color getFillColor() {
        return this.presentationFigure.getFillColor();
    }

    public void read(StorableInput dr) {
    }

    public void write(StorableOutput dw) {
    }

    @Override
    public void dragActionTriggered(Object regionId, Point p) {
    }

    @Override
    public void dragStarted(Transferable transferable) {
        DropClientUtil.dragStarted(this, transferable);
    }

    @Override
    public void dragEnded(Transferable transferable) {
        DropClientUtil.dragEnded(this, transferable);
    }

    @Override
    public List getAllDropRegions(List flavors, Transferable data, MouseEvent mouseEvent) {
        return DropClientUtil.getAllDropRegions(this, flavors, data, mouseEvent);
    }

    @Override
    public List getDropRegions(List flavors, Transferable data, MouseEvent mouseEvent) {
        return null;
    }

    @Override
    public List getImportersAt(Point p) {
        return null;
    }

    @Override
    public List getAllImportersAt(Point p) {
        return DropClientUtil.getAllImportersAt(this, p);
    }

    @Override
    public List getSubClients() {
        return FigureUtil.getTypedFigureList(this, InteractionClient.class);
    }

    @Override
    public boolean importData(Object regionId, Transferable data, Point p) {
        return false;
    }

    public class TagContent {
        protected Figure figure;
        protected int type;

        public TagContent(Figure figure, int type) {
            this.figure = figure;
            this.type = type;
        }

        public String toString() {
            return ToStringHelper.toString((Object)this, (String)"figure");
        }

        public Figure getFigure() {
            return this.figure;
        }

        public void setFigure(Figure figure) {
            this.figure = figure;
        }

        public int getContentType() {
            return this.type;
        }

        public void setContentType(int type) {
            this.type = type;
        }
    }
}

