/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.modeler.figures.tag;

import CH.ifa.draw.framework.ConnectionFigure;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.standard.AbstractConnector;
import java.awt.Point;
import java.awt.Rectangle;
import org.openbp.cockpit.modeler.drawing.WorkspaceDrawingView;
import org.openbp.cockpit.modeler.figures.generic.ChildFigure;
import org.openbp.cockpit.modeler.figures.generic.Orientation;
import org.openbp.cockpit.modeler.figures.process.SocketFigure;
import org.openbp.cockpit.modeler.figures.tag.AbstractTagFigure;

public class TagConnector
extends AbstractConnector {
    private AbstractTagFigure connectorFigure;
    private SocketFigure socketFigure;
    private Orientation lockedOrientation = Orientation.UNDETERMINED;

    public TagConnector(AbstractTagFigure connectorFigure) {
        super((Figure)connectorFigure);
        this.connectorFigure = connectorFigure;
        AbstractTagFigure f = connectorFigure;
        while (f != null) {
            if (f instanceof SocketFigure) {
                this.socketFigure = (SocketFigure)f;
                break;
            }
            if (f instanceof ChildFigure) {
                f = ((ChildFigure)f).getParent();
                continue;
            }
            f = null;
        }
    }

    protected Point findPoint(ConnectionFigure connection) {
        Orientation direction = this.getOrientation();
        Rectangle cb = this.connectorFigure.compactDisplayBox();
        if (!this.connectorFigure.isVerticalOrientation()) {
            return new Point((int)(direction == Orientation.LEFT ? cb.getMinX() : cb.getMaxX()), (int)cb.getCenterY());
        }
        return new Point((int)cb.getCenterX(), (int)(direction == Orientation.TOP ? cb.getMinY() : cb.getMaxY()));
    }

    public SocketFigure getSocketFigure() {
        return this.socketFigure;
    }

    public Orientation getOrientation() {
        Orientation lo = this.getLockedOrientation();
        if (lo != Orientation.UNDETERMINED) {
            return lo;
        }
        return this.socketFigure.determine2WayOrientation(this.connectorFigure.isVerticalOrientation());
    }

    public boolean isOrientationLocked() {
        return this.lockedOrientation != Orientation.UNDETERMINED;
    }

    public void toggleOrientationLock() {
        Orientation lo = this.getLockedOrientation();
        lo = lo == Orientation.UNDETERMINED ? this.connectorFigure.determine2WayOrientation(this.connectorFigure.isVerticalOrientation()) : Orientation.UNDETERMINED;
        this.setLockedOrientation(lo);
        this.updateOrientation();
    }

    public void flipOrientation() {
        Orientation lo;
        if (!this.isOrientationLocked()) {
            this.toggleOrientationLock();
        }
        if ((lo = this.getLockedOrientation()) == Orientation.TOP) {
            lo = Orientation.BOTTOM;
        } else if (lo == Orientation.BOTTOM) {
            lo = Orientation.TOP;
        } else if (lo == Orientation.LEFT) {
            lo = Orientation.RIGHT;
        } else if (lo == Orientation.RIGHT) {
            lo = Orientation.LEFT;
        }
        this.setLockedOrientation(lo);
        this.updateOrientation();
    }

    public Orientation getLockedOrientation() {
        Orientation ret = this.lockedOrientation;
        switch (this.lockedOrientation) {
            case UNDETERMINED: {
                break;
            }
            case RIGHT: {
                if (!this.connectorFigure.isVerticalOrientation()) break;
                ret = Orientation.BOTTOM;
                break;
            }
            case BOTTOM: {
                if (this.connectorFigure.isVerticalOrientation()) break;
                ret = Orientation.RIGHT;
                break;
            }
            case LEFT: {
                if (!this.connectorFigure.isVerticalOrientation()) break;
                ret = Orientation.TOP;
                break;
            }
            case TOP: {
                if (this.connectorFigure.isVerticalOrientation()) break;
                ret = Orientation.LEFT;
            }
        }
        return ret;
    }

    public void setLockedOrientation(Orientation lockedOrientation) {
        this.lockedOrientation = lockedOrientation;
    }

    public void updateOrientation() {
        WorkspaceDrawingView view;
        this.socketFigure.changed();
        if (this.socketFigure.getDrawing() != null && (view = this.socketFigure.getDrawing().getView()) != null) {
            view.checkDamage();
        }
    }
}

