/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.modeler.paramvaluewizard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import org.openbp.cockpit.modeler.paramvaluewizard.ParamValueWizard;
import org.openbp.cockpit.modeler.paramvaluewizard.ParamValueWizardPart;
import org.openbp.core.model.item.process.NodeParam;
import org.openbp.guiclient.plugins.displayobject.DisplayObjectPlugin;
import org.openbp.jaspira.gui.wizard.JaspiraWizardPage;
import org.openbp.swing.components.wizard.Wizard;
import org.openbp.swing.plaf.sky.SkyTheme;

public class ParamValuePage
extends JaspiraWizardPage
implements ParamValueWizardPart {
    private NodeParam param;
    private String expression;
    private JPanel valuePanel;

    public ParamValuePage(ParamValueWizard wizard, NodeParam param) {
        super((Wizard)wizard);
        this.param = param;
        this.expression = param.getExpression();
        if (this.expression != null && this.expression.startsWith("\"") && this.expression.endsWith("\"")) {
            this.expression = this.expression.substring(1);
            this.expression = this.expression.substring(0, this.expression.length() - 1);
        }
        JPanel cp = this.getContentPanel();
        cp.setBackground(SkyTheme.COLOR_BACKGROUND_LIGHT);
        this.valuePanel = new JPanel(new BorderLayout());
        this.valuePanel.setBackground(cp.getBackground());
        this.valuePanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        JPanel textPanel = new JPanel(new BorderLayout());
        textPanel.setBackground(cp.getBackground());
        JPanel namePanel = new JPanel(new FlowLayout(0));
        namePanel.setBackground(cp.getBackground());
        JLabel label = new JLabel(wizard.getResource().getRequiredString("wizard.page.name") + " ");
        Font font = label.getFont();
        font = font.deriveFont(14.0f);
        label.setFont(font);
        namePanel.add(label);
        String name = DisplayObjectPlugin.getInstance().isTitleModeText() ? param.getDisplayText() : param.getName();
        label = new JLabel(name);
        font = label.getFont();
        font = font.deriveFont(1, 14.0f);
        label.setFont(font);
        namePanel.add(label);
        if (!param.isOptional()) {
            label = new JLabel(" " + wizard.getResource().getRequiredString("wizard.page.required"));
            font = label.getFont();
            font = font.deriveFont(14.0f);
            label.setFont(font);
            namePanel.add(label);
        }
        textPanel.add((Component)namePanel, "North");
        String description = param.getDescription();
        if (description != null) {
            JTextArea descriptionText = new JTextArea(description);
            descriptionText.setEditable(false);
            descriptionText.setBackground(cp.getBackground());
            JScrollPane sp = new JScrollPane(descriptionText);
            sp.setBackground(cp.getBackground());
            sp.setBorder(new EmptyBorder(0, 5, 5, 5));
            sp.setMaximumSize(new Dimension(10000, 200));
            textPanel.add((Component)sp, "Center");
        }
        cp.add((Component)textPanel, "North");
        cp.add((Component)this.valuePanel, "Center");
        this.canMoveForward = true;
        this.canFinish = true;
    }

    @Override
    public void apply() {
        this.param.setExpression(this.expression);
    }

    public JPanel getValuePanel() {
        return this.valuePanel;
    }

    public NodeParam getParam() {
        return this.param;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }
}

