/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.modeler.skins;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import org.openbp.cockpit.modeler.figures.generic.XFigureDescriptor;
import org.openbp.cockpit.modeler.skins.LinkDescriptor;
import org.openbp.cockpit.modeler.skins.SymbolDescriptor;
import org.openbp.common.generic.description.DisplayObjectImpl;
import org.openbp.common.rc.ResourceCollection;
import org.openbp.common.rc.ResourceCollectionMgr;
import org.openbp.core.model.item.process.ProcessItem;

public class Skin
extends DisplayObjectImpl {
    private String resourceName;
    private Boolean controlAnchorVisible;
    private Boolean controlLinkVisible;
    private Boolean dataLinkVisible;
    private Boolean nameDisplay;
    private boolean radialTags;
    private boolean disableShadows;
    private boolean defaultSkin;
    private String paramTitleFormat;
    private String socketTitleFormat;
    private String nodeTitleFormat;
    private Map symbolDescriptors = new LinkedHashMap();
    private Map linkDescriptors = new LinkedHashMap();
    private transient boolean valid;
    private ResourceCollection resourceCollection;

    public boolean validate(String descriptorDir, List errorMsgs) {
        boolean ret = true;
        for (Object desc : this.symbolDescriptors.values()) {
            if (((XFigureDescriptor)desc).validate(descriptorDir, errorMsgs)) continue;
            ret = false;
        }
        for (Object desc : this.linkDescriptors.values()) {
            if (((LinkDescriptor)desc).validate(descriptorDir, errorMsgs)) continue;
            ret = false;
        }
        this.valid = ret;
        return ret;
    }

    public boolean initialize(String skinResPath) {
        String resourceName = this.getResourceName();
        if (resourceName == null) {
            resourceName = this.getName();
        }
        this.resourceCollection = ResourceCollectionMgr.getDefaultInstance().getResource("skin", resourceName);
        boolean ret = true;
        for (Object desc : this.symbolDescriptors.values()) {
            String key;
            if (!((XFigureDescriptor)desc).initialize(skinResPath)) {
                ret = false;
            }
            if ((key = ((SymbolDescriptor)desc).getOverlayResourceKey()) == null) continue;
            ImageIcon image = (ImageIcon)this.resourceCollection.getRequiredObject(key);
            ((SymbolDescriptor)desc).setOverlayIcon(image);
        }
        for (Object desc : this.linkDescriptors.values()) {
            if (((LinkDescriptor)desc).initialize(skinResPath)) continue;
            ret = false;
        }
        this.valid = ret;
        return ret;
    }

    public void initalizeNewProcess(ProcessItem process) {
        process.setSkinName(this.getName());
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public Boolean isControlAnchorVisible() {
        return this.controlAnchorVisible;
    }

    public void setControlAnchorVisible(Boolean controlAnchorVisible) {
        this.controlAnchorVisible = controlAnchorVisible;
    }

    public Boolean isControlLinkVisible() {
        return this.controlLinkVisible;
    }

    public void setControlLinkVisible(Boolean controlLinkVisible) {
        this.controlLinkVisible = controlLinkVisible;
    }

    public Boolean isDataLinkVisible() {
        return this.dataLinkVisible;
    }

    public void setDataLinkVisible(Boolean dataLinkVisible) {
        this.dataLinkVisible = dataLinkVisible;
    }

    public Boolean isNameDisplay() {
        return this.nameDisplay;
    }

    public void setNameDisplay(Boolean nameDisplay) {
        this.nameDisplay = nameDisplay;
    }

    public boolean isRadialTags() {
        return this.radialTags;
    }

    public void setRadialTags(boolean radialTags) {
        this.radialTags = radialTags;
    }

    public boolean isDisableShadows() {
        return this.disableShadows;
    }

    public void setDisableShadows(boolean disableShadows) {
        this.disableShadows = disableShadows;
    }

    public boolean isDefaultSkin() {
        return this.defaultSkin;
    }

    public void setDefaultSkin(boolean defaultSkin) {
        this.defaultSkin = defaultSkin;
    }

    public String getParamTitleFormat() {
        return this.paramTitleFormat;
    }

    public void setParamTitleFormat(String paramTitleFormat) {
        this.paramTitleFormat = paramTitleFormat;
    }

    public String getSocketTitleFormat() {
        return this.socketTitleFormat;
    }

    public void setSocketTitleFormat(String socketTitleFormat) {
        this.socketTitleFormat = socketTitleFormat;
    }

    public String getNodeTitleFormat() {
        return this.nodeTitleFormat;
    }

    public void setNodeTitleFormat(String nodeTitleFormat) {
        this.nodeTitleFormat = nodeTitleFormat;
    }

    public SymbolDescriptor getSymbolDescriptor(String nodeType) {
        return (SymbolDescriptor)this.symbolDescriptors.get(nodeType);
    }

    public void addSymbolDescriptor(SymbolDescriptor symbolDescriptor) {
        this.symbolDescriptors.put(symbolDescriptor.getSymbolType(), symbolDescriptor);
    }

    public List getSymbolDescriptorList() {
        ArrayList list = new ArrayList();
        Iterator it = this.symbolDescriptors.values().iterator();
        while (it.hasNext()) {
            list.add(it.next());
        }
        return list;
    }

    public LinkDescriptor getLinkDescriptor(String linkType) {
        return (LinkDescriptor)this.linkDescriptors.get(linkType);
    }

    public void addLinkDescriptor(LinkDescriptor linkDescriptor) {
        this.linkDescriptors.put(linkDescriptor.getLinkType(), linkDescriptor);
    }

    public List getLinkDescriptorList() {
        ArrayList list = new ArrayList();
        Iterator it = this.linkDescriptors.values().iterator();
        while (it.hasNext()) {
            list.add(it.next());
        }
        return list;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public ResourceCollection getResource() {
        return this.resourceCollection;
    }

    public void setResourceCollection(ResourceCollection resourceCollection) {
        this.resourceCollection = resourceCollection;
    }
}

