/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.modeler.skins;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.openbp.cockpit.modeler.figures.generic.XFigureDescriptor;
import org.openbp.cockpit.modeler.skins.LinkDescriptor;
import org.openbp.cockpit.modeler.skins.Skin;
import org.openbp.cockpit.modeler.skins.SymbolDescriptor;
import org.openbp.common.CollectionUtil;
import org.openbp.common.ExceptionUtil;
import org.openbp.common.io.xml.XMLDriver;
import org.openbp.common.io.xml.XMLDriverException;
import org.openbp.common.logger.LogUtil;
import org.openbp.common.rc.ResourceCollection;
import org.openbp.common.rc.ResourceItem;
import org.openbp.common.resource.ResourceMgr;
import org.openbp.common.resource.ResourceMgrException;
import org.openbp.common.string.StringUtil;
import org.openbp.core.model.ModelException;
import org.openbp.guiclient.model.item.ItemIconMgr;
import org.springframework.core.io.Resource;

public final class SkinMgr {
    private Skin defaultSkin;
    private Map skins;
    private static SkinMgr singletonInstance;

    public static synchronized SkinMgr getInstance() {
        if (singletonInstance == null) {
            singletonInstance = new SkinMgr();
        }
        return singletonInstance;
    }

    private SkinMgr() {
    }

    public void load() {
        this.skins = new LinkedHashMap();
        this.loadSkins();
        this.determineDefaultSkin();
        this.addToIconModel(this.defaultSkin, null);
    }

    private void determineDefaultSkin() {
        for (Skin skin : this.skins.values()) {
            if (!skin.isDefaultSkin()) continue;
            this.defaultSkin = skin;
            break;
        }
    }

    private void addToIconModel(Skin skin, String skinName) {
        ResourceCollection res = skin.getResource();
        Iterator it = res.getKeys();
        while (it.hasNext()) {
            String key = (String)it.next();
            ResourceItem ri = res.getResourceItem(key);
            Object object = ri.getObject();
            if (!(object instanceof Icon)) continue;
            ItemIconMgr.getInstance().registerIcon(skinName, key, (Icon)object);
        }
    }

    public Skin getDefaultSkin() {
        return this.defaultSkin;
    }

    public Skin getSkin(String name) {
        return (Skin)((Object)this.skins.get(name));
    }

    public void addSkin(Skin skin) {
        this.skins.put(skin.getName(), skin);
    }

    public List getSkinList() {
        ArrayList list = new ArrayList();
        Iterator it = this.skins.values().iterator();
        while (it.hasNext()) {
            list.add(it.next());
        }
        return list;
    }

    public String[] getSkinNames() {
        int n = this.skins.size();
        String[] ret = new String[n];
        int i = 0;
        for (Skin skin : this.skins.values()) {
            ret[i++] = skin.getDisplayText();
        }
        return ret;
    }

    public Skin[] getSkins() {
        List skinList = this.getSkinList();
        return (Skin[])CollectionUtil.toArray((Collection)skinList, Skin.class);
    }

    private void loadSkins() {
        XMLDriver xmlDriver = XMLDriver.getInstance();
        xmlDriver.loadMapping(XFigureDescriptor.class);
        xmlDriver.loadMapping(LinkDescriptor.class);
        xmlDriver.loadMapping(SymbolDescriptor.class);
        xmlDriver.loadMapping(Skin.class);
        ResourceMgr resMgr = ResourceMgr.getDefaultInstance();
        String resourcePattern = "skin/*.xml";
        Resource[] resources = null;
        try {
            resources = resMgr.findResources(resourcePattern);
        }
        catch (ResourceMgrException e) {
            throw new ModelException("MissingItemTypeDescriptors", "No item type files found matching '" + resourcePattern + "'.");
        }
        if (resources.length == 0) {
            throw new ModelException("MissingItemTypeDescriptors", "No skin definitions found in resource path 'skin'.");
        }
        ArrayList errorMsgs = new ArrayList();
        for (int i = 0; i < resources.length; ++i) {
            Skin skin = null;
            try {
                skin = (Skin)((Object)xmlDriver.deserializeResource(Skin.class, resources[i]));
            }
            catch (XMLDriverException e) {
                ExceptionUtil.printTrace((Throwable)e);
                continue;
            }
            errorMsgs.clear();
            String skinResPath = StringUtil.buildPath((String)"skin", (String)skin.getName());
            if (!skin.validate(skinResPath, errorMsgs)) {
                StringBuffer sb = new StringBuffer();
                int nErros = errorMsgs.size();
                for (int iErrors = 0; iErrors < nErros; ++iErrors) {
                    if (iErrors > 0) {
                        sb.append('\n');
                    }
                    sb.append((String)errorMsgs.get(iErrors));
                }
                LogUtil.error(this.getClass(), (String)"Invalid skin descriptor $0:\n{1}", (Object)skin.getName(), (Object)sb.toString());
                continue;
            }
            if (!skin.initialize(skinResPath)) continue;
            this.addToIconModel(skin, skin.getName());
            this.addSkin(skin);
        }
    }
}

