/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.modeler.tools;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.Figure;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import org.openbp.cockpit.modeler.drawing.DrawingEditorPlugin;
import org.openbp.cockpit.modeler.drawing.Trackable;
import org.openbp.cockpit.modeler.drawing.WorkspaceDrawingView;
import org.openbp.cockpit.modeler.tools.ModelerToolSupport;

public abstract class ModelerTool {
    private ModelerToolSupport toolSupport;
    private Cursor toolCursor;
    private String toolHintMsg;
    private Object affectedObject;

    public ModelerTool(ModelerToolSupport toolSupport) {
        this.toolSupport = toolSupport;
    }

    public boolean appliesTo(Object affectedObject) {
        return true;
    }

    public Cursor getToolCursor() {
        return this.toolCursor;
    }

    public void setToolCursor(Cursor toolCursor) {
        this.toolCursor = toolCursor;
    }

    public String getToolHintMsg() {
        return this.toolHintMsg;
    }

    public void setToolHintMsg(String toolHintMsg) {
        this.toolHintMsg = toolHintMsg;
    }

    public Figure getAffectedFigure() {
        return (Figure)this.affectedObject;
    }

    public Object getAffectedObject() {
        return this.affectedObject;
    }

    public void setAffectedObject(Object affectedObject) {
        this.affectedObject = affectedObject;
    }

    public DrawingEditorPlugin getEditor() {
        return this.toolSupport.getEditor();
    }

    public WorkspaceDrawingView getView() {
        return this.toolSupport.getView();
    }

    public Drawing getDrawing() {
        return this.toolSupport.getView().drawing();
    }

    public Point getLastPoint() {
        return this.toolSupport.getLastPoint();
    }

    public ModelerToolSupport getToolSupport() {
        return this.toolSupport;
    }

    public void activate() {
        if (this.getEditor() instanceof Trackable) {
            ((Trackable)((Object)this.getEditor())).suspendTrack();
        }
    }

    public void deactivate() {
        this.getEditor().cancelUndo();
        if (this.getEditor() instanceof Trackable) {
            ((Trackable)((Object)this.getEditor())).resumeTrack();
        }
        this.setAffectedObject(null);
        this.toolSupport.clearTool();
    }

    public void mouseMove(MouseEvent e, int x, int y) {
    }

    public void mouseDown(MouseEvent e, int x, int y) {
    }

    public void mouseUp(MouseEvent e, int x, int y) {
        this.deactivate();
    }

    public void mouseDrag(MouseEvent e, int x, int y) {
    }

    public void keyDown(KeyEvent e, int key) {
    }

    public void keyUp(KeyEvent e, int key) {
        this.deactivate();
    }
}

