/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.modeler.tools;

import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Handle;
import java.awt.event.MouseEvent;
import org.openbp.cockpit.modeler.tools.ModelerTool;
import org.openbp.cockpit.modeler.tools.ModelerToolSupport;
import org.openbp.common.generic.Modifiable;

public class XHandleTracker
extends ModelerTool {
    private Handle handle;
    private int anchorX;
    private int anchorY;

    public XHandleTracker(ModelerToolSupport toolSupport) {
        super(toolSupport);
    }

    @Override
    public void setAffectedObject(Object affectedObject) {
        super.setAffectedObject(affectedObject);
        this.handle = (Handle)affectedObject;
    }

    @Override
    public void deactivate() {
        this.handle = null;
        super.deactivate();
    }

    @Override
    public void mouseDown(MouseEvent e, int x, int y) {
        super.mouseDown(e, x, y);
        this.getEditor().startUndo("Move Handle");
        this.anchorX = x;
        this.anchorY = y;
        this.handle.invokeStart(x, y, (DrawingView)this.getView());
    }

    @Override
    public void mouseDrag(MouseEvent e, int x, int y) {
        super.mouseDrag(e, x, y);
        this.handle.invokeStep(x, y, this.anchorX, this.anchorY, (DrawingView)this.getView());
    }

    @Override
    public void mouseUp(MouseEvent e, int x, int y) {
        boolean moved;
        boolean bl = moved = Math.abs(x - this.anchorX) > 4 || Math.abs(y - this.anchorY) > 4;
        if (moved) {
            ((Modifiable)this.getDrawing()).setModified();
            if (this.getEditor().isUndoRecording()) {
                this.getEditor().endUndo();
            }
        }
        this.handle.invokeEnd(x, y, this.anchorX, this.anchorY, (DrawingView)this.getView());
        super.mouseUp(e, x, y);
    }
}

