/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.modeler.tools;

import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import org.openbp.cockpit.modeler.drawing.ProcessDrawing;
import org.openbp.cockpit.modeler.drawing.WorkspaceDrawingView;
import org.openbp.cockpit.modeler.tools.ModelerTool;
import org.openbp.cockpit.modeler.tools.ModelerToolSupport;

public class ZoomTool
extends ModelerTool {
    public ZoomTool(ModelerToolSupport toolSupport) {
        super(toolSupport);
    }

    @Override
    public void mouseMove(MouseEvent e, int x, int y) {
        WorkspaceDrawingView view = this.getView();
        Point lastPoint = this.getLastPoint();
        int diff = (e.getX() - lastPoint.x) / 2;
        if (diff != 0) {
            ((ProcessDrawing)this.getDrawing()).invalidate();
            double scaleFactor = view.getScaleFactor();
            view.setScaleFactor(scaleFactor *= (100.0 + (double)diff) / 100.0);
            view.redraw();
        }
    }

    @Override
    public void deactivate() {
        this.getView().revalidate();
        super.deactivate();
    }

    @Override
    public void keyDown(KeyEvent e, int key) {
    }

    @Override
    public void keyUp(KeyEvent e, int key) {
        this.deactivate();
    }
}

