/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.modeler.undo;

import org.openbp.cockpit.modeler.Modeler;
import org.openbp.jaspira.action.JaspiraActionEvent;
import org.openbp.jaspira.event.JaspiraEvent;
import org.openbp.jaspira.event.JaspiraEventHandlerCode;
import org.openbp.jaspira.option.IntegerOption;
import org.openbp.jaspira.plugin.AbstractPlugin;
import org.openbp.jaspira.plugin.EventModule;
import org.openbp.jaspira.plugin.OptionModule;
import org.openbp.jaspira.undo.UndoMgr;

public class ModelerUndoPlugin
extends AbstractPlugin {
    private Modeler currentModeler;

    @Override
    public String getResourceCollectionContainerName() {
        return "plugin.modeler";
    }

    public class UndoOptions
    extends OptionModule {

        public class TransitionOption
        extends IntegerOption {
            public TransitionOption() {
                super(ModelerUndoPlugin.this.getPluginResourceCollection(), "undo.history", new Integer(25), 0, 100);
            }
        }
    }

    public class Events
    extends EventModule {
        @Override
        public String getName() {
            return "undo";
        }

        @Override
        public int getPriority() {
            return 101;
        }

        public JaspiraEventHandlerCode undo(JaspiraActionEvent je) {
            UndoMgr undoMgr;
            if (ModelerUndoPlugin.this.currentModeler != null && (undoMgr = ModelerUndoPlugin.this.currentModeler.getUndoMgr()).canUndo()) {
                undoMgr.undo();
                return EVENT_CONSUMED;
            }
            return EVENT_IGNORED;
        }

        public JaspiraEventHandlerCode redo(JaspiraActionEvent je) {
            UndoMgr undoMgr;
            if (ModelerUndoPlugin.this.currentModeler != null && (undoMgr = ModelerUndoPlugin.this.currentModeler.getUndoMgr()).canRedo()) {
                undoMgr.redo();
                return EVENT_CONSUMED;
            }
            return EVENT_IGNORED;
        }

        public JaspiraEventHandlerCode modeler_view_activated(JaspiraEvent je) {
            ModelerUndoPlugin.this.currentModeler = (Modeler)je.getObject();
            UndoMgr undoMgr = ModelerUndoPlugin.this.currentModeler.getUndoMgr();
            undoMgr.updateActions();
            return EVENT_HANDLED;
        }

        public JaspiraEventHandlerCode modeler_view_closed(JaspiraEvent je) {
            ModelerUndoPlugin.this.currentModeler = null;
            return EVENT_HANDLED;
        }
    }
}

