/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.modeler.util;

import CH.ifa.draw.framework.DrawingView;
import org.openbp.cockpit.modeler.util.Animatable;
import org.openbp.jaspira.event.JaspiraEvent;

public class Animator
extends Thread {
    private DrawingView view;
    private Animatable animatable;
    private final int delay;
    private boolean isRunning;
    private JaspiraEvent endEvent;

    public Animator(Animatable animatable, DrawingView view, int delay, JaspiraEvent endEvent) {
        super("Animator");
        this.animatable = animatable;
        this.view = view;
        this.delay = delay;
        this.endEvent = endEvent;
        this.setDaemon(true);
    }

    public void startAnimation() {
        this.isRunning = true;
        this.animatable.animationStart();
        this.start();
    }

    public void stopAnimation() {
        this.isRunning = false;
        this.animatable.animationEnd();
        if (this.endEvent != null) {
            this.endEvent.getSourcePlugin().fireEvent(this.endEvent);
        }
    }

    @Override
    public void run() {
        while (this.isRunning) {
            long tm = System.currentTimeMillis();
            this.animatable.animationStep();
            this.view.checkDamage();
            try {
                Thread.sleep(Math.max(0L, (tm += (long)this.delay) - System.currentTimeMillis()));
            }
            catch (InterruptedException e) {
                break;
            }
        }
    }
}

