/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.modeler.util;

import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.standard.CompositeFigure;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.openbp.cockpit.modeler.ModelerColors;
import org.openbp.cockpit.modeler.figures.VisualElement;
import org.openbp.cockpit.modeler.figures.generic.TitleFigure;
import org.openbp.cockpit.modeler.figures.generic.XFigure;
import org.openbp.cockpit.modeler.skins.Skin;
import org.openbp.cockpit.modeler.skins.SkinMgr;
import org.openbp.cockpit.modeler.skins.SymbolDescriptor;
import org.openbp.common.CommonUtil;
import org.openbp.common.generic.description.DisplayObject;
import org.openbp.core.model.ModelObject;
import org.openbp.core.model.item.Item;
import org.openbp.core.model.item.activity.ActivityItem;
import org.openbp.core.model.item.process.FinalNode;
import org.openbp.core.model.item.process.InitialNode;
import org.openbp.core.model.item.process.Node;
import org.openbp.core.model.item.process.NodeProvider;
import org.openbp.core.model.item.process.ProcessItem;
import org.openbp.guiclient.plugins.displayobject.DisplayObjectPlugin;

public class FigureUtil {
    private FigureUtil() {
    }

    public static Figure findInnermostFigure(Figure figure, int x, int y, Class figureClass) {
        Figure cc;
        Figure child = FigureUtil.findChildFigure(figure, x, y, figureClass);
        if (child != null && (cc = FigureUtil.findInnermostFigure(child, x, y, figureClass)) != null) {
            return cc;
        }
        return figure;
    }

    public static Figure findChildFigure(Figure figure, int x, int y, Class figureClass) {
        if (figure instanceof CompositeFigure) {
            FigureEnumeration fe = ((CompositeFigure)figure).figures();
            while (fe.hasMoreElements()) {
                Figure child = fe.nextFigure();
                if (figureClass != null && !figureClass.isInstance(child) || !child.containsPoint(x, y)) continue;
                return child;
            }
        }
        return null;
    }

    public static List getTypedFigureList(Figure parentFigure, Class figureClass) {
        ArrayList<Object> result = null;
        FigureEnumeration fe = parentFigure.figures();
        while (fe.hasMoreElements()) {
            Object o = fe.nextElement();
            if (!figureClass.isInstance(o)) continue;
            if (result == null) {
                result = new ArrayList<Object>();
            }
            result.add(o);
        }
        return result;
    }

    public static XFigure createShadowFigure(XFigure presentationFigure) {
        if (presentationFigure.getFillColor() == null && presentationFigure.getDefaultFillColor() == null) {
            return null;
        }
        XFigure shadow = (XFigure)presentationFigure.clone();
        shadow.setParent(null);
        shadow.setFillColor(ModelerColors.SHADOW_FILL);
        shadow.setFillColor2(ModelerColors.SHADOW_FILL);
        shadow.setFrameColor(ModelerColors.SHADOW_BORDER);
        shadow.invalidate();
        return shadow;
    }

    public static boolean isVerticalRelationship(Figure f1, Figure f2) {
        int f1X = f1.center().x;
        int f1Y = f1.center().y;
        int f2X = f2.center().x;
        int f2Y = f2.center().y;
        return Math.abs(f1Y - f2Y) > Math.abs(f1X - f2X);
    }

    public static boolean synchronizeText(TitleFigure figure) {
        DisplayObject client = figure.getClient();
        if (client == null) {
            figure.setText("");
            return false;
        }
        String format = figure.getTitleFormat();
        if (format == null) {
            format = "$text";
        }
        StringBuffer sb = new StringBuffer();
        int n = format.length();
        int i = 0;
        while (i < n) {
            char c = format.charAt(i);
            if (format.startsWith("$name", i)) {
                sb.append(client.getName());
                i += 5;
                continue;
            }
            if (format.startsWith("$text", i)) {
                String t = null;
                if (DisplayObjectPlugin.getInstance().isTitleModeText()) {
                    t = figure.isVerboseDisplay() ? client.getDisplayText() : client.getDisplayName();
                } else if (figure.isVerboseDisplay()) {
                    t = client.getName();
                }
                if (t != null) {
                    sb.append(t);
                }
                i += 5;
                continue;
            }
            sb.append(c);
            ++i;
        }
        String oldText = figure.getText();
        String newText = sb.toString();
        figure.willChange();
        figure.setText(newText);
        figure.changed();
        return CommonUtil.equalsNull((Object)oldText, (Object)newText);
    }

    public static Image combineImages(Image base, Image overlay, int x, int y, int overlayWidth, int overlayHeight) {
        BufferedImage result = null;
        try {
            int baseWidth = base.getWidth(null);
            int baseHeight = base.getHeight(null);
            if (overlayWidth == 0) {
                overlayWidth = overlay.getWidth(null);
            }
            if (overlayHeight == 0) {
                overlayHeight = overlay.getHeight(null);
            }
            if (x + overlayWidth > baseWidth) {
                x = baseWidth - overlayWidth;
            }
            if (x < 0) {
                x = 0;
            }
            if (y + overlayHeight > baseHeight) {
                y = baseHeight - overlayHeight;
            }
            if (y < 0) {
                y = 0;
            }
            result = new BufferedImage(baseWidth, baseHeight, 1);
            Graphics2D g = (Graphics2D)((Image)result).getGraphics();
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
            g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g.setBackground(new Color(255, 255, 255, 255));
            g.clearRect(0, 0, baseWidth, baseHeight);
            g.drawImage(base, 0, 0, null);
            g.drawImage(overlay, x, y, null);
            g.dispose();
        }
        catch (Exception e) {
            // empty catch block
        }
        return result;
    }

    public static Image copyImage(Image image) {
        Image result = null;
        if (image != null) {
            try {
                int w = image.getWidth(null);
                int h = image.getHeight(null);
                int[] pixels = new int[w * h];
                PixelGrabber grabber = new PixelGrabber(image, 0, 0, w, h, pixels, 0, w);
                grabber.grabPixels();
                if ((grabber.getStatus() & 0x80) != 0) {
                    return null;
                }
                MemoryImageSource source = new MemoryImageSource(w, h, pixels, 0, w);
                result = Toolkit.getDefaultToolkit().createImage(source);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public static Skin determineProcessSkin(ProcessItem process) {
        Skin skin = null;
        String skinName = process.getSkinName();
        if (skinName == null || (skin = SkinMgr.getInstance().getSkin(skinName)) == null) {
            // empty if block
        }
        if (skin == null) {
            skin = SkinMgr.getInstance().getDefaultSkin();
        }
        return skin;
    }

    public static void updateSkin(Figure figure) {
        if (figure instanceof VisualElement) {
            ((VisualElement)figure).updatePresentationFigure();
        }
        if (figure instanceof CompositeFigure) {
            FigureEnumeration en = ((CompositeFigure)figure).figures();
            while (en.hasMoreElements()) {
                Figure subFigure = en.nextFigure();
                FigureUtil.updateSkin(subFigure);
            }
        }
    }

    public static SymbolDescriptor getSymbolDescriptorForModelObject(Skin skin, ModelObject o) {
        SymbolDescriptor desc = null;
        String nodeType = o.getModelObjectSymbolName();
        if (nodeType != null) {
            desc = skin.getSymbolDescriptor(nodeType);
        }
        if (desc == null) {
            desc = skin.getSymbolDescriptor("Node");
        }
        return desc;
    }

    public static void updateItemGeometry(Skin skin, Item item) {
        int size;
        if (!(item instanceof NodeProvider)) {
            return;
        }
        double factor = 1.0;
        int additionalSockets = 0;
        if (item instanceof ProcessItem) {
            ProcessItem process = (ProcessItem)item;
            size = 50;
            String processType = process.getProcessType();
            if ("UseCase".equals(processType) || "TopLevel".equals(processType)) {
                factor = 2.0;
            }
            Iterator it = process.getNodes();
            while (it.hasNext()) {
                Node node = (Node)it.next();
                if (!(node instanceof InitialNode) && !(node instanceof FinalNode)) continue;
                ++additionalSockets;
            }
            if ((additionalSockets -= 2) > 0) {
                size += 50 * additionalSockets / 2;
            }
            process.setNodeGeometry("size:" + size);
        } else if (item instanceof ActivityItem) {
            ActivityItem action = (ActivityItem)item;
            additionalSockets = action.getNumberOfSockets() - 2;
            if (additionalSockets > 0) {
                size = 50;
                size += additionalSockets / 2 * size;
            }
        } else {
            return;
        }
        if (skin == null) {
            skin = SkinMgr.getInstance().getDefaultSkin();
        }
        SymbolDescriptor desc = FigureUtil.getSymbolDescriptorForModelObject(skin, (ModelObject)item);
        int width = desc.getSizeX();
        int height = desc.getSizeY();
        if (additionalSockets > 0) {
            factor += (double)(additionalSockets / 2);
        }
        width = (int)((double)width * factor);
        height = (int)((double)height * factor);
        String geometry = "size:" + width + ":" + height;
        if (item instanceof ProcessItem) {
            ((ProcessItem)item).setNodeGeometry(geometry);
        } else {
            ((ActivityItem)item).setGeometry(geometry);
        }
    }

    public static String printInt(double d) {
        return Long.toString(Math.round(d));
    }
}

