/*
 * Decompiled with CFR 0.152.
 */
package org.openbp.cockpit.modeler.util;

import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;

public class InputState {
    public static final int SHIFT = 1;
    public static final int CTRL = 2;
    public static final int META = 4;
    public static final int ALT = 8;
    public static final int ALT_GRAPH = 32;
    public static final int BUTTON1 = 256;
    public static final int BUTTON2 = 512;
    public static final int BUTTON3 = 1024;
    public static final int HOVER = 2048;
    public static final int KEY_STATES = 47;
    public static final int MOUSE_STATES = 1792;
    private static int state;

    private InputState() {
    }

    public static int getState() {
        return state;
    }

    public static void setState(int newState) {
        state = newState;
    }

    public static void updateStateOnInputEvent(InputEvent e) {
        state &= 0xFFFFFFD0;
        state |= e.getModifiers() & 0x2F;
    }

    public static void updateStateOnMouseDownEvent(MouseEvent e) {
        int mod = e.getModifiers();
        if ((mod & 0x10) != 0) {
            state |= 0x100;
        }
        if ((mod & 8) != 0) {
            state |= 0x200;
        }
        if ((mod & 4) != 0) {
            state |= 0x400;
        }
    }

    public static void updateStateOnMouseUpEvent(MouseEvent e) {
        int mod = e.getModifiers();
        if ((mod & 0x10) != 0) {
            state &= 0xFFFFFEFF;
        }
        if ((mod & 8) != 0) {
            state &= 0xFFFFFDFF;
        }
        if ((mod & 4) != 0) {
            state &= 0xFFFFFBFF;
        }
    }

    public static boolean isShiftDown() {
        return (state & 1) != 0;
    }

    public static boolean isCtrlDown() {
        return (state & 2) != 0;
    }

    public static boolean isMetaDown() {
        return (state & 4) != 0;
    }

    public static boolean isAltDown() {
        return (state & 8) != 0;
    }

    public static boolean isAltGraphDown() {
        return (state & 0x20) != 0;
    }

    public static boolean isLeftButtonDown() {
        return (state & 0x100) != 0;
    }

    public static boolean isMiddleButtonDown() {
        return (state & 0x200) != 0;
    }

    public static boolean isRightButtonDown() {
        return (state & 0x400) != 0;
    }
}

